/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractMessage;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.SingleFieldBuilderV3;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class RepeatedFieldBuilderV3<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
implements AbstractMessage.BuilderParent {
    private AbstractMessage.BuilderParent parent;
    private List<MType> messages;
    private boolean isMessagesListMutable;
    private List<SingleFieldBuilderV3<MType, BType, IType>> builders;
    private boolean isClean;
    private MessageExternalList<MType, BType, IType> externalMessageList;
    private BuilderExternalList<MType, BType, IType> externalBuilderList;
    private MessageOrBuilderExternalList<MType, BType, IType> externalMessageOrBuilderList;

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    public RepeatedFieldBuilderV3(List messages, boolean isMessagesListMutable, GeneratedMessageV3.BuilderParent parent, boolean isClean) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.messages = var1_1;
        this.isMessagesListMutable = var2_2;
        this.parent = var3_3;
        this.isClean = isClean;
    }

    public final void dispose() {
        this.parent = null;
    }

    private void ensureMutableMessageList() {
        if (!this.isMessagesListMutable) {
            this.messages = new ArrayList<MType>(this.messages);
            this.isMessagesListMutable = true;
        }
    }

    public final int getCount() {
        return this.messages.size();
    }

    public final boolean isEmpty() {
        return this.messages.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public final MType getMessage(int index) {
        void var1_1;
        return this.getMessage((int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private MType getMessage(int index, boolean forBuild) {
        void var3_3;
        void var2_2;
        if (this.builders == null) {
            return (MType)((AbstractMessage)this.messages.get(index));
        }
        SingleFieldBuilderV3<MType, BType, IType> builder = this.builders.get(index);
        if (builder == null) {
            void var1_1;
            return (MType)((AbstractMessage)this.messages.get((int)var1_1));
        }
        if (var2_2 != false) {
            return builder.build();
        }
        return var3_3.getMessage();
    }

    /*
     * WARNING - void declaration
     */
    public final RepeatedFieldBuilderV3<MType, BType, IType> addMessage(MType message) {
        void var1_1;
        Internal.checkNotNull(message);
        this.ensureMutableMessageList();
        this.messages.add(var1_1);
        if (this.builders != null) {
            this.builders.add(null);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final RepeatedFieldBuilderV3<MType, BType, IType> addAllMessages(Iterable<? extends MType> values) {
        for (Object object : values) {
            Internal.checkNotNull(object);
        }
        int size = -1;
        if (values instanceof Collection) {
            Object object;
            Collection collection = (Collection)values;
            if (collection.isEmpty()) {
                return this;
            }
            size = object.size();
        }
        this.ensureMutableMessageList();
        if (size >= 0 && this.messages instanceof ArrayList) {
            void var2_3;
            ((ArrayList)this.messages).ensureCapacity(this.messages.size() + var2_3);
        }
        for (AbstractMessage value : values) {
            void var1_1;
            this.addMessage(var1_1);
        }
        this.onChanged();
        this.incrementModCounts();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final List<MType> build() {
        int i;
        this.isClean = true;
        if (!this.isMessagesListMutable && this.builders == null) {
            return this.messages;
        }
        boolean allMessagesInSync = true;
        if (!this.isMessagesListMutable) {
            void var1_1;
            for (i = 0; i < this.messages.size(); ++i) {
                void var3_3;
                Message message = (Message)this.messages.get(i);
                SingleFieldBuilderV3<MType, BType, IType> builder = this.builders.get(i);
                if (builder == null || builder.build() == var3_3) continue;
                allMessagesInSync = false;
                break;
            }
            if (var1_1 != false) {
                return this.messages;
            }
        }
        this.ensureMutableMessageList();
        for (i = 0; i < this.messages.size(); ++i) {
            this.messages.set(i, this.getMessage(i, true));
        }
        this.messages = Collections.unmodifiableList(this.messages);
        this.isMessagesListMutable = false;
        return this.messages;
    }

    private void onChanged() {
        if (this.isClean && this.parent != null) {
            this.parent.markDirty();
            this.isClean = false;
        }
    }

    @Override
    public final void markDirty() {
        this.onChanged();
    }

    private void incrementModCounts() {
    }

    private static final class MessageOrBuilderExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<IType>
    implements List<IType>,
    RandomAccess {
        @Override
        public final int size() {
            MessageOrBuilderExternalList messageOrBuilderExternalList = this;
            throw null;
        }
    }

    private static final class BuilderExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<BType>
    implements List<BType>,
    RandomAccess {
        @Override
        public final int size() {
            BuilderExternalList builderExternalList = this;
            throw null;
        }
    }

    private static final class MessageExternalList<MType extends AbstractMessage, BType extends AbstractMessage.Builder, IType extends MessageOrBuilder>
    extends AbstractList<MType>
    implements List<MType>,
    RandomAccess {
        @Override
        public final int size() {
            MessageExternalList messageExternalList = this;
            throw null;
        }
    }
}

