/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormat;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class UnknownFieldSet
implements MessageLite {
    private final TreeMap<Integer, Field> fields;
    private static final UnknownFieldSet defaultInstance = new UnknownFieldSet(new TreeMap<Integer, Field>());
    private static final Parser PARSER = new Parser();

    /*
     * WARNING - void declaration
     */
    private UnknownFieldSet(TreeMap<Integer, Field> fields) {
        void var1_1;
        this.fields = var1_1;
    }

    public static Builder newBuilder() {
        return Builder.access$000();
    }

    public static Builder newBuilder(UnknownFieldSet copyFrom) {
        UnknownFieldSet unknownFieldSet;
        return Builder.access$000().mergeFrom(unknownFieldSet);
    }

    public static UnknownFieldSet getDefaultInstance() {
        return defaultInstance;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        return other instanceof UnknownFieldSet && this.fields.equals(((UnknownFieldSet)var1_1).fields);
    }

    public final int hashCode() {
        if (this.fields.isEmpty()) {
            return 0;
        }
        return this.fields.hashCode();
    }

    public final Map<Integer, Field> asMap() {
        return (Map)this.fields.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeTo(CodedOutputStream output) throws IOException {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            void var3_3;
            Field field = entry.getValue();
            field.writeTo((Integer)var3_3.getKey(), output);
        }
    }

    public final String toString() {
        return TextFormat.printer().printToString(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ByteString toByteString() {
        try {
            ByteString.CodedBuilder out = ByteString.newCodedBuilder(this.getSerializedSize());
            this.writeTo(out.getCodedOutput());
            return out.build$2036f13b();
        }
        catch (IOException e) {
            void var1_2;
            throw new RuntimeException("Serializing to a ByteString threw an IOException (should never happen).", (Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int getSerializedSize() {
        void var1_1;
        int result = 0;
        if (!this.fields.isEmpty()) {
            for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
                void var3_3;
                result += entry.getValue().getSerializedSize((Integer)var3_3.getKey());
            }
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeAsMessageSetTo(CodedOutputStream output) throws IOException {
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            void var3_3;
            entry.getValue().writeAsMessageSetExtensionTo((Integer)var3_3.getKey(), output);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSizeAsMessageSet() {
        void var1_1;
        int result = 0;
        for (Map.Entry<Integer, Field> entry : this.fields.entrySet()) {
            void var3_3;
            result += entry.getValue().getSerializedSizeAsMessageSetExtension((Integer)var3_3.getKey());
        }
        return (int)var1_1;
    }

    @Override
    public final boolean isInitialized() {
        return true;
    }

    public static UnknownFieldSet parseFrom(ByteString data) throws InvalidProtocolBufferException {
        ByteString byteString;
        return Builder.access$000().mergeFrom(byteString).build();
    }

    /*
     * WARNING - void declaration
     */
    /* synthetic */ UnknownFieldSet(TreeMap x0, byte by) {
        this((TreeMap<Integer, Field>)var1_1);
        void var1_1;
    }

    public static final class Parser
    extends AbstractParser<UnknownFieldSet> {
        /*
         * WARNING - void declaration
         */
        private static UnknownFieldSet parsePartialFrom$1b163419(CodedInputStream input) throws InvalidProtocolBufferException {
            void var1_2;
            Builder builder = UnknownFieldSet.newBuilder();
            try {
                builder.mergeFrom((CodedInputStream)input);
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                input = invalidProtocolBufferException;
                throw invalidProtocolBufferException.setUnfinishedMessage(builder.buildPartial());
            }
            catch (IOException e) {
                void var0_1;
                throw new InvalidProtocolBufferException((IOException)var0_1).setUnfinishedMessage(builder.buildPartial());
            }
            return var1_2.buildPartial();
        }
    }

    public static final class Field {
        private List<Long> varint;
        private List<Integer> fixed32;
        private List<Long> fixed64;
        private List<ByteString> lengthDelimited;
        private List<UnknownFieldSet> group;

        private Field() {
        }

        public static Builder newBuilder() {
            return builder = new Builder();
        }

        public static Builder newBuilder(Field copyFrom) {
            Field field;
            return (builder = new Builder()).mergeFrom(field);
        }

        public final List<Long> getVarintList() {
            return this.varint;
        }

        public final List<Integer> getFixed32List() {
            return this.fixed32;
        }

        public final List<Long> getFixed64List() {
            return this.fixed64;
        }

        public final List<ByteString> getLengthDelimitedList() {
            return this.lengthDelimited;
        }

        public final List<UnknownFieldSet> getGroupList() {
            return this.group;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (!(other instanceof Field)) {
                return false;
            }
            return Arrays.equals(this.getIdentityArray(), ((Field)var1_1).getIdentityArray());
        }

        public final int hashCode() {
            return Arrays.hashCode(this.getIdentityArray());
        }

        private Object[] getIdentityArray() {
            return new Object[]{this.varint, this.fixed32, this.fixed64, this.lengthDelimited, this.group};
        }

        public final void writeTo(int fieldNumber, CodedOutputStream output) throws IOException {
            Iterator<Object> iterator = this.varint.iterator();
            while (iterator.hasNext()) {
                long value = iterator.next();
                output.writeUInt64(fieldNumber, value);
            }
            iterator = this.fixed32.iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                output.writeFixed32(fieldNumber, value);
            }
            iterator = this.fixed64.iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                output.writeFixed64(fieldNumber, value);
            }
            for (ByteString value : this.lengthDelimited) {
                output.writeBytes(fieldNumber, value);
            }
            for (UnknownFieldSet value : this.group) {
                output.writeGroup(fieldNumber, value);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int getSerializedSize(int fieldNumber) {
            void var2_2;
            int result = 0;
            Iterator<Object> iterator = this.varint.iterator();
            while (iterator.hasNext()) {
                long value = iterator.next();
                result += CodedOutputStream.computeUInt64Size(fieldNumber, value);
            }
            iterator = this.fixed32.iterator();
            while (iterator.hasNext()) {
                int value = (Integer)iterator.next();
                result += CodedOutputStream.computeFixed32Size(fieldNumber, value);
            }
            iterator = this.fixed64.iterator();
            while (iterator.hasNext()) {
                long value = (Long)iterator.next();
                result += CodedOutputStream.computeFixed64Size(fieldNumber, value);
            }
            for (ByteString value : this.lengthDelimited) {
                result += CodedOutputStream.computeBytesSize(fieldNumber, value);
            }
            for (UnknownFieldSet value : this.group) {
                result += CodedOutputStream.computeGroupSize$18fe156d(fieldNumber, value);
            }
            return (int)var2_2;
        }

        public final void writeAsMessageSetExtensionTo(int fieldNumber, CodedOutputStream output) throws IOException {
            for (ByteString value : this.lengthDelimited) {
                output.writeRawMessageSetExtension(fieldNumber, value);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int getSerializedSizeAsMessageSetExtension(int fieldNumber) {
            void var2_2;
            int result = 0;
            for (ByteString value : this.lengthDelimited) {
                result += CodedOutputStream.computeRawMessageSetExtensionSize(fieldNumber, value);
            }
            return (int)var2_2;
        }

        /* synthetic */ Field(byte by) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ List access$602(Field x0, List x1) {
            void var1_1;
            x0.varint = var1_1;
            return x0.varint;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ List access$702(Field x0, List x1) {
            void var1_1;
            x0.fixed32 = var1_1;
            return x0.fixed32;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ List access$802(Field x0, List x1) {
            void var1_1;
            x0.fixed64 = var1_1;
            return x0.fixed64;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ List access$902(Field x0, List x1) {
            void var1_1;
            x0.lengthDelimited = var1_1;
            return x0.lengthDelimited;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ List access$1002(Field x0, List x1) {
            void var1_1;
            x0.group = var1_1;
            return x0.group;
        }

        static {
            (builder = new Builder()).build();
        }

        public static final class Builder {
            private Field result = new Field(0);

            private Builder() {
            }

            /*
             * WARNING - void declaration
             */
            public final Builder clone() {
                void var2_2;
                void var1_1;
                Field copy = new Field(0);
                if (this.result.varint == null) {
                    Field.access$602(copy, null);
                } else {
                    Field.access$602(copy, new ArrayList(this.result.varint));
                }
                if (this.result.fixed32 == null) {
                    Field.access$702(copy, null);
                } else {
                    Field.access$702(copy, new ArrayList(this.result.fixed32));
                }
                if (this.result.fixed64 == null) {
                    Field.access$802(copy, null);
                } else {
                    Field.access$802(copy, new ArrayList(this.result.fixed64));
                }
                if (this.result.lengthDelimited == null) {
                    Field.access$902(copy, null);
                } else {
                    Field.access$902(copy, new ArrayList(this.result.lengthDelimited));
                }
                if (this.result.group == null) {
                    Field.access$1002(copy, null);
                } else {
                    Field.access$1002(copy, new ArrayList(this.result.group));
                }
                Builder clone = new Builder();
                new Builder().result = var1_1;
                return var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final Field build() {
                void var1_1;
                Field built = new Field(0);
                if (this.result.varint == null) {
                    Field.access$602(built, Collections.emptyList());
                } else {
                    Field.access$602(built, Collections.unmodifiableList(new ArrayList(this.result.varint)));
                }
                if (this.result.fixed32 == null) {
                    Field.access$702(built, Collections.emptyList());
                } else {
                    Field.access$702(built, Collections.unmodifiableList(new ArrayList(this.result.fixed32)));
                }
                if (this.result.fixed64 == null) {
                    Field.access$802(built, Collections.emptyList());
                } else {
                    Field.access$802(built, Collections.unmodifiableList(new ArrayList(this.result.fixed64)));
                }
                if (this.result.lengthDelimited == null) {
                    Field.access$902(built, Collections.emptyList());
                } else {
                    Field.access$902(built, Collections.unmodifiableList(new ArrayList(this.result.lengthDelimited)));
                }
                if (this.result.group == null) {
                    Field.access$1002(built, Collections.emptyList());
                } else {
                    Field.access$1002(built, Collections.unmodifiableList(new ArrayList(this.result.group)));
                }
                return var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final Builder mergeFrom(Field other) {
                if (!other.varint.isEmpty()) {
                    if (this.result.varint == null) {
                        Field.access$602(this.result, new ArrayList());
                    }
                    this.result.varint.addAll(other.varint);
                }
                if (!other.fixed32.isEmpty()) {
                    if (this.result.fixed32 == null) {
                        Field.access$702(this.result, new ArrayList());
                    }
                    this.result.fixed32.addAll(other.fixed32);
                }
                if (!other.fixed64.isEmpty()) {
                    if (this.result.fixed64 == null) {
                        Field.access$802(this.result, new ArrayList());
                    }
                    this.result.fixed64.addAll(other.fixed64);
                }
                if (!other.lengthDelimited.isEmpty()) {
                    if (this.result.lengthDelimited == null) {
                        Field.access$902(this.result, new ArrayList());
                    }
                    this.result.lengthDelimited.addAll(other.lengthDelimited);
                }
                if (!other.group.isEmpty()) {
                    void var1_1;
                    if (this.result.group == null) {
                        Field.access$1002(this.result, new ArrayList());
                    }
                    this.result.group.addAll(((Field)var1_1).group);
                }
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public final Builder addVarint(long value) {
                void var1_1;
                if (this.result.varint == null) {
                    Field.access$602(this.result, new ArrayList());
                }
                this.result.varint.add((long)var1_1);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public final Builder addFixed32(int value) {
                void var1_1;
                if (this.result.fixed32 == null) {
                    Field.access$702(this.result, new ArrayList());
                }
                this.result.fixed32.add((int)var1_1);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public final Builder addFixed64(long value) {
                void var1_1;
                if (this.result.fixed64 == null) {
                    Field.access$802(this.result, new ArrayList());
                }
                this.result.fixed64.add((long)var1_1);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public final Builder addLengthDelimited(ByteString value) {
                void var1_1;
                if (this.result.lengthDelimited == null) {
                    Field.access$902(this.result, new ArrayList());
                }
                this.result.lengthDelimited.add(var1_1);
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public final Builder addGroup(UnknownFieldSet value) {
                void var1_1;
                if (this.result.group == null) {
                    Field.access$1002(this.result, new ArrayList());
                }
                this.result.group.add(var1_1);
                return this;
            }
        }
    }

    public static final class Builder
    implements MessageLite.Builder {
        private TreeMap<Integer, Field.Builder> fieldBuilders = new TreeMap();

        private Builder() {
        }

        /*
         * WARNING - void declaration
         */
        private Field.Builder getFieldBuilder(int number) {
            void var2_2;
            if (number == 0) {
                return null;
            }
            Field.Builder builder = this.fieldBuilders.get(number);
            if (builder == null) {
                void var1_1;
                builder = Field.newBuilder();
                this.fieldBuilders.put((int)var1_1, builder);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final UnknownFieldSet build() {
            void var1_1;
            UnknownFieldSet result;
            if (this.fieldBuilders.isEmpty()) {
                result = UnknownFieldSet.getDefaultInstance();
            } else {
                TreeMap<Integer, Field> fields = new TreeMap<Integer, Field>();
                for (Map.Entry<Integer, Field.Builder> entry : this.fieldBuilders.entrySet()) {
                    void var3_3;
                    fields.put(entry.getKey(), ((Field.Builder)var3_3.getValue()).build());
                }
                result = new UnknownFieldSet(fields, 0);
            }
            return var1_1;
        }

        @Override
        public final UnknownFieldSet buildPartial() {
            return this.build();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder mergeFrom(UnknownFieldSet other) {
            if (other != UnknownFieldSet.getDefaultInstance()) {
                Iterator iterator;
                for (Map.Entry entry : ((UnknownFieldSet)((Object)iterator)).fields.entrySet()) {
                    void var2_2;
                    this.mergeField((Integer)entry.getKey(), (Field)var2_2.getValue());
                }
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder mergeField(int number, Field field) {
            if (number <= 0) {
                throw new IllegalArgumentException(number + " is not a valid field number.");
            }
            if (this.hasField(number)) {
                this.getFieldBuilder(number).mergeFrom(field);
            } else {
                void var2_2;
                void var1_1;
                this.addField((int)var1_1, (Field)var2_2);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder mergeVarintField(int number, int value) {
            void var2_2;
            void var1_1;
            if (number <= 0) {
                throw new IllegalArgumentException(number + " is not a valid field number.");
            }
            this.getFieldBuilder((int)var1_1).addVarint((long)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private boolean hasField(int number) {
            void var1_1;
            return this.fieldBuilders.containsKey((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private Builder addField(int number, Field field) {
            void var2_2;
            void var1_1;
            if (number <= 0) {
                throw new IllegalArgumentException(number + " is not a valid field number.");
            }
            this.fieldBuilders.put((int)var1_1, Field.newBuilder((Field)var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder mergeFrom(CodedInputStream input) throws IOException {
            void var2_2;
            int tag;
            while ((tag = input.readTag()) != 0 && this.mergeFieldFrom((int)var2_2, input)) {
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
            int number = WireFormat.getTagFieldNumber(tag);
            switch (WireFormat.getTagWireType(tag)) {
                case 0: {
                    this.getFieldBuilder(number).addVarint(input.readInt64());
                    return true;
                }
                case 1: {
                    this.getFieldBuilder(number).addFixed64(input.readFixed64());
                    return true;
                }
                case 2: {
                    this.getFieldBuilder(number).addLengthDelimited(input.readBytes());
                    return true;
                }
                case 3: {
                    void var1_2;
                    Builder subBuilder = UnknownFieldSet.newBuilder();
                    input.readGroup(number, subBuilder, ExtensionRegistry.getEmptyRegistry());
                    this.getFieldBuilder(number).addGroup(var1_2.build());
                    return true;
                }
                case 4: {
                    return false;
                }
                case 5: {
                    void var2_3;
                    void var3_4;
                    this.getFieldBuilder((int)var3_4).addFixed32(var2_3.readFixed32());
                    return true;
                }
            }
            throw InvalidProtocolBufferException.invalidWireType();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder mergeFrom(ByteString data) throws InvalidProtocolBufferException {
            Object input;
            try {
                input = data.newCodedInput();
                this.mergeFrom((CodedInputStream)input);
                ((CodedInputStream)input).checkLastTagWas(0);
                return this;
            }
            catch (InvalidProtocolBufferException invalidProtocolBufferException) {
                input = invalidProtocolBufferException;
                throw invalidProtocolBufferException;
            }
            catch (IOException e) {
                void var1_2;
                throw new RuntimeException("Reading from a ByteString threw an IOException (should never happen).", (Throwable)var1_2);
            }
        }

        @Override
        public final boolean isInitialized() {
            return true;
        }

        static /* synthetic */ Builder access$000() {
            return new Builder();
        }
    }
}

