/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j;

import java.io.Closeable;
import java.util.Deque;
import java.util.Map;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPMDCAdapter;
import org.slf4j.helpers.Reporter;
import org.slf4j.helpers.SubstituteServiceProvider;
import org.slf4j.spi.MDCAdapter;
import org.slf4j.spi.SLF4JServiceProvider;

public class MDC {
    static final String NULL_MDCA_URL = "http://www.slf4j.org/codes.html#null_MDCA";
    private static final String MDC_APAPTER_CANNOT_BE_NULL_MESSAGE = "MDCAdapter cannot be null. See also http://www.slf4j.org/codes.html#null_MDCA";
    static final String NO_STATIC_MDC_BINDER_URL = "http://www.slf4j.org/codes.html#no_static_mdc_binder";
    static MDCAdapter MDC_ADAPTER;

    private MDC() {
    }

    /*
     * WARNING - void declaration
     */
    private static MDCAdapter getMDCAdapterGivenByProvider() {
        SLF4JServiceProvider provider = LoggerFactory.getProvider();
        if (provider != null) {
            void var1_1;
            void var0;
            MDCAdapter anAdapter = provider.getMDCAdapter();
            MDC.emitTemporaryMDCAdapterWarningIfNeeded((SLF4JServiceProvider)var0);
            return var1_1;
        }
        Reporter.error("Failed to find provider.");
        Reporter.error("Defaulting to no-operation MDCAdapter implementation.");
        return new NOPMDCAdapter();
    }

    private static void emitTemporaryMDCAdapterWarningIfNeeded(SLF4JServiceProvider provider) {
        boolean bl = provider instanceof SubstituteServiceProvider;
        if (bl) {
            Reporter.info("Temporary mdcAdapter given by SubstituteServiceProvider.");
            Reporter.info("This mdcAdapter will be replaced after backend initialization has completed.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void put(String key, String val) throws IllegalArgumentException {
        void var1_1;
        String string;
        if (key == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().put(string, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static MDCCloseable putCloseable(String key, String val) throws IllegalArgumentException {
        String string;
        void var1_1;
        MDC.put(key, (String)var1_1);
        return new MDCCloseable(string);
    }

    public static String get(String key) throws IllegalArgumentException {
        String string;
        if (key == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().get(string);
    }

    public static void remove(String key) throws IllegalArgumentException {
        String string;
        if (key == null) {
            throw new IllegalArgumentException("key parameter cannot be null");
        }
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().remove(string);
    }

    public static void clear() {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().clear();
    }

    public static Map<String, String> getCopyOfContextMap() {
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().getCopyOfContextMap();
    }

    public static void setContextMap(Map<String, String> contextMap) {
        Map<String, String> map;
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().setContextMap(map);
    }

    public static MDCAdapter getMDCAdapter() {
        if (MDC_ADAPTER == null) {
            MDC_ADAPTER = MDC.getMDCAdapterGivenByProvider();
        }
        return MDC_ADAPTER;
    }

    static void setMDCAdapter(MDCAdapter anMDCAdapter) {
        MDCAdapter mDCAdapter;
        if (anMDCAdapter == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC_ADAPTER = mDCAdapter;
    }

    /*
     * WARNING - void declaration
     */
    public static void pushByKey(String key, String value) {
        void var1_1;
        String string;
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        MDC.getMDCAdapter().pushByKey(string, (String)var1_1);
    }

    public static String popByKey(String key) {
        String string;
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().popByKey(string);
    }

    /*
     * WARNING - void declaration
     */
    public Deque<String> getCopyOfDequeByKey(String key) {
        void var1_1;
        if (MDC.getMDCAdapter() == null) {
            throw new IllegalStateException(MDC_APAPTER_CANNOT_BE_NULL_MESSAGE);
        }
        return MDC.getMDCAdapter().getCopyOfDequeByKey((String)var1_1);
    }

    public static class MDCCloseable
    implements Closeable {
        private final String key;

        /*
         * WARNING - void declaration
         */
        private MDCCloseable(String key) {
            void var1_1;
            this.key = var1_1;
        }

        @Override
        public void close() {
            MDC.remove(this.key);
        }
    }
}

