/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.MessageFormatter;

public abstract class AbstractLogger
implements Serializable,
Logger {
    private static final long serialVersionUID = -2529255052481744503L;
    protected String name;

    @Override
    public String getName() {
        return this.name;
    }

    protected Object readResolve() throws ObjectStreamException {
        return LoggerFactory.getLogger(this.getName());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String msg) {
        if (this.isTraceEnabled()) {
            void var1_1;
            this.handle_0ArgsCall(Level.TRACE, null, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object arg2) {
        if (this.isTraceEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.TRACE, null, (String)var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.TRACE, null, (String)var1_1, var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String format, Object ... arguments) {
        if (this.isTraceEnabled()) {
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.TRACE, null, (String)var1_1, (Object[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(String msg, Throwable t) {
        if (this.isTraceEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.TRACE, null, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String msg) {
        if (this.isTraceEnabled(marker)) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.TRACE, (Marker)var1_1, (String)var2_2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String format, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.TRACE, (Marker)var1_1, (String)var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isTraceEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.TRACE, (Marker)var1_1, (String)var2_2, var3_3, arg2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isTraceEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.TRACE, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isTraceEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.TRACE, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg) {
        if (this.isDebugEnabled()) {
            void var1_1;
            this.handle_0ArgsCall(Level.DEBUG, null, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object arg2) {
        if (this.isDebugEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.DEBUG, null, (String)var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.DEBUG, null, (String)var1_1, var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String format, Object ... arguments) {
        if (this.isDebugEnabled()) {
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.DEBUG, null, (String)var1_1, (Object[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(String msg, Throwable t) {
        if (this.isDebugEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.DEBUG, null, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String msg) {
        if (this.isDebugEnabled(marker)) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.DEBUG, (Marker)var1_1, (String)var2_2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String format, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.DEBUG, (Marker)var1_1, (String)var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isDebugEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.DEBUG, (Marker)var1_1, (String)var2_2, var3_3, arg2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isDebugEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.DEBUG, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isDebugEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.DEBUG, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg) {
        if (this.isInfoEnabled()) {
            void var1_1;
            this.handle_0ArgsCall(Level.INFO, null, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object arg2) {
        if (this.isInfoEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.INFO, null, (String)var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.INFO, null, (String)var1_1, var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String format, Object ... arguments) {
        if (this.isInfoEnabled()) {
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.INFO, null, (String)var1_1, (Object[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(String msg, Throwable t) {
        if (this.isInfoEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.INFO, null, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String msg) {
        if (this.isInfoEnabled(marker)) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.INFO, (Marker)var1_1, (String)var2_2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String format, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.INFO, (Marker)var1_1, (String)var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isInfoEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.INFO, (Marker)var1_1, (String)var2_2, var3_3, arg2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String format, Object ... arguments) {
        if (this.isInfoEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.INFO, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void info(Marker marker, String msg, Throwable t) {
        if (this.isInfoEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.INFO, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg) {
        if (this.isWarnEnabled()) {
            void var1_1;
            this.handle_0ArgsCall(Level.WARN, null, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object arg2) {
        if (this.isWarnEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.WARN, null, (String)var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.WARN, null, (String)var1_1, var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String format, Object ... arguments) {
        if (this.isWarnEnabled()) {
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.WARN, null, (String)var1_1, (Object[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(String msg, Throwable t) {
        if (this.isWarnEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.WARN, null, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String msg) {
        if (this.isWarnEnabled(marker)) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.WARN, (Marker)var1_1, (String)var2_2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String format, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.WARN, (Marker)var1_1, (String)var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isWarnEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.WARN, (Marker)var1_1, (String)var2_2, var3_3, arg2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String format, Object ... arguments) {
        if (this.isWarnEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.WARN, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void warn(Marker marker, String msg, Throwable t) {
        if (this.isWarnEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.WARN, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg) {
        if (this.isErrorEnabled()) {
            void var1_1;
            this.handle_0ArgsCall(Level.ERROR, null, (String)var1_1, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object arg2) {
        if (this.isErrorEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.ERROR, null, (String)var1_1, var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.ERROR, null, (String)var1_1, var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String format, Object ... arguments) {
        if (this.isErrorEnabled()) {
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.ERROR, null, (String)var1_1, (Object[])var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(String msg, Throwable t) {
        if (this.isErrorEnabled()) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.ERROR, null, (String)var1_1, (Throwable)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String msg) {
        if (this.isErrorEnabled(marker)) {
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.ERROR, (Marker)var1_1, (String)var2_2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String format, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_1ArgsCall(Level.ERROR, (Marker)var1_1, (String)var2_2, var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isErrorEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle2ArgsCall(Level.ERROR, (Marker)var1_1, (String)var2_2, var3_3, arg2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String format, Object ... arguments) {
        if (this.isErrorEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handleArgArrayCall(Level.ERROR, (Marker)var1_1, (String)var2_2, (Object[])var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void error(Marker marker, String msg, Throwable t) {
        if (this.isErrorEnabled(marker)) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.handle_0ArgsCall(Level.ERROR, (Marker)var1_1, (String)var2_2, (Throwable)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void handle_0ArgsCall(Level level, Marker marker, String msg, Throwable t) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.handleNormalizedLoggingCall((Level)var1_1, (Marker)var2_2, (String)var3_3, null, t);
    }

    /*
     * WARNING - void declaration
     */
    private void handle_1ArgsCall(Level level, Marker marker, String msg, Object arg1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.handleNormalizedLoggingCall((Level)var1_1, (Marker)var2_2, (String)var3_3, new Object[]{arg1}, null);
    }

    /*
     * WARNING - void declaration
     */
    private void handle2ArgsCall(Level level, Marker marker, String msg, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (arg2 instanceof Throwable) {
            this.handleNormalizedLoggingCall(level, marker, msg, new Object[]{arg1}, (Throwable)arg2);
            return;
        }
        this.handleNormalizedLoggingCall((Level)var1_1, (Marker)var2_2, (String)var3_3, new Object[]{arg1, arg2}, null);
    }

    /*
     * WARNING - void declaration
     */
    private void handleArgArrayCall(Level level, Marker marker, String msg, Object[] args) {
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(args);
        if (throwableCandidate != null) {
            Object[] trimmedCopy = MessageFormatter.trimmedCopy(args);
            this.handleNormalizedLoggingCall(level, marker, msg, trimmedCopy, throwableCandidate);
            return;
        }
        this.handleNormalizedLoggingCall((Level)var1_1, (Marker)var2_2, (String)var3_3, (Object[])var4_4, null);
    }

    protected abstract String getFullyQualifiedCallerName();

    protected abstract void handleNormalizedLoggingCall(Level var1, Marker var2, String var3, Object[] var4, Throwable var5);
}

