/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.NormalizedParameters;
import org.slf4j.helpers.Reporter;

public final class MessageFormatter {
    static final char DELIM_START = '{';
    static final char DELIM_STOP = '}';
    static final String DELIM_STR = "{}";
    private static final char ESCAPE_CHAR = '\\';

    /*
     * WARNING - void declaration
     */
    public static final FormattingTuple format(String messagePattern, Object arg2) {
        void var1_1;
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public static final FormattingTuple format(String messagePattern, Object arg1, Object arg2) {
        void var2_2;
        void var1_1;
        return MessageFormatter.arrayFormat(messagePattern, new Object[]{var1_1, var2_2});
    }

    /*
     * WARNING - void declaration
     */
    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray) {
        void var2_2;
        void var3_3;
        String string;
        Throwable throwableCandidate = MessageFormatter.getThrowableCandidate(argArray);
        Object[] args = argArray;
        if (throwableCandidate != null) {
            void var1_1;
            args = MessageFormatter.trimmedCopy((Object[])var1_1);
        }
        return MessageFormatter.arrayFormat(string, (Object[])var3_3, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final String basicArrayFormat(String messagePattern, Object[] argArray) {
        void var1_1;
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat(messagePattern, (Object[])var1_1, null);
        return formattingTuple.getMessage();
    }

    public static String basicArrayFormat(NormalizedParameters np) {
        NormalizedParameters normalizedParameters;
        return MessageFormatter.basicArrayFormat(np.getMessage(), normalizedParameters.getArguments());
    }

    /*
     * WARNING - void declaration
     */
    public static final FormattingTuple arrayFormat(String messagePattern, Object[] argArray, Throwable throwable) {
        void var2_2;
        void var1_1;
        String string;
        void var3_3;
        if (messagePattern == null) {
            return new FormattingTuple(null, argArray, throwable);
        }
        if (argArray == null) {
            return new FormattingTuple(messagePattern);
        }
        int i = 0;
        StringBuilder sbuf = new StringBuilder(messagePattern.length() + 50);
        for (int L = 0; L < argArray.length; ++L) {
            int j = messagePattern.indexOf(DELIM_STR, i);
            if (j == -1) {
                if (i == 0) {
                    return new FormattingTuple(messagePattern, argArray, throwable);
                }
                sbuf.append(messagePattern, i, messagePattern.length());
                return new FormattingTuple(sbuf.toString(), argArray, throwable);
            }
            if (MessageFormatter.isEscapedDelimeter(messagePattern, j)) {
                if (!MessageFormatter.isDoubleEscaped(messagePattern, j)) {
                    --L;
                    sbuf.append(messagePattern, i, j - 1);
                    sbuf.append('{');
                    i = j + 1;
                    continue;
                }
                sbuf.append(messagePattern, i, j - 1);
                MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], new HashMap<Object[], Object>());
                i = j + 2;
                continue;
            }
            sbuf.append(messagePattern, i, j);
            MessageFormatter.deeplyAppendParameter(sbuf, argArray[L], new HashMap<Object[], Object>());
            i = j + 2;
        }
        sbuf.append(messagePattern, (int)var3_3, string.length());
        return new FormattingTuple(sbuf.toString(), (Object[])var1_1, (Throwable)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static final boolean isEscapedDelimeter(String messagePattern, int delimeterStartIndex) {
        void var1_2;
        String string;
        if (delimeterStartIndex == 0) {
            return false;
        }
        char c = string.charAt((int)(var1_2 - true));
        return c == '\\';
    }

    /*
     * WARNING - void declaration
     */
    static final boolean isDoubleEscaped(String messagePattern, int delimeterStartIndex) {
        void var1_1;
        String string;
        return delimeterStartIndex >= 2 && string.charAt((int)(var1_1 - 2)) == '\\';
    }

    /*
     * WARNING - void declaration
     */
    private static void deeplyAppendParameter(StringBuilder sbuf, Object o, Map<Object[], Object> seenMap) {
        void var2_2;
        void var1_1;
        StringBuilder stringBuilder;
        if (o == null) {
            sbuf.append("null");
            return;
        }
        if (!o.getClass().isArray()) {
            MessageFormatter.safeObjectAppend(sbuf, o);
            return;
        }
        if (o instanceof boolean[]) {
            MessageFormatter.booleanArrayAppend(sbuf, (boolean[])o);
            return;
        }
        if (o instanceof byte[]) {
            MessageFormatter.byteArrayAppend(sbuf, (byte[])o);
            return;
        }
        if (o instanceof char[]) {
            MessageFormatter.charArrayAppend(sbuf, (char[])o);
            return;
        }
        if (o instanceof short[]) {
            MessageFormatter.shortArrayAppend(sbuf, (short[])o);
            return;
        }
        if (o instanceof int[]) {
            MessageFormatter.intArrayAppend(sbuf, (int[])o);
            return;
        }
        if (o instanceof long[]) {
            MessageFormatter.longArrayAppend(sbuf, (long[])o);
            return;
        }
        if (o instanceof float[]) {
            MessageFormatter.floatArrayAppend(sbuf, (float[])o);
            return;
        }
        if (o instanceof double[]) {
            MessageFormatter.doubleArrayAppend(sbuf, (double[])o);
            return;
        }
        MessageFormatter.objectArrayAppend(stringBuilder, (Object[])var1_1, (Map<Object[], Object>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void safeObjectAppend(StringBuilder sbuf, Object o) {
        try {
            String oAsString = o.toString();
            sbuf.append(oAsString);
            return;
        }
        catch (Throwable t) {
            StringBuilder stringBuilder;
            void var2_3;
            void var1_1;
            Reporter.error("Failed toString() invocation on an object of type [" + var1_1.getClass().getName() + "]", (Throwable)var2_3);
            stringBuilder.append("[FAILED toString()]");
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void objectArrayAppend(StringBuilder sbuf, Object[] a, Map<Object[], Object> seenMap) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        if (!seenMap.containsKey(a)) {
            void var1_1;
            void var2_2;
            seenMap.put(a, null);
            int len = a.length;
            for (int i = 0; i < len; ++i) {
                MessageFormatter.deeplyAppendParameter(sbuf, a[i], seenMap);
                if (i == len - 1) continue;
                sbuf.append(", ");
            }
            var2_2.remove(var1_1);
        } else {
            sbuf.append("...");
        }
        stringBuilder.append(']');
    }

    private static void booleanArrayAppend(StringBuilder sbuf, boolean[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void byteArrayAppend(StringBuilder sbuf, byte[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void charArrayAppend(StringBuilder sbuf, char[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void shortArrayAppend(StringBuilder sbuf, short[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void intArrayAppend(StringBuilder sbuf, int[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void longArrayAppend(StringBuilder sbuf, long[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void floatArrayAppend(StringBuilder sbuf, float[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    private static void doubleArrayAppend(StringBuilder sbuf, double[] a) {
        StringBuilder stringBuilder;
        sbuf.append('[');
        int len = a.length;
        for (int i = 0; i < len; ++i) {
            sbuf.append(a[i]);
            if (i == len - 1) continue;
            sbuf.append(", ");
        }
        stringBuilder.append(']');
    }

    public static Throwable getThrowableCandidate(Object[] argArray) {
        return NormalizedParameters.getThrowableCandidate(argArray);
    }

    public static Object[] trimmedCopy(Object[] argArray) {
        return NormalizedParameters.trimmedCopy(argArray);
    }
}

