/*
 * Decompiled with CFR 0.152.
 */
package shaded.scala.collection.mutable;

import java.util.Arrays;
import java.util.NoSuchElementException;
import shaded.scala.Function1;
import shaded.scala.None$;
import shaded.scala.Option;
import shaded.scala.PartialFunction;
import shaded.scala.Some;
import shaded.scala.collection.AbstractIterable;
import shaded.scala.collection.AbstractIterator;
import shaded.scala.collection.IterableFactory;
import shaded.scala.collection.IterableOnce;
import shaded.scala.collection.Iterator;
import shaded.scala.collection.Iterator$;
import shaded.scala.collection.StrictOptimizedIterableOps;
import shaded.scala.collection.generic.DefaultSerializable;
import shaded.scala.collection.mutable.AbstractSet;
import shaded.scala.collection.mutable.LinkedHashSet$;
import shaded.scala.runtime.BoxesRunTime;
import shaded.scala.runtime.Statics;
import shaded.scala.util.hashing.MurmurHash3$;

public final class LinkedHashSet<A>
extends AbstractSet<A>
implements StrictOptimizedIterableOps<A, LinkedHashSet, LinkedHashSet<A>>,
DefaultSerializable {
    private Entry<A> firstEntry = null;
    private Entry<A> lastEntry = null;
    private Entry<A>[] scala$collection$mutable$LinkedHashSet$$table = new Entry[LinkedHashSet.tableSizeFor(16)];
    private int threshold = (int)((double)this.scala$collection$mutable$LinkedHashSet$$table.length * 0.75);
    private int contentSize = 0;

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object map(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.map$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatMap(Function1 f) {
        void var1_1;
        return StrictOptimizedIterableOps.flatMap$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object collect(PartialFunction pf) {
        void var1_1;
        return StrictOptimizedIterableOps.collect$(this, (PartialFunction)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object flatten(Function1 toIterableOnce) {
        void var1_1;
        return StrictOptimizedIterableOps.flatten$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object zip(IterableOnce that) {
        void var1_1;
        return StrictOptimizedIterableOps.zip$(this, (IterableOnce)var1_1);
    }

    @Override
    public final Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filter(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filter$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filterNot(Function1 pred) {
        void var1_1;
        return StrictOptimizedIterableOps.filterNot$(this, (Function1)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object filterImpl(Function1 pred, boolean isFlipped) {
        void var2_2;
        void var1_1;
        return StrictOptimizedIterableOps.filterImpl$(this, (Function1)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object dropRight(int n) {
        void var1_1;
        return StrictOptimizedIterableOps.dropRight$(this, (int)var1_1);
    }

    @Override
    public final IterableFactory<LinkedHashSet> iterableFactory() {
        return LinkedHashSet$.MODULE$;
    }

    public final Entry<A> firstEntry() {
        return this.firstEntry;
    }

    @Override
    public final A last() {
        LinkedHashSet linkedHashSet = this;
        if (linkedHashSet.contentSize > 0) {
            linkedHashSet = this;
            return linkedHashSet.lastEntry.key();
        }
        throw new NoSuchElementException("Cannot call .last on empty LinkedHashSet");
    }

    @Override
    public final Option<A> lastOption() {
        LinkedHashSet linkedHashSet = this;
        if (linkedHashSet.contentSize > 0) {
            linkedHashSet = this;
            return new Some<A>(linkedHashSet.lastEntry.key());
        }
        return None$.MODULE$;
    }

    @Override
    public final A head() {
        LinkedHashSet linkedHashSet = this;
        if (linkedHashSet.contentSize > 0) {
            linkedHashSet = this;
            return linkedHashSet.firstEntry.key();
        }
        throw new NoSuchElementException("Cannot call .head on empty LinkedHashSet");
    }

    @Override
    public final Option<A> headOption() {
        LinkedHashSet linkedHashSet = this;
        if (linkedHashSet.contentSize > 0) {
            linkedHashSet = this;
            return new Some<A>(linkedHashSet.firstEntry.key());
        }
        return None$.MODULE$;
    }

    @Override
    public final int size() {
        return this.contentSize;
    }

    @Override
    public final int knownSize() {
        LinkedHashSet linkedHashSet = this;
        return linkedHashSet.contentSize;
    }

    @Override
    public final boolean isEmpty() {
        LinkedHashSet linkedHashSet = this;
        return linkedHashSet.contentSize == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(A elem) {
        Entry<A> entry;
        int findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int findEntry_hash = findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ findEntry_scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash >>> 16;
        Entry<A> entry2 = this.scala$collection$mutable$LinkedHashSet$$table[findEntry_hash & this.scala$collection$mutable$LinkedHashSet$$table.length - 1];
        if (entry2 == null) {
            entry = null;
        } else {
            Entry<A> entry3;
            void var2_2;
            void var3_5 = var2_2;
            void var2_3 = entry3;
            entry3 = entry2;
            while (true) {
                if (var3_5 == entry3.hash() && BoxesRunTime.equals(var2_3, entry3.key())) {
                    entry = entry3;
                    break;
                }
                if (entry3.next() == null || entry3.hash() > var3_5) {
                    entry = null;
                    break;
                }
                entry3 = entry3.next();
            }
        }
        return entry != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void sizeHint(int size) {
        int target = LinkedHashSet.tableSizeFor((int)((double)(size + 1) / 0.75));
        if (target > this.scala$collection$mutable$LinkedHashSet$$table.length) {
            void var1_1;
            this.growTable((int)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(A elem) {
        LinkedHashSet linkedHashSet;
        void var2_2;
        if (this.contentSize + 1 >= this.threshold) {
            LinkedHashSet linkedHashSet2 = this;
            linkedHashSet2.growTable(linkedHashSet2.scala$collection$mutable$LinkedHashSet$$table.length << 1);
        }
        int scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(elem);
        int hash = scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash >>> 16;
        void v1 = var2_2;
        int n = v1 & this.scala$collection$mutable$LinkedHashSet$$table.length - 1;
        void var3_5 = v1;
        Entry<void> entry = linkedHashSet;
        linkedHashSet = this;
        Entry<void> entry2 = linkedHashSet.scala$collection$mutable$LinkedHashSet$$table[n];
        if (entry2 == null) {
            linkedHashSet.scala$collection$mutable$LinkedHashSet$$table[n] = linkedHashSet.createNewEntry(entry, (int)var3_5);
        } else {
            Entry<void> entry3 = null;
            for (Entry<void> entry4 = entry2; entry4 != null && entry4.hash() <= var3_5; entry4 = entry4.next()) {
                if (entry4.hash() == var3_5 && BoxesRunTime.equals(entry, entry4.key())) {
                    return false;
                }
                entry3 = entry4;
            }
            entry = linkedHashSet.createNewEntry(entry, (int)var3_5);
            if (entry3 == null) {
                entry.next_$eq(entry2);
                linkedHashSet.scala$collection$mutable$LinkedHashSet$$table[n] = entry;
            } else {
                entry.next_$eq(entry3.next());
                entry3.next_$eq(entry);
            }
        }
        ++linkedHashSet.contentSize;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean remove(A elem) {
        void var1_2;
        A a = elem;
        int scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash = Statics.anyHash(a);
        return this.remove0(a, scala$collection$mutable$LinkedHashSet$$computeHash_scala$collection$mutable$LinkedHashSet$$improveHash_originalHash ^ var1_2 >>> 16);
    }

    @Override
    public final Iterator<A> iterator() {
        return new LinkedHashSetIterator<A>(this){

            public final A extract(Entry<A> nd) {
                return nd.key();
            }
            {
                void var1_1;
            }
        };
    }

    public final Iterator<Entry<A>> entryIterator$78a1b86e() {
        return new LinkedHashSetIterator<Entry<A>>(this){
            {
                void var1_1;
            }
        };
    }

    @Override
    public final <U> void foreach(Function1<A, U> f) {
        LinkedHashSet linkedHashSet = this;
        for (Entry<A> cur = linkedHashSet.firstEntry; cur != null; cur = cur.later()) {
            f.apply(cur.key());
        }
    }

    private static int tableSizeFor(int capacity) {
        int n;
        --n;
        n = Integer.highestOneBit(Math.max(n, 4)) << 1;
        return Math.min(n, 0x40000000);
    }

    public static int unimproveHash(int improvedHash) {
        int n = improvedHash;
        return n ^ n >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    private Entry<A> createNewEntry(A key, int hash) {
        void var1_1;
        Entry<A> entry;
        void var2_2;
        Entry<A> e = new Entry<A>(key, (int)var2_2);
        LinkedHashSet linkedHashSet = this;
        if (linkedHashSet.firstEntry == null) {
            entry = e;
            linkedHashSet = this;
            this.firstEntry = entry;
        } else {
            linkedHashSet = this;
            linkedHashSet.lastEntry.later_$eq(e);
            linkedHashSet = this;
            e.earlier_$eq(linkedHashSet.lastEntry);
        }
        entry = e;
        linkedHashSet = this;
        this.lastEntry = entry;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void deleteEntry(Entry<A> e) {
        void var1_1;
        LinkedHashSet linkedHashSet;
        Entry<A> entry;
        if (e.earlier() == null) {
            entry = e.later();
            linkedHashSet = this;
            this.firstEntry = entry;
        } else {
            e.earlier().later_$eq(e.later());
        }
        if (e.later() == null) {
            entry = e.earlier();
            linkedHashSet = this;
            this.lastEntry = entry;
        } else {
            e.later().earlier_$eq(e.earlier());
        }
        e.earlier_$eq(null);
        e.later_$eq(null);
        var1_1.next_$eq(null);
    }

    private boolean remove0(A elem, int hash) {
        int idx = hash & this.scala$collection$mutable$LinkedHashSet$$table.length - 1;
        Entry<A> entry = this.scala$collection$mutable$LinkedHashSet$$table[idx];
        if (entry == null) {
            return false;
        }
        if (entry.hash() == hash && BoxesRunTime.equals(entry.key(), elem)) {
            this.scala$collection$mutable$LinkedHashSet$$table[idx] = entry.next();
            this.deleteEntry(entry);
            --this.contentSize;
            return true;
        }
        Entry<A> prev = entry;
        for (Entry<A> next = entry.next(); next != null && next.hash() <= hash; next = next.next()) {
            if (next.hash() == hash && BoxesRunTime.equals(next.key(), elem)) {
                prev.next_$eq(next.next());
                this.deleteEntry(next);
                --this.contentSize;
                return true;
            }
            prev = next;
        }
        return false;
    }

    private void growTable(int newlen) {
        if (newlen < 0) {
            throw new RuntimeException(new StringBuilder(36).append("new hash table size ").append(newlen).append(" exceeds maximum").toString());
        }
        this.threshold = (int)((double)newlen * 0.75);
        LinkedHashSet linkedHashSet = this;
        if (linkedHashSet.contentSize == 0) {
            this.scala$collection$mutable$LinkedHashSet$$table = new Entry[newlen];
            return;
        }
        this.scala$collection$mutable$LinkedHashSet$$table = Arrays.copyOf(this.scala$collection$mutable$LinkedHashSet$$table, newlen);
        Entry<Object> preLow = new Entry<Object>(null, 0);
        Entry<Object> preHigh = new Entry<Object>(null, 0);
        for (int oldlen = this.scala$collection$mutable$LinkedHashSet$$table.length; oldlen < newlen; oldlen <<= 1) {
            for (int i = 0; i < oldlen; ++i) {
                Entry<A> old = this.scala$collection$mutable$LinkedHashSet$$table[i];
                if (old == null) continue;
                preLow.next_$eq(null);
                preHigh.next_$eq(null);
                Entry<Object> lastLow = preLow;
                Entry<Object> lastHigh = preHigh;
                Entry<A> n = old;
                while (n != null) {
                    Entry<A> next = n.next();
                    if ((n.hash() & oldlen) == 0) {
                        lastLow.next_$eq(n);
                        lastLow = n;
                    } else {
                        lastHigh.next_$eq(n);
                        lastHigh = n;
                    }
                    n = next;
                }
                lastLow.next_$eq(null);
                if (old != preLow.next()) {
                    this.scala$collection$mutable$LinkedHashSet$$table[i] = preLow.next();
                }
                if (preHigh.next() == null) continue;
                this.scala$collection$mutable$LinkedHashSet$$table[i + oldlen] = preHigh.next();
                lastHigh.next_$eq(null);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        LinkedHashSetIterator<Object> setHashIterator = ((AbstractIterable)this).isEmpty() ? this.iterator() : new LinkedHashSetIterator<Object>(this){
            private int hash;
            private final /* synthetic */ LinkedHashSet $outer;

            public final int hashCode() {
                $anon$3 var1_1 = this;
                return var1_1.hash;
            }

            public final Object extract(Entry<A> nd) {
                $anon$3 var1_1;
                $anon$3 v0 = this;
                LinkedHashSet cfr_ignored_0 = v0.$outer;
                int n = LinkedHashSet.unimproveHash(((Entry)((Object)var1_1)).hash());
                var1_1 = v0;
                v0.hash = n;
                return this;
            }
            {
                void var1_1;
                this.$outer = $outer;
                super((LinkedHashSet)var1_1);
                this.hash = 0;
            }
        };
        return MurmurHash3$.MODULE$.unorderedHash((IterableOnce<Object>)var1_1, MurmurHash3$.MODULE$.setSeed());
    }

    @Override
    public final String stringPrefix() {
        return "LinkedHashSet";
    }

    public static final class Entry<A> {
        private final A key;
        private final int hash;
        private Entry<A> earlier;
        private Entry<A> later;
        private Entry<A> next;

        public final A key() {
            return this.key;
        }

        public final int hash() {
            return this.hash;
        }

        public final Entry<A> earlier() {
            return this.earlier;
        }

        /*
         * WARNING - void declaration
         */
        public final void earlier_$eq(Entry<A> x$1) {
            void var1_1;
            this.earlier = var1_1;
        }

        public final Entry<A> later() {
            return this.later;
        }

        /*
         * WARNING - void declaration
         */
        public final void later_$eq(Entry<A> x$1) {
            void var1_1;
            this.later = var1_1;
        }

        public final Entry<A> next() {
            return this.next;
        }

        /*
         * WARNING - void declaration
         */
        public final void next_$eq(Entry<A> x$1) {
            void var1_1;
            this.next = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Entry(A key, int hash) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
            this.earlier = null;
            this.later = null;
            this.next = null;
        }
    }

    private abstract class LinkedHashSetIterator<T>
    extends AbstractIterator<T> {
        private Entry<A> cur;
        private /* synthetic */ LinkedHashSet $outer;

        public abstract T extract(Entry<A> var1);

        @Override
        public final boolean hasNext() {
            return this.cur != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T next() {
            if (this.hasNext()) {
                void var1_1;
                LinkedHashSetIterator linkedHashSetIterator = this;
                T r = linkedHashSetIterator.extract(linkedHashSetIterator.cur);
                this.cur = this.cur.later();
                return var1_1;
            }
            return (T)Iterator$.scala$collection$Iterator$$_empty$1b393d2f.next();
        }

        /*
         * WARNING - void declaration
         */
        public LinkedHashSetIterator(LinkedHashSet $outer) {
            void var1_1;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.cur = var1_1.firstEntry();
        }
    }
}

