/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.stmt;

import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.nodeTypes.NodeWithStatements;
import com.github.javaparser.ast.observer.ObservableProperty;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.visitor.CloneVisitor;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.utils.Utils;
import java.util.Optional;

public class SwitchEntry
extends Node
implements NodeWithStatements<SwitchEntry> {
    private NodeList<Expression> labels;
    private NodeList<Statement> statements;
    private Type type;
    private boolean isDefault;
    private Expression guard;

    public SwitchEntry() {
        this(null, new NodeList<Expression>(), Type.STATEMENT_GROUP, new NodeList<Statement>(), false, null);
    }

    /*
     * WARNING - void declaration
     */
    public SwitchEntry(NodeList<Expression> labels, Type type, NodeList<Statement> statements) {
        this(null, (NodeList<Expression>)var1_1, (Type)var2_2, (NodeList<Statement>)var3_3, false, null);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public SwitchEntry(TokenRange tokenRange, NodeList<Expression> labels, Type type, NodeList<Statement> statements, boolean isDefault, Expression guard) {
        super((TokenRange)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setLabels((NodeList<Expression>)var2_2);
        this.setType((Type)var3_3);
        this.setStatements(statements);
        this.setDefault(isDefault);
        this.setGuard(guard);
        this.customInitialization();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <R, A> R accept(GenericVisitor<R, A> v, A arg2) {
        void var2_2;
        return v.visit(this, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <A> void accept(VoidVisitor<A> v, A arg2) {
        void var2_2;
        v.visit(this, var2_2);
    }

    public final NodeList<Expression> getLabels() {
        return this.labels;
    }

    @Override
    public final NodeList<Statement> getStatements() {
        return this.statements;
    }

    /*
     * WARNING - void declaration
     */
    private SwitchEntry setLabels(NodeList<Expression> labels) {
        void var1_1;
        Utils.assertNotNull(labels);
        if (labels == this.labels) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.LABELS, this.labels, labels);
        if (this.labels != null) {
            this.labels.setParentNode(null);
        }
        this.labels = labels;
        this.setAsParentNodeOf((NodeList<? extends Node>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private SwitchEntry setStatements(NodeList<Statement> statements) {
        void var1_1;
        Utils.assertNotNull(statements);
        if (statements == this.statements) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.STATEMENTS, this.statements, statements);
        if (this.statements != null) {
            this.statements.setParentNode(null);
        }
        this.statements = statements;
        this.setAsParentNodeOf((NodeList<? extends Node>)var1_1);
        return this;
    }

    @Override
    private SwitchEntry clone() {
        return (SwitchEntry)this.accept(new CloneVisitor(), null);
    }

    public final Type getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    private SwitchEntry setType(Type type) {
        void var1_1;
        Utils.assertNotNull(type);
        if (type == this.type) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.TYPE, this.type, type);
        this.type = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean replace(Node node, Node replacementNode) {
        void var2_2;
        void var1_1;
        int i;
        if (node == null) {
            return false;
        }
        if (this.guard != null && node == this.guard) {
            this.setGuard((Expression)replacementNode);
            return true;
        }
        for (i = 0; i < this.labels.size(); ++i) {
            if (this.labels.get(i) != node) continue;
            this.labels.set(i, (Expression)replacementNode);
            return true;
        }
        for (i = 0; i < this.statements.size(); ++i) {
            if (this.statements.get(i) != node) continue;
            this.statements.set(i, (Statement)replacementNode);
            return true;
        }
        return super.replace((Node)var1_1, (Node)var2_2);
    }

    public final boolean isDefault() {
        return this.isDefault;
    }

    /*
     * WARNING - void declaration
     */
    private SwitchEntry setDefault(boolean isDefault) {
        void var1_1;
        if (isDefault == this.isDefault) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.DEFAULT, this.isDefault, isDefault);
        this.isDefault = var1_1;
        return this;
    }

    public final Optional<Expression> getGuard() {
        return Optional.ofNullable(this.guard);
    }

    /*
     * WARNING - void declaration
     */
    private SwitchEntry setGuard(Expression guard) {
        void var1_1;
        if (guard == this.guard) {
            return this;
        }
        this.notifyPropertyChange(ObservableProperty.GUARD, this.guard, guard);
        if (this.guard != null) {
            this.guard.setParentNode(null);
        }
        this.guard = guard;
        this.setAsParentNodeOf((Node)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public SwitchEntry(TokenRange tokenRange, NodeList<Expression> labels, Type type, NodeList<Statement> statements, boolean isDefault) {
        super((TokenRange)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setLabels((NodeList<Expression>)var2_2);
        this.setType((Type)var3_3);
        this.setStatements(statements);
        this.setDefault(isDefault);
        this.customInitialization();
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type STATEMENT_GROUP = new Type();
        public static final /* enum */ Type EXPRESSION = new Type();
        public static final /* enum */ Type BLOCK = new Type();
        public static final /* enum */ Type THROWS_STATEMENT = new Type();

        static {
            Type[] typeArray = new Type[]{STATEMENT_GROUP, EXPRESSION, BLOCK, THROWS_STATEMENT};
        }
    }
}

