/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.Serializable;

public final class Suppliers {
    public static <T> Supplier<T> memoize(Supplier<T> delegate) {
        Supplier<T> supplier;
        if (delegate instanceof NonSerializableMemoizingSupplier || delegate instanceof MemoizingSupplier) {
            return delegate;
        }
        if (delegate instanceof Serializable) {
            return new MemoizingSupplier<T>(delegate);
        }
        return new NonSerializableMemoizingSupplier<T>(supplier);
    }

    static final class NonSerializableMemoizingSupplier<T>
    implements Supplier<T> {
        private final Object lock = new Object();
        private static final Supplier<Void> SUCCESSFULLY_COMPUTED = () -> {
            throw new IllegalStateException();
        };
        private volatile Supplier<T> delegate;
        private T value;

        /*
         * WARNING - void declaration
         */
        NonSerializableMemoizingSupplier(Supplier<T> delegate) {
            void var1_1;
            this.delegate = (Supplier)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get() {
            Object object;
            if (this.delegate != SUCCESSFULLY_COMPUTED) {
                object = this.lock;
                synchronized (object) {
                    if (this.delegate != SUCCESSFULLY_COMPUTED) {
                        void var2_2;
                        T t = this.delegate.get();
                        this.value = t;
                        this.delegate = SUCCESSFULLY_COMPUTED;
                        return var2_2;
                    }
                }
            }
            object = this.value;
            return (T)object;
        }

        /*
         * WARNING - void declaration
         */
        public final String toString() {
            void var1_1;
            Supplier<T> delegate = this.delegate;
            return "Suppliers.memoize(" + (delegate == SUCCESSFULLY_COMPUTED ? "<supplier that returned " + this.value + ">" : var1_1) + ")";
        }
    }

    static final class MemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private transient Object lock = new Object();
        private Supplier<T> delegate;
        private volatile transient boolean initialized;
        private transient T value;

        /*
         * WARNING - void declaration
         */
        MemoizingSupplier(Supplier<T> delegate) {
            void var1_1;
            this.delegate = (Supplier)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get() {
            Object object;
            if (!this.initialized) {
                object = this.lock;
                synchronized (object) {
                    if (!this.initialized) {
                        void var2_2;
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return var2_2;
                    }
                }
            }
            object = this.value;
            return (T)object;
        }

        public final String toString() {
            return "Suppliers.memoize(" + (this.initialized ? "<supplier that returned " + this.value + ">" : this.delegate) + ")";
        }
    }
}

