/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableRangeSet;
import com.google.common.collect.ImmutableSet;
import java.util.EnumSet;
import java.util.stream.Collector;

final class CollectCollectors {
    private static final Collector<Object, ?, ImmutableList<Object>> TO_IMMUTABLE_LIST = Collector.of(ImmutableList::builder, ImmutableList.Builder::add, ImmutableList.Builder::combine, ImmutableList.Builder::build, new Collector.Characteristics[0]);

    static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return TO_IMMUTABLE_LIST;
    }

    static <E extends Enum<E>> Collector<E, ?, ImmutableSet<E>> toImmutableEnumSet() {
        return EnumSetAccumulator.TO_IMMUTABLE_ENUM_SET;
    }

    static /* synthetic */ Collector access$000() {
        return Collector.of(() -> new EnumSetAccumulator(0), EnumSetAccumulator::add, EnumSetAccumulator::combine, EnumSetAccumulator::toImmutableSet, Collector.Characteristics.UNORDERED);
    }

    static {
        Collector.of(ImmutableSet::builder, ImmutableSet.Builder::add, ImmutableSet.Builder::combine, ImmutableSet.Builder::build, new Collector.Characteristics[0]);
        Collector.of(ImmutableRangeSet::builder, ImmutableRangeSet.Builder::add, ImmutableRangeSet.Builder::combine, ImmutableRangeSet.Builder::build, new Collector.Characteristics[0]);
    }

    private static final class EnumSetAccumulator<E extends Enum<E>> {
        static final Collector<Enum<?>, ?, ImmutableSet<? extends Enum<?>>> TO_IMMUTABLE_ENUM_SET = CollectCollectors.access$000();
        private EnumSet<E> set;

        private EnumSetAccumulator() {
        }

        /*
         * WARNING - void declaration
         */
        final void add(E e) {
            void var1_1;
            if (this.set == null) {
                this.set = EnumSet.of(e);
                return;
            }
            this.set.add(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        final EnumSetAccumulator<E> combine(EnumSetAccumulator<E> other) {
            void var1_1;
            if (this.set == null) {
                return other;
            }
            if (other.set == null) {
                return this;
            }
            this.set.addAll(var1_1.set);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final ImmutableSet<E> toImmutableSet() {
            void var1_1;
            if (this.set == null) {
                return ImmutableSet.of$19e5980f();
            }
            ImmutableSet<E> ret = ImmutableEnumSet.asImmutable(this.set);
            this.set = null;
            return var1_1;
        }

        /* synthetic */ EnumSetAccumulator(byte by) {
            this();
        }
    }
}

