/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ByFunctionOrdering;
import com.google.common.collect.Cut;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedLists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class ImmutableRangeMap<K extends Comparable<?>, V>
implements RangeMap<K, V>,
Serializable {
    private static final ImmutableRangeMap<Comparable<?>, Object> EMPTY = new ImmutableRangeMap(ImmutableList.of(), ImmutableList.of());
    private final transient ImmutableList<Range<K>> ranges;
    private final transient ImmutableList<V> values;

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> of() {
        return EMPTY;
    }

    public static <K extends Comparable<?>, V> Builder<K, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    ImmutableRangeMap(ImmutableList<Range<K>> ranges, ImmutableList<V> values) {
        void var2_2;
        void var1_1;
        this.ranges = var1_1;
        this.values = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final V get(K key) {
        void var1_1;
        int index = SortedLists.binarySearch$1c53ff7f(this.ranges, Range::lowerBound, Cut.belowValue$6a7d55c6(key), SortedLists.KeyPresentBehavior.ANY_PRESENT$8552d4, SortedLists.KeyAbsentBehavior.NEXT_LOWER$6589c8f6);
        if (index == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(index);
        if (range.contains(var1_1)) {
            void var2_2;
            return (V)this.values.get((int)var2_2);
        }
        return null;
    }

    @Override
    @Deprecated
    public final void put(Range<K> range, V value) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableMap<Range<K>, V> asMapOfRanges() {
        void var1_1;
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet rangeSet = new RegularImmutableSortedSet(this.ranges, Range.rangeLexOrdering());
        return new ImmutableSortedMap(var1_1, this.values);
    }

    /*
     * WARNING - void declaration
     */
    public ImmutableRangeMap<K, V> subRangeMap(Range<K> range) {
        void var1_1;
        void var3_5;
        void var2_3;
        int upperIndex;
        block7: {
            block6: {
                if (Preconditions.checkNotNull(range).isEmpty()) {
                    return EMPTY;
                }
                if (this.ranges.isEmpty()) break block6;
                Serializable serializable = this;
                if (serializable.ranges.isEmpty()) {
                    throw new NoSuchElementException();
                }
                Range range2 = (Range)serializable.ranges.get(0);
                serializable = (Range)serializable.ranges.get(serializable.ranges.size() - 1);
                if (!range.encloses(Range.create(range2.lowerBound, ((Range)serializable).upperBound))) break block7;
            }
            return this;
        }
        int lowerIndex = SortedLists.binarySearch$1c53ff7f(this.ranges, Range::upperBound, range.lowerBound, SortedLists.KeyPresentBehavior.FIRST_AFTER$8552d4, SortedLists.KeyAbsentBehavior.NEXT_HIGHER$6589c8f6);
        if (lowerIndex >= (upperIndex = SortedLists.binarySearch$1c53ff7f(this.ranges, Range::lowerBound, range.upperBound, SortedLists.KeyPresentBehavior.ANY_PRESENT$8552d4, SortedLists.KeyAbsentBehavior.NEXT_HIGHER$6589c8f6))) {
            return EMPTY;
        }
        int off = lowerIndex;
        int len = upperIndex - lowerIndex;
        ImmutableList subRanges = new ImmutableList<Range<K>>(this, len, off, range){
            private /* synthetic */ int val$len;
            private /* synthetic */ int val$off;
            private /* synthetic */ Range val$range;
            private /* synthetic */ ImmutableRangeMap this$0;
            {
                void var1_1;
                this.val$len = n;
                this.val$off = n2;
                this.val$range = range;
                this.this$0 = var1_1;
            }

            @Override
            public final int size() {
                return this.val$len;
            }

            @Override
            final boolean isPartialView() {
                return true;
            }
        };
        ImmutableRangeMap outer = this;
        return new ImmutableRangeMap<K, V>(this, subRanges, (ImmutableList)this.values.subList((int)var2_3, (int)var3_5), (Range)var1_1, outer){
            private /* synthetic */ Range val$range;
            private /* synthetic */ ImmutableRangeMap val$outer;
            private /* synthetic */ ImmutableRangeMap this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.val$range = range;
                this.val$outer = immutableRangeMap;
                this.this$0 = var1_1;
                super(var2_2, var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final ImmutableRangeMap<K, V> subRangeMap(Range<K> subRange) {
                if (this.val$range.isConnected(subRange)) {
                    void var1_1;
                    return this.val$outer.subRangeMap(var1_1.intersection(this.val$range));
                }
                return ImmutableRangeMap.of();
            }
        };
    }

    public int hashCode() {
        return ((ImmutableMap)this.asMapOfRanges()).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object o) {
        if (o instanceof RangeMap) {
            void var1_1;
            RangeMap rangeMap = (RangeMap)o;
            return ((ImmutableMap)this.asMapOfRanges()).equals(var1_1.asMapOfRanges());
        }
        return false;
    }

    public String toString() {
        return ((ImmutableMap)this.asMapOfRanges()).toString();
    }

    public static final class Builder<K extends Comparable<?>, V> {
        private final List<Map.Entry<Range<K>, V>> entries = new ArrayList<Map.Entry<Range<K>, V>>();

        /*
         * WARNING - void declaration
         */
        public final Builder<K, V> put$25167b06(Range<K> range, V value) {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(range);
            Preconditions.checkNotNull(value);
            Preconditions.checkArgument(!range.isEmpty(), "Range must not be empty, but was %s", range);
            this.entries.add(Maps.immutableEntry$5733d0c((Object)var1_1, (Object)var2_2));
            return this;
        }

        public final ImmutableRangeMap<K, V> build() {
            Ordering ordering = Range.rangeLexOrdering();
            Maps.EntryFunction.1 var2_2 = Maps.EntryFunction.KEY$60601a0f;
            Collections.sort(this.entries, new ByFunctionOrdering(var2_2, ordering));
            ImmutableList.Builder rangesBuilder = new ImmutableList.Builder(this.entries.size());
            ImmutableList.Builder valuesBuilder = new ImmutableList.Builder(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                Range<K> prevRange;
                Range<K> range = this.entries.get(i).getKey();
                if (i > 0 && range.isConnected(prevRange = this.entries.get(i - 1).getKey()) && !range.intersection(prevRange).isEmpty()) {
                    throw new IllegalArgumentException("Overlapping ranges: range " + prevRange + " overlaps with entry " + range);
                }
                rangesBuilder.add(range);
                valuesBuilder.add(this.entries.get(i).getValue());
            }
            return new ImmutableRangeMap(((ImmutableList.Builder)((Object)ordering)).build(), ((ImmutableList.Builder)((Object)var2_2)).build());
        }
    }
}

