/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.MoreObjects;
import com.google.common.collect.EmptyImmutableSetMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class ImmutableSetMultimap<K, V>
extends ImmutableMultimap<K, V>
implements SetMultimap<K, V> {
    private final transient ImmutableSet<V> emptySet;

    public static <K, V> ImmutableSetMultimap<K, V> of$4568c534() {
        return EmptyImmutableSetMultimap.INSTANCE;
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableSetMultimap<K, V> fromMapBuilderEntries(Collection<? extends Map.Entry<K, ImmutableCollection.Builder<V>>> mapEntries, Comparator<? super V> valueComparator) {
        void var1_1;
        void var3_3;
        void var2_2;
        Iterator<? extends Map.Entry<K, ImmutableCollection.Builder<V>>> iterator;
        if (mapEntries.isEmpty()) {
            return EmptyImmutableSetMultimap.INSTANCE;
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder(mapEntries.size());
        int size = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = entry.getKey();
            Comparator<? super V> values = (ImmutableSet.Builder)entry.getValue();
            ImmutableSet immutableSet = ((ImmutableSet.Builder)((Object)values)).build();
            values = valueComparator;
            ImmutableSet set = values == null ? ImmutableSet.copyOf(immutableSet) : ImmutableSortedSet.copyOf(values, immutableSet);
            if (set.isEmpty()) continue;
            builder.put(key, set);
            size += set.size();
        }
        return new ImmutableSetMultimap(var2_2.buildOrThrow(), (int)var3_3, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSetMultimap(ImmutableMap<K, ImmutableSet<V>> map, int size, Comparator<? super V> valueComparator) {
        super(var1_1, (int)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        var1_1 = var3_3;
        this.emptySet = var1_1 == null ? ImmutableSet.of$19e5980f() : ImmutableSortedSet.emptySet(var1_1);
    }

    @Override
    private ImmutableSet<V> get(K key) {
        ImmutableSet immutableSet;
        immutableSet = (ImmutableSet)this.map.get(immutableSet);
        return MoreObjects.firstNonNull(immutableSet, this.emptySet);
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableCollection.Builder<V> newValueCollectionBuilderWithExpectedSize(int expectedSize) {
            void var1_1;
            return ImmutableSet.builderWithExpectedSize((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> put(K key, V value) {
            void var2_2;
            void var1_1;
            super.put(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final ImmutableSetMultimap<K, V> build() {
            void var1_1;
            if (this.builderMap == null) {
                return ImmutableSetMultimap.of$4568c534();
            }
            Set mapEntries = this.builderMap.entrySet();
            return ImmutableSetMultimap.fromMapBuilderEntries(var1_1, this.valueComparator);
        }
    }
}

