/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.IntFunction;

public final class ImmutableSortedMap<K, V>
extends ImmutableMap<K, V>
implements NavigableMap<K, V> {
    private static final ImmutableSortedMap<Comparable<?>, Object> NATURAL_EMPTY_MAP;
    private final transient RegularImmutableSortedSet<K> keySet;
    private final transient ImmutableList<V> valueList;
    private transient ImmutableSortedMap<K, V> descendingMap;

    private static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        Comparator<? super K> comparator2;
        if (Ordering.natural$75ffd5c5().equals(comparator)) {
            return NATURAL_EMPTY_MAP;
        }
        return new ImmutableSortedMap(ImmutableSortedSet.emptySet(comparator2), ImmutableList.of());
    }

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSortedMap(RegularImmutableSortedSet<K> keySet, ImmutableList<V> valueList) {
        this((RegularImmutableSortedSet<K>)var1_1, (ImmutableList<V>)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableSortedMap(RegularImmutableSortedSet<K> keySet, ImmutableList<V> valueList, ImmutableSortedMap<K, V> descendingMap) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.keySet = var1_1;
        this.valueList = var2_2;
        this.descendingMap = var3_3;
    }

    @Override
    public final int size() {
        return this.valueList.size();
    }

    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        ImmutableList keyList = ((ImmutableCollection)this.keySet).asList();
        for (int i = 0; i < this.size(); ++i) {
            action.accept(keyList.get(i), this.valueList.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_2;
        int index = this.keySet.indexOf(key);
        if (index == -1) {
            return null;
        }
        return (V)this.valueList.get((int)var1_2);
    }

    @Override
    final boolean isPartialView() {
        return this.keySet.isPartialView() || this.valueList.isPartialView();
    }

    @Override
    public final ImmutableSet<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        if (this.isEmpty()) {
            return ImmutableSet.of$19e5980f();
        }
        final class EntrySet
        extends ImmutableMapEntrySet<K, V> {
            final /* synthetic */ ImmutableSortedMap this$0;

            /*
             * WARNING - void declaration
             */
            EntrySet(ImmutableSortedMap this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public final UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                return ((ImmutableCollection)((ImmutableCollection)this).asList()).iterator();
            }

            @Override
            public final Spliterator<Map.Entry<K, V>> spliterator() {
                return ((ImmutableCollection)((ImmutableCollection)this).asList()).spliterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
                void var1_1;
                ((ImmutableCollection)this).asList().forEach(var1_1);
            }

            @Override
            final ImmutableList<Map.Entry<K, V>> createAsList() {
                return new ImmutableAsList<Map.Entry<K, V>>(this){
                    private /* synthetic */ EntrySet this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public final Map.Entry<K, V> get(int index) {
                        void var1_1;
                        return new AbstractMap.SimpleImmutableEntry(((ImmutableCollection)this.this$1.this$0.keySet).asList().get(index), this.this$1.this$0.valueList.get((int)var1_1));
                    }

                    @Override
                    public final Spliterator<Map.Entry<K, V>> spliterator() {
                        IntFunction<Map.Entry> intFunction = n -> this.get(n);
                        int n2 = 1297;
                        int n3 = this.size();
                        return CollectSpliterators.indexed$368eec41((int)n3, (int)n2, intFunction, null);
                    }

                    @Override
                    final ImmutableCollection<Map.Entry<K, V>> delegateCollection() {
                        return this.this$1;
                    }
                };
            }

            @Override
            final ImmutableMap<K, V> map() {
                return this.this$0;
            }
        }
        return new EntrySet(this);
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public final ImmutableCollection<V> values() {
        return this.valueList;
    }

    @Override
    final ImmutableCollection<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public final Comparator<? super K> comparator() {
        ImmutableSortedMap immutableSortedMap = this;
        return immutableSortedMap.keySet.comparator();
    }

    @Override
    public final K firstKey() {
        ImmutableSortedMap immutableSortedMap = this;
        return (K)((ImmutableSortedSet)immutableSortedMap.keySet).first();
    }

    @Override
    public final K lastKey() {
        ImmutableSortedMap immutableSortedMap = this;
        return (K)((ImmutableSortedSet)immutableSortedMap.keySet).last();
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableSortedMap<K, V> getSubMap(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        if (fromIndex == 0 && toIndex == this.size()) {
            return this;
        }
        if (fromIndex == toIndex) {
            return ImmutableSortedMap.emptyMap(this.comparator());
        }
        return new ImmutableSortedMap<K, V>(this.keySet.getSubSet(fromIndex, toIndex), this.valueList.subList((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ImmutableSortedMap<K, V> headMap(K toKey, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.getSubMap(0, this.keySet.headIndex(Preconditions.checkNotNull(var1_1), (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ImmutableSortedMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(fromKey);
        Preconditions.checkNotNull(toKey);
        Preconditions.checkArgument(this.comparator().compare(fromKey, toKey) <= 0, "expected fromKey <= toKey but %s > %s", fromKey, toKey);
        return ((ImmutableSortedMap)this.headMap((Object)var3_3, toInclusive)).tailMap((Object)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    private ImmutableSortedMap<K, V> tailMap(K fromKey, boolean inclusive) {
        void var2_2;
        void var1_1;
        ImmutableSortedMap immutableSortedMap = this;
        return immutableSortedMap.getSubMap(immutableSortedMap.keySet.tailIndex(Preconditions.checkNotNull(var1_1), (boolean)var2_2), this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> lowerEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.headMap((Object)var1_1, false)).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K lowerKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.lowerEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> floorEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.headMap((Object)var1_1, true)).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K floorKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.floorEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> ceilingEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.tailMap((Object)var1_1, true)).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K ceilingKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.ceilingEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> higherEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.tailMap((Object)var1_1, false)).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K higherKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.higherEntry(var1_1));
    }

    @Override
    public final Map.Entry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        ImmutableSortedMap immutableSortedMap = this;
        return (Map.Entry)((ImmutableCollection)((Object)super.entrySet())).asList().get(0);
    }

    @Override
    public final Map.Entry<K, V> lastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        ImmutableSortedMap immutableSortedMap = this;
        return (Map.Entry)((ImmutableCollection)((Object)super.entrySet())).asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    static {
        Ordering.natural$75ffd5c5();
        NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableSortedSet.emptySet(Ordering.natural$75ffd5c5()), ImmutableList.of());
    }
}

