/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.math.LongMath;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Streams {
    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        Stream<? extends T>[] streamArray;
        void var1_1;
        void var3_3;
        void var2_2;
        boolean isParallel = false;
        int characteristics = 336;
        long estimatedSize = 0L;
        ImmutableList.Builder splitrsBuilder = new ImmutableList.Builder(streams.length);
        Stream<? extends T>[] streamArray2 = streams;
        int cfr_ignored_0 = streams.length;
        for (int i = 0; i < 2; ++i) {
            Stream<T> stream = streamArray2[i];
            isParallel |= stream.isParallel();
            Spliterator splitr2 = stream.spliterator();
            splitrsBuilder.add(splitr2);
            characteristics &= splitr2.characteristics();
            estimatedSize = LongMath.saturatedAdd(estimatedSize, splitr2.estimateSize());
        }
        return (Stream)StreamSupport.stream(CollectSpliterators.flatMap$3fbe4e8(((ImmutableCollection)splitrsBuilder.build()).spliterator(), splitr -> splitr, (int)var2_2, (long)var3_3), (boolean)var1_1).onClose(() -> {
            Stream[] streamArray = streamArray;
            Exception exception = null;
            for (Stream stream : streamArray) {
                try {
                    stream.close();
                }
                catch (Exception exception2) {
                    if (exception == null) {
                        exception = exception2;
                        continue;
                    }
                    exception.addSuppressed(exception2);
                }
            }
            if (exception != null) {
                streamArray = exception;
                final class SneakyThrower<T extends Throwable> {
                    SneakyThrower() {
                    }
                }
                new SneakyThrower();
                throw streamArray;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R> Stream<R> mapWithIndex(Stream<T> stream, FunctionWithIndex<? super T, ? extends R> function) {
        Stream<T> stream2;
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(stream);
        Preconditions.checkNotNull(function);
        boolean isParallel = stream.isParallel();
        Spliterator fromSpliterator = stream.spliterator();
        if (!fromSpliterator.hasCharacteristics(16384)) {
            Iterator fromIterator = Spliterators.iterator(fromSpliterator);
            return (Stream)StreamSupport.stream(new Spliterators.AbstractSpliterator<R>(fromSpliterator.estimateSize(), fromSpliterator.characteristics() & 0x50, fromIterator, function){
                private long index;
                private /* synthetic */ Iterator val$fromIterator;
                private /* synthetic */ FunctionWithIndex val$function;
                {
                    void var3_2;
                    void var1_1;
                    this.val$fromIterator = iterator;
                    this.val$function = functionWithIndex;
                    super((long)var1_1, (int)var3_2);
                    this.index = 0L;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final boolean tryAdvance(Consumer<? super R> action) {
                    if (this.val$fromIterator.hasNext()) {
                        void var1_1;
                        var1_1.accept(this.val$function.apply(this.val$fromIterator.next(), this.index++));
                        return true;
                    }
                    return false;
                }
            }, isParallel).onClose(stream::close);
        }
        final class Splitr
        extends MapWithIndexSpliterator<Spliterator<T>, R, Splitr>
        implements Consumer<T> {
            private T holder;
            private /* synthetic */ FunctionWithIndex val$function;

            /*
             * WARNING - void declaration
             */
            Splitr(Spliterator<T> splitr, long index) {
                void var2_2;
                void var1_1;
                this.val$function = var4_3;
                super(var1_1, (long)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void accept(T t) {
                void var1_1;
                this.holder = var1_1;
            }

            @Override
            public final boolean tryAdvance(Consumer<? super R> action) {
                if (this.fromSpliterator.tryAdvance(this)) {
                    try {
                        Object t;
                        void v0 = t;
                        t = this.holder;
                        v0.accept(this.val$function.apply(t, this.index++));
                        return true;
                    }
                    finally {
                        this.holder = null;
                    }
                }
                return false;
            }
        }
        return (Stream)StreamSupport.stream(new Splitr((Spliterator)var3_3, 0L, (FunctionWithIndex)var1_1), (boolean)var2_2).onClose(stream2::close);
    }

    public static interface FunctionWithIndex<T, R> {
        public R apply(T var1, long var2);
    }

    private static abstract class MapWithIndexSpliterator<F extends Spliterator<?>, R, S extends MapWithIndexSpliterator<F, R, S>>
    implements Spliterator<R> {
        final F fromSpliterator;
        long index;

        /*
         * WARNING - void declaration
         */
        MapWithIndexSpliterator(F fromSpliterator, long index) {
            void var2_2;
            void var1_1;
            this.fromSpliterator = var1_1;
            this.index = var2_2;
        }

        abstract S createSplit$4788208b(F var1, long var2);

        @Override
        public long estimateSize() {
            return this.fromSpliterator.estimateSize();
        }

        @Override
        public int characteristics() {
            return this.fromSpliterator.characteristics() & 0x4050;
        }
    }
}

