/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.Cut;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public final class TreeRangeMap<K extends Comparable, V>
implements RangeMap<K, V> {
    private final NavigableMap<Cut<K>, RangeMapEntry<K, V>> entriesByLowerBound = new TreeMap<Cut<K>, RangeMapEntry<K, V>>();

    public static <K extends Comparable, V> TreeRangeMap<K, V> create() {
        return new TreeRangeMap<K, V>();
    }

    private TreeRangeMap() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void put(Range<K> range, V value) {
        if (!range.isEmpty()) {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(value);
            Range<K> range2 = range;
            TreeRangeMap treeRangeMap = this;
            if (!range2.isEmpty()) {
                Map.Entry<Range<Object>, Object> entry;
                RangeMapEntry rangeMapEntry = treeRangeMap.entriesByLowerBound.lowerEntry(range2.lowerBound);
                if (rangeMapEntry != null && ((RangeMapEntry)(entry = rangeMapEntry.getValue())).getUpperBound().compareTo(range2.lowerBound) > 0) {
                    if (((RangeMapEntry)entry).getUpperBound().compareTo(range2.upperBound) > 0) {
                        treeRangeMap.putRangeMapEntry(range2.upperBound, ((RangeMapEntry)entry).getUpperBound(), ((RangeMapEntry)rangeMapEntry.getValue()).getValue());
                    }
                    treeRangeMap.putRangeMapEntry(((RangeMapEntry)entry).getLowerBound(), range2.lowerBound, ((RangeMapEntry)rangeMapEntry.getValue()).getValue());
                }
                if ((entry = treeRangeMap.entriesByLowerBound.lowerEntry(range2.upperBound)) != null && (rangeMapEntry = (RangeMapEntry)entry.getValue()).getUpperBound().compareTo(range2.upperBound) > 0) {
                    treeRangeMap.putRangeMapEntry(range2.upperBound, rangeMapEntry.getUpperBound(), ((RangeMapEntry)entry.getValue()).getValue());
                }
                treeRangeMap.entriesByLowerBound.subMap(range2.lowerBound, range2.upperBound).clear();
            }
            this.entriesByLowerBound.put(range.lowerBound, new RangeMapEntry(var1_1, var2_2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void putRangeMapEntry(Cut<K> lowerBound, Cut<K> upperBound, V value) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.entriesByLowerBound.put(lowerBound, new RangeMapEntry(var1_1, var2_2, var3_3));
    }

    @Override
    public final Map<Range<K>, V> asMapOfRanges() {
        TreeRangeMap treeRangeMap = this;
        return new AsMapOfRanges(treeRangeMap, treeRangeMap.entriesByLowerBound.values());
    }

    public final Map<Range<K>, V> asDescendingMapOfRanges$604efcea() {
        TreeRangeMap treeRangeMap = this;
        return new AsMapOfRanges(treeRangeMap, treeRangeMap.entriesByLowerBound.descendingMap().values());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        if (o instanceof RangeMap) {
            void var1_1;
            RangeMap rangeMap = (RangeMap)o;
            return this.asMapOfRanges().equals(var1_1.asMapOfRanges());
        }
        return false;
    }

    public final int hashCode() {
        return this.asMapOfRanges().hashCode();
    }

    public final String toString() {
        return this.entriesByLowerBound.values().toString();
    }

    static {
        new RangeMap<Comparable<?>, Object>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final void put(Range<Comparable<?>> range, Object value) {
                void var1_1;
                Preconditions.checkNotNull(range);
                throw new IllegalArgumentException("Cannot insert range " + var1_1 + " into an empty subRangeMap");
            }

            @Override
            public final Map<Range<Comparable<?>>, Object> asMapOfRanges() {
                return Collections.emptyMap();
            }
        };
    }

    private static final class RangeMapEntry<K extends Comparable, V>
    extends AbstractMapEntry<Range<K>, V> {
        private final Range<K> range;
        private final V value;

        /*
         * WARNING - void declaration
         */
        RangeMapEntry(Cut<K> lowerBound, Cut<K> upperBound, V value) {
            this(Range.create(var1_1, var2_2), var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        RangeMapEntry(Range<K> range, V value) {
            void var2_2;
            void var1_1;
            this.range = var1_1;
            this.value = var2_2;
        }

        @Override
        public final Range<K> getKey() {
            return this.range;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        final Cut<K> getLowerBound() {
            return this.range.lowerBound;
        }

        final Cut<K> getUpperBound() {
            return this.range.upperBound;
        }
    }

    private final class AsMapOfRanges
    extends Maps.IteratorBasedAbstractMap<Range<K>, V> {
        private Iterable<Map.Entry<Range<K>, V>> entryIterable;
        private /* synthetic */ TreeRangeMap this$0;

        /*
         * WARNING - void declaration
         */
        AsMapOfRanges(TreeRangeMap treeRangeMap, Iterable<RangeMapEntry<K, V>> entryIterable) {
            void var2_2;
            this.this$0 = treeRangeMap;
            this.entryIterable = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return this.get(var1_1) != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object key) {
            if (key instanceof Range) {
                void var1_1;
                Range range = (Range)key;
                RangeMapEntry rangeMapEntry = (RangeMapEntry)this.this$0.entriesByLowerBound.get(range.lowerBound);
                if (rangeMapEntry != null && ((Range)rangeMapEntry.getKey()).equals(var1_1)) {
                    void var2_2;
                    return var2_2.getValue();
                }
            }
            return null;
        }

        @Override
        public final int size() {
            return this.this$0.entriesByLowerBound.size();
        }

        @Override
        final Iterator<Map.Entry<Range<K>, V>> entryIterator() {
            return this.entryIterable.iterator();
        }
    }
}

