/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.io.AppendableWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.Buffer;
import java.nio.CharBuffer;

public final class CharStreams {
    /*
     * WARNING - void declaration
     */
    public static long copy(Readable from, Appendable to) throws IOException {
        void var2_2;
        if (from instanceof Reader) {
            if (to instanceof StringBuilder) {
                return CharStreams.copyReaderToBuilder((Reader)from, (StringBuilder)to);
            }
            return CharStreams.copyReaderToWriter((Reader)from, CharStreams.asWriter(to));
        }
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        long total = 0L;
        CharBuffer buf = CharBuffer.allocate(2048);
        while (from.read(buf) != -1) {
            CharBuffer charBuffer = buf;
            ((Buffer)charBuffer).flip();
            to.append(buf);
            total += (long)buf.remaining();
            charBuffer = buf;
            ((Buffer)charBuffer).clear();
        }
        return (long)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private static long copyReaderToBuilder(Reader from, StringBuilder to) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from.read(buf)) != -1) {
            void var3_4;
            to.append(buf, 0, nRead);
            total += (long)var3_4;
        }
        return total;
    }

    /*
     * WARNING - void declaration
     */
    private static long copyReaderToWriter(Reader from, Writer to) throws IOException {
        int nRead;
        Preconditions.checkNotNull(from);
        Preconditions.checkNotNull(to);
        char[] buf = new char[2048];
        long total = 0L;
        while ((nRead = from.read(buf)) != -1) {
            void var3_4;
            to.write(buf, 0, nRead);
            total += (long)var3_4;
        }
        return total;
    }

    public static String toString(Readable r) throws IOException {
        Readable readable = r;
        StringBuilder stringBuilder = new StringBuilder();
        if (readable instanceof Reader) {
            CharStreams.copyReaderToBuilder((Reader)readable, stringBuilder);
        } else {
            CharStreams.copy(readable, stringBuilder);
        }
        return stringBuilder.toString();
    }

    private static Writer asWriter(Appendable target) {
        Appendable appendable;
        if (target instanceof Writer) {
            return (Writer)target;
        }
        return new AppendableWriter(appendable);
    }
}

