/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.auto.value.AutoValue;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.java.AutoValue_FormatFileCallable_Result;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.StringWrapper;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import org.jspecify.annotations.Nullable;

class FormatFileCallable
implements Callable<Result> {
    private final Path path;
    private final String input;
    private final CommandLineOptions parameters;
    private final JavaFormatterOptions options;

    /*
     * WARNING - void declaration
     */
    public FormatFileCallable(CommandLineOptions parameters, Path path, String input, JavaFormatterOptions options) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.path = var2_2;
        this.input = var3_3;
        this.parameters = var1_1;
        this.options = options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Result call() {
        try {
            void var2_3;
            if (this.parameters.fixImportsOnly()) {
                FormatFileCallable formatFileCallable = this;
                return Result.create(this.path, this.input, formatFileCallable.fixImports(formatFileCallable.input), null);
            }
            Formatter formatter = new Formatter(this.options);
            FormatFileCallable formatFileCallable = this;
            String formatted = formatter.formatSource(this.input, formatFileCallable.characterRanges(formatFileCallable.input).asRanges());
            formatted = this.fixImports(formatted);
            if (this.parameters.reflowLongStrings()) {
                formatted = StringWrapper.wrap(100, formatted, formatter);
            }
            return Result.create(this.path, this.input, (String)var2_3, null);
        }
        catch (FormatterException e) {
            void var1_2;
            return Result.create(this.path, this.input, null, (FormatterException)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private String fixImports(String input) throws FormatterException {
        void var1_1;
        if (this.parameters.removeUnusedImports()) {
            input = RemoveUnusedImports.removeUnusedImports(input);
        }
        if (this.parameters.sortImports()) {
            input = ImportOrderer.reorderImports(input, this.options.style());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private RangeSet<Integer> characterRanges(String input) {
        void var2_3;
        TreeRangeSet<Integer> characterRanges = TreeRangeSet.create();
        if (this.parameters.lines().isEmpty() && this.parameters.offsets().isEmpty()) {
            characterRanges.add(Range.closedOpen(0, input.length()));
            return characterRanges;
        }
        characterRanges.addAll(Formatter.lineRangesToCharRanges(input, this.parameters.lines()));
        for (int i = 0; i < this.parameters.offsets().size(); ++i) {
            void var3_4;
            Integer length = (Integer)this.parameters.lengths().get(i);
            if (length == 0) {
                length = 1;
            }
            characterRanges.add(Range.closedOpen((Integer)this.parameters.offsets().get(i), (Integer)this.parameters.offsets().get(i) + var3_4.intValue()));
        }
        return var2_3;
    }

    @AutoValue
    static abstract class Result {
        Result() {
        }

        abstract @Nullable Path path();

        abstract String input();

        abstract @Nullable String output();

        boolean changed() {
            return !this.input().equals(this.output());
        }

        abstract @Nullable FormatterException exception();

        /*
         * WARNING - void declaration
         */
        static Result create(@Nullable Path path, String input, @Nullable String output, @Nullable FormatterException exception) {
            void var3_3;
            void var2_2;
            void var1_1;
            Path path2;
            return new AutoValue_FormatFileCallable_Result(path2, (String)var1_1, (String)var2_2, (FormatterException)var3_3);
        }
    }
}

