/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.Doc;
import com.google.googlejavaformat.DocBuilder;
import com.google.googlejavaformat.FormattingError;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.Output;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.ImportOrderer;
import com.google.googlejavaformat.java.JavaCommentsHelper;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.ModifierOrderer;
import com.google.googlejavaformat.java.RemoveUnusedImports;
import com.google.googlejavaformat.java.Replacement;
import com.google.googlejavaformat.java.StringWrapper;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOError;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

public final class Formatter {
    public static final int MAX_LINE_LENGTH = 100;
    static final Range<Integer> EMPTY_RANGE = Range.closedOpen(-1, -1);
    private final JavaFormatterOptions options;

    public Formatter() {
        this(JavaFormatterOptions.defaultOptions());
    }

    /*
     * WARNING - void declaration
     */
    public Formatter(JavaFormatterOptions options) {
        void var1_1;
        this.options = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static void format(final JavaInput javaInput, JavaOutput javaOutput, JavaFormatterOptions options) throws FormatterException {
        void var1_1;
        Doc doc;
        void var3_3;
        void var2_2;
        JavaInputAstVisitor visitor;
        Object context = new Context();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ((Context)context).put(DiagnosticListener.class, diagnostics);
        Options.instance((Context)context).put("allowStringFolding", "false");
        Options.instance((Context)context).put("--enable-preview", "true");
        JavacFileManager fileManager = new JavacFileManager((Context)context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){
            {
                void var2_2;
                void var1_1;
                super((URI)var1_1, (JavaFileObject.Kind)var2_2);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return ((Input)javaInput).getText();
            }
        };
        Log.instance((Context)context).useSource(source);
        context = ParserFactory.instance((Context)context);
        context = ((ParserFactory)context).newParser(((Input)javaInput).getText(), true, true, true);
        JCTree.JCCompilationUnit unit = ((JavacParser)context).parseCompilationUnit();
        ((JavacParser)context).parseCompilationUnit().sourcefile = source;
        javaInput.setCompilationUnit(unit);
        Iterables.4 errorDiagnostics = Iterables.filter$73b06d87(diagnostics.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            throw FormatterException.fromJavacDiagnostics(errorDiagnostics);
        }
        OpsBuilder builder = new OpsBuilder(javaInput, javaOutput);
        visitor = Runtime.version().feature() >= 21 ? Formatter.createVisitor("com.google.googlejavaformat.java.java21.Java21InputAstVisitor", builder, options) : (Runtime.version().feature() >= 17 ? Formatter.createVisitor("com.google.googlejavaformat.java.java17.Java17InputAstVisitor", builder, (JavaFormatterOptions)((Object)visitor)) : new JavaInputAstVisitor(builder, ((JavaFormatterOptions)((Object)visitor)).indentationMultiplier()));
        var2_2.scan((Tree)var3_3, null);
        builder.sync(((Input)javaInput).getText().length());
        builder.drain();
        Doc doc2 = new DocBuilder().withOps(builder.build()).build();
        doc2.computeBreaks(((Output)javaOutput).getCommentsHelper(), 100, new Doc.State(0, 0));
        doc.write(javaOutput);
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    private static JavaInputAstVisitor createVisitor(String className, OpsBuilder builder, JavaFormatterOptions options) {
        try {
            void var2_3;
            void var1_2;
            return Class.forName(className).asSubclass(JavaInputAstVisitor.class).getConstructor(OpsBuilder.class, Integer.TYPE).newInstance(var1_2, var2_3.indentationMultiplier());
        }
        catch (ReflectiveOperationException e) {
            void var0_1;
            throw new LinkageError(e.getMessage(), (Throwable)var0_1);
        }
    }

    static boolean errorDiagnostic(Diagnostic<?> input) {
        String string;
        if (input.getKind() != Diagnostic.Kind.ERROR) {
            return false;
        }
        switch (string.getCode()) {
            case "compiler.err.invalid.meth.decl.ret.type.req": {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void formatSource(CharSource input, CharSink output) throws FormatterException, IOException {
        void var1_1;
        output.write(this.formatSource(var1_1.read()));
    }

    /*
     * WARNING - void declaration
     */
    public final String formatSource(String input) throws FormatterException {
        void var1_1;
        return this.formatSource(input, ImmutableList.of$714caac3(Range.closedOpen(0, var1_1.length())));
    }

    public final String formatSourceAndFixImports(String input) throws FormatterException {
        String string;
        input = ImportOrderer.reorderImports(input, this.options.style());
        input = RemoveUnusedImports.removeUnusedImports(input);
        string = this.formatSource(string);
        string = StringWrapper.wrap(string, this);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final String formatSource(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        void var2_2;
        void var1_1;
        return JavaOutput.applyReplacements(input, this.getFormatReplacements((String)var1_1, (Collection<Range<Integer>>)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableList<Replacement> getFormatReplacements(String input, Collection<Range<Integer>> characterRanges) throws FormatterException {
        void var2_2;
        void var1_1;
        void var3_4;
        JavaInput javaInput = new JavaInput(input);
        if (this.options.reorderModifiers()) {
            javaInput = ModifierOrderer.reorderModifiers(javaInput, characterRanges);
        }
        String lineSeparator = Newlines.guessLineSeparator(input);
        JavaOutput javaOutput = new JavaOutput(lineSeparator, javaInput, new JavaCommentsHelper(lineSeparator, this.options));
        try {
            Formatter.format(javaInput, javaOutput, this.options);
        }
        catch (FormattingError e) {
            throw new FormatterException(e.diagnostics());
        }
        RangeSet<Integer> tokenRangeSet = var3_4.characterRangesToTokenRanges((Collection<Range<Integer>>)e);
        return var1_1.getFormatReplacements((RangeSet<Integer>)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        TreeRangeSet treeRangeSet;
        Iterator iterator;
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Iterators.addAll(lines, Newlines.lineOffsetIterator(input));
        lines.add(input.length() + 1);
        TreeRangeSet characterRanges = TreeRangeSet.create();
        for (Range lineRange : iterator.subRangeSet$f4d79cf(Range.closedOpen(0, lines.size() - 1)).asRanges()) {
            void var3_3;
            int lineStart = (Integer)lines.get((Integer)lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get((Integer)lineRange.upperEndpoint()) - 1;
            Range<Integer> range = Range.closedOpen(lineStart, lineEnd);
            characterRanges.add(var3_3);
        }
        return treeRangeSet;
    }
}

