/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Booleans;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.JavaInput;
import com.sun.tools.javac.parser.Tokens;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class ImportOrderer {
    private static final Splitter DOT_SPLITTER = Splitter.on('.');
    private static final ImmutableSet<Tokens.TokenKind> CLASS_START = ImmutableSet.of(Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM);
    private static final ImmutableSet<String> IMPORT_OR_CLASS_START = ImmutableSet.of("import", "class", "interface", "enum");
    private static final Comparator<Import> GOOGLE_IMPORT_COMPARATOR = Comparator.comparing(Import::isStatic, Booleans.trueFirst$b28f53a()).thenComparing(Import::imported);
    private static final Comparator<Import> AOSP_IMPORT_COMPARATOR = Comparator.comparing(Import::isStatic, Booleans.trueFirst$b28f53a()).thenComparing(Import::isAndroid, Booleans.trueFirst$b28f53a()).thenComparing(Import::isThirdParty, Booleans.trueFirst$b28f53a()).thenComparing(Import::isJava, Booleans.trueFirst$b28f53a()).thenComparing(Import::imported);
    private final String text;
    private final ImmutableList<JavaInput.Tok> toks;
    private final String lineSeparator;
    private final Comparator<Import> importComparator;
    private final BiFunction<Import, Import, Boolean> shouldInsertBlankLineFn;

    /*
     * WARNING - void declaration
     */
    public static String reorderImports(String text, JavaFormatterOptions.Style style) throws FormatterException {
        void var1_1;
        void var2_2;
        String string;
        ImmutableList<JavaInput.Tok> toks = JavaInput.buildToks(text, CLASS_START);
        return new ImportOrderer(string, (ImmutableList<JavaInput.Tok>)var2_2, (JavaFormatterOptions.Style)var1_1).reorderImports();
    }

    @Deprecated
    public static String reorderImports(String text) throws FormatterException {
        return ImportOrderer.reorderImports(text, JavaFormatterOptions.Style.GOOGLE);
    }

    /*
     * WARNING - void declaration
     */
    private String reorderImports() throws FormatterException {
        void var3_7;
        Optional<Integer> maybeFirstImport = this.findIdentifier(0, IMPORT_OR_CLASS_START);
        if (!maybeFirstImport.isPresent() || !this.tokenAt(maybeFirstImport.get()).equals("import")) {
            return this.text;
        }
        int firstImportStart = maybeFirstImport.get();
        int unindentedFirstImportStart = this.unindent(firstImportStart);
        ImportsAndIndex imports = this.scanImports(firstImportStart);
        int afterLastImport = imports.index;
        Optional<Integer> maybeLaterImport = this.findIdentifier(afterLastImport, IMPORT_OR_CLASS_START);
        if (maybeLaterImport.isPresent() && this.tokenAt(maybeLaterImport.get()).equals("import")) {
            throw new FormatterException("Imports not contiguous (perhaps a comment separates them?)");
        }
        StringBuilder result = new StringBuilder();
        String prefix = this.tokString(0, unindentedFirstImportStart);
        result.append(prefix);
        if (!prefix.isEmpty() && Newlines.getLineEnding(prefix) == null) {
            result.append(this.lineSeparator).append(this.lineSeparator);
        }
        result.append(this.reorderedImportsString(imports.imports));
        ArrayList<String> tail = new ArrayList<String>();
        tail.add(CharMatcher.whitespace().trimLeadingFrom(this.tokString((int)var3_7, this.toks.size())));
        if (!this.toks.isEmpty()) {
            void var2_6;
            JavaInput.Tok lastTok = Iterables.getLast(this.toks);
            int tailStart = lastTok.getPosition() + lastTok.length();
            tail.add(this.text.substring((int)var2_6));
        }
        if (tail.stream().anyMatch(s -> !s.isEmpty())) {
            void var1_3;
            result.append(this.lineSeparator);
            var1_3.forEach(result::append);
        }
        return result.toString();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean shouldInsertBlankLineGoogle(Import prev, Import curr) {
        void var1_1;
        return prev.isStatic() && !var1_1.isStatic();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean shouldInsertBlankLineAosp(Import prev, Import curr) {
        void var1_1;
        Import import_;
        if (prev.isStatic() && !curr.isStatic()) {
            return true;
        }
        if (prev.isAndroid() && !curr.isAndroid()) {
            return true;
        }
        return !import_.topLevel().equals(var1_1.topLevel());
    }

    /*
     * WARNING - void declaration
     */
    private ImportOrderer(String text, ImmutableList<JavaInput.Tok> toks, JavaFormatterOptions.Style style) {
        void var3_3;
        void var1_1;
        void var2_2;
        this.text = text;
        this.toks = var2_2;
        this.lineSeparator = Newlines.guessLineSeparator((String)var1_1);
        if (style.equals((Object)JavaFormatterOptions.Style.GOOGLE)) {
            this.importComparator = GOOGLE_IMPORT_COMPARATOR;
            this.shouldInsertBlankLineFn = ImportOrderer::shouldInsertBlankLineGoogle;
            return;
        }
        if (style.equals((Object)JavaFormatterOptions.Style.AOSP)) {
            this.importComparator = AOSP_IMPORT_COMPARATOR;
            this.shouldInsertBlankLineFn = ImportOrderer::shouldInsertBlankLineAosp;
            return;
        }
        throw new IllegalArgumentException("Unsupported code style: " + String.valueOf(var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private String tokString(int start, int end) {
        void var3_3;
        void i;
        StringBuilder sb = new StringBuilder();
        while (i < end) {
            sb.append(((JavaInput.Tok)this.toks.get((int)i)).getOriginalText());
            ++i;
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private ImportsAndIndex scanImports(int i) throws FormatterException {
        void var3_4;
        int n;
        int afterLastImport = i;
        ImmutableSortedSet.Builder<Import> imports = ImmutableSortedSet.orderedBy(this.importComparator);
        while (i < this.toks.size() && this.tokenAt(i).equals("import")) {
            void var1_2;
            boolean isStatic;
            if (this.isSpaceToken(++i)) {
                ++i;
            }
            if ((isStatic = this.tokenAt(i).equals("static")) && this.isSpaceToken(++i)) {
                ++i;
            }
            if (!this.isIdentifierToken(i)) {
                throw new FormatterException("Unexpected token after import: " + this.tokenAt(i));
            }
            StringAndIndex imported = this.scanImported(i);
            String importedName = imported.string;
            int n2 = var1_2.index;
            if (this.isSpaceToken(n2)) {
                ++n2;
            }
            if (!this.tokenAt(n2).equals(";")) {
                throw new FormatterException("Expected ; after import");
            }
            while (this.tokenAt(n2).equals(";")) {
                ++n2;
            }
            StringBuilder trailing = new StringBuilder();
            if (this.isSpaceToken(n2)) {
                trailing.append(this.tokenAt(n2));
                ++n2;
            }
            if (this.isNewlineToken(n2)) {
                trailing.append(this.tokenAt(n2));
                ++n2;
            }
            while (this.isSlashSlashCommentToken(n2)) {
                trailing.append(this.tokenAt(n2));
                if (!this.isNewlineToken(++n2)) continue;
                trailing.append(this.tokenAt(n2));
                ++n2;
            }
            while (this.tokenAt(n2).equals(";")) {
                ++n2;
            }
            imports.add((Object)new Import(this, importedName, trailing.toString(), n != 0));
            n = n2;
            while (this.isNewlineToken(n2) || this.isSpaceToken(n2)) {
                ++n2;
            }
        }
        return new ImportsAndIndex(var3_4.build$64ffd814(), n);
    }

    /*
     * WARNING - void declaration
     */
    private String reorderedImportsString(ImmutableSortedSet<Import> imports) {
        void var3_3;
        Iterator iterator;
        Preconditions.checkArgument(!imports.isEmpty(), "imports");
        Import prevImport = (Import)((ImmutableCollection)imports).iterator().next();
        StringBuilder sb = new StringBuilder();
        iterator = ((ImmutableCollection)((Object)iterator)).iterator();
        while (iterator.hasNext()) {
            Import currImport = (Import)iterator.next();
            if (this.shouldInsertBlankLineFn.apply(prevImport, currImport).booleanValue()) {
                sb.append(this.lineSeparator);
            }
            sb.append(currImport);
            prevImport = currImport;
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private StringAndIndex scanImported(int start) throws FormatterException {
        void var1_1;
        int i = start;
        StringBuilder imported = new StringBuilder();
        do {
            Preconditions.checkState(this.isIdentifierToken(i));
            imported.append(this.tokenAt(i));
            if (!this.tokenAt(++i).equals(".")) {
                return new StringAndIndex(imported.toString(), i);
            }
            imported.append('.');
            if (!this.tokenAt(++i).equals("*")) continue;
            imported.append('*');
            return new StringAndIndex(imported.toString(), i + 1);
        } while (this.isIdentifierToken(i));
        throw new FormatterException("Could not parse imported name, at: " + this.tokenAt((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private Optional<Integer> findIdentifier(int start, ImmutableSet<String> identifiers) {
        for (int i = start; i < this.toks.size(); ++i) {
            void var3_3;
            if (!this.isIdentifierToken(i)) continue;
            String id = this.tokenAt(i);
            if (!identifiers.contains(var3_3)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    /*
     * WARNING - void declaration
     */
    private int unindent(int i) {
        void var1_1;
        if (i > 0 && this.isSpaceToken(i - 1)) {
            return i - 1;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private String tokenAt(int i) {
        void var1_1;
        return ((JavaInput.Tok)this.toks.get((int)var1_1)).getOriginalText();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isIdentifierToken(int i) {
        void var1_2;
        String s = this.tokenAt(i);
        return !s.isEmpty() && Character.isJavaIdentifierStart(var1_2.codePointAt(0));
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSpaceToken(int i) {
        void var1_2;
        String s = this.tokenAt(i);
        if (s.isEmpty()) {
            return false;
        }
        return " \t\f".indexOf(var1_2.codePointAt(0)) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSlashSlashCommentToken(int i) {
        void var1_1;
        return ((JavaInput.Tok)this.toks.get((int)var1_1)).isSlashSlashComment();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isNewlineToken(int i) {
        void var1_1;
        return ((JavaInput.Tok)this.toks.get((int)var1_1)).isNewline();
    }

    private static class ImportsAndIndex {
        final ImmutableSortedSet<Import> imports;
        final int index;

        /*
         * WARNING - void declaration
         */
        ImportsAndIndex(ImmutableSortedSet<Import> imports, int index) {
            void var2_2;
            void var1_1;
            this.imports = var1_1;
            this.index = var2_2;
        }
    }

    class Import {
        private final String imported;
        private final boolean isStatic;
        private final String trailing;
        final /* synthetic */ ImportOrderer this$0;

        /*
         * WARNING - void declaration
         */
        Import(ImportOrderer this$0, String imported, String trailing, boolean isStatic) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.imported = var2_2;
            this.trailing = var3_3;
            this.isStatic = isStatic;
        }

        String imported() {
            return this.imported;
        }

        boolean isStatic() {
            return this.isStatic;
        }

        String topLevel() {
            return (String)DOT_SPLITTER.split$7a1f82da(this.imported()).iterator().next();
        }

        boolean isAndroid() {
            return Stream.of("android.", "androidx.", "dalvik.", "libcore.", "com.android.").anyMatch(this.imported::startsWith);
        }

        boolean isJava() {
            switch (this.topLevel()) {
                case "java": 
                case "javax": {
                    return true;
                }
            }
            return false;
        }

        String trailing() {
            return this.trailing;
        }

        public boolean isThirdParty() {
            return !this.isAndroid() && !this.isJava();
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder sb = new StringBuilder();
            sb.append("import ");
            if (this.isStatic()) {
                sb.append("static ");
            }
            sb.append(this.imported()).append(';');
            if (this.trailing().trim().isEmpty()) {
                sb.append(this.this$0.lineSeparator);
            } else {
                sb.append(this.trailing());
            }
            return var1_1.toString();
        }
    }

    private static class StringAndIndex {
        private final String string;
        private final int index;

        /*
         * WARNING - void declaration
         */
        StringAndIndex(String string, int index) {
            void var2_2;
            void var1_1;
            this.string = var1_1;
            this.index = var2_2;
        }
    }
}

