/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.TreeRangeSet;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.IdentifierTree;
import com.sun.source.doctree.ReferenceTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePathScanner;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.JavacParser;
import com.sun.tools.javac.parser.ParserFactory;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOError;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardLocation;

public class RemoveUnusedImports {
    /*
     * WARNING - void declaration
     */
    public static String removeUnusedImports(String contents) throws FormatterException {
        void var1_1;
        void var2_2;
        String string;
        Context context = new Context();
        JCTree.JCCompilationUnit unit = RemoveUnusedImports.parse(context, contents);
        if (unit == null) {
            return contents;
        }
        UnusedImportScanner scanner = new UnusedImportScanner(JavacTrees.instance(context));
        scanner.scan((Tree)unit, null);
        String string2 = string;
        return RemoveUnusedImports.applyReplacements(string2, RemoveUnusedImports.buildReplacements(string2, (JCTree.JCCompilationUnit)var2_2, scanner.usedNames, var1_1.usedInJavadoc));
    }

    /*
     * WARNING - void declaration
     */
    private static JCTree.JCCompilationUnit parse(Context context, final String javaInput) throws FormatterException {
        JCTree.JCCompilationUnit jCCompilationUnit;
        void var2_2;
        void var3_3;
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        ((Context)context).put(DiagnosticListener.class, diagnostics);
        Options.instance((Context)context).put("--enable-preview", "true");
        Options.instance((Context)context).put("allowStringFolding", "false");
        JavacFileManager fileManager = new JavacFileManager((Context)context, true, StandardCharsets.UTF_8);
        try {
            fileManager.setLocation(StandardLocation.PLATFORM_CLASS_PATH, ImmutableList.of());
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        SimpleJavaFileObject source = new SimpleJavaFileObject(URI.create("source"), JavaFileObject.Kind.SOURCE){
            {
                void var2_2;
                void var1_1;
                super((URI)var1_1, (JavaFileObject.Kind)var2_2);
            }

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return javaInput;
            }
        };
        Log.instance((Context)context).useSource(source);
        context = ParserFactory.instance((Context)context);
        context = ((ParserFactory)context).newParser(javaInput, true, true, true);
        JCTree.JCCompilationUnit unit = ((JavacParser)context).parseCompilationUnit();
        ((JavacParser)context).parseCompilationUnit().sourcefile = var3_3;
        Iterables.4 errorDiagnostics = Iterables.filter$73b06d87(var2_2.getDiagnostics(), Formatter::errorDiagnostic);
        if (!Iterables.isEmpty(errorDiagnostics)) {
            void var1_1;
            throw FormatterException.fromJavacDiagnostics((Iterable<Diagnostic<? extends JavaFileObject>>)var1_1);
        }
        return jCCompilationUnit;
    }

    private static RangeMap<Integer, String> buildReplacements(String contents, JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc) {
        TreeRangeMap<Integer, String> replacements = TreeRangeMap.create();
        for (JCTree importTree : unit.getImports()) {
            String sep;
            String simpleName;
            if (!RemoveUnusedImports.isUnused(unit, usedNames, usedInJavadoc, importTree, simpleName = RemoveUnusedImports.getSimpleName(importTree))) continue;
            int endPosition = importTree.getEndPosition(unit.endPositions);
            endPosition = Math.max(CharMatcher.isNot$8d21c63(' ').indexIn(contents, endPosition), endPosition);
            if (endPosition + (sep = Newlines.guessLineSeparator(contents)).length() < contents.length()) {
                int n = endPosition;
                if (contents.subSequence(n, n + sep.length()).toString().equals(sep)) {
                    endPosition += sep.length();
                }
            }
            replacements.put(Range.closedOpen(importTree.getStartPosition(), endPosition), "");
        }
        return replacements;
    }

    private static String getSimpleName(JCTree importTree) {
        return RemoveUnusedImports.getQualifiedIdentifier(importTree).getIdentifier().toString();
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isUnused(JCTree.JCCompilationUnit unit, Set<String> usedNames, Multimap<String, Range<Integer>> usedInJavadoc, JCTree importTree, String simpleName) {
        void var2_2;
        void var1_1;
        void var3_3;
        JCTree.JCCompilationUnit jCCompilationUnit;
        JCTree.JCFieldAccess qualifiedIdentifier = RemoveUnusedImports.getQualifiedIdentifier(importTree);
        String qualifier = qualifiedIdentifier.getExpression().toString();
        if (qualifier.equals("java.lang")) {
            return true;
        }
        if (unit.getPackageName() != null && jCCompilationUnit.getPackageName().toString().equals(qualifier)) {
            return true;
        }
        if (var3_3.getIdentifier().contentEquals("*")) {
            return false;
        }
        if (var1_1.contains(simpleName)) {
            return false;
        }
        return !var2_2.containsKey(simpleName);
    }

    /*
     * WARNING - void declaration
     */
    private static JCTree.JCFieldAccess getQualifiedIdentifier(JCTree importTree) {
        try {
            return (JCTree.JCFieldAccess)JCTree.JCImport.class.getMethod("getQualifiedIdentifier", new Class[0]).invoke((Object)importTree, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            void var0_1;
            throw new LinkageError(e.getMessage(), (Throwable)var0_1);
        }
    }

    private static String applyReplacements(String source, RangeMap<Integer, String> replacements) {
        CharSequence charSequence;
        Iterator iterator;
        TreeRangeSet<Integer> fixedRanges = TreeRangeSet.create();
        CharSequence sb = new StringBuilder(source);
        int offset = 0;
        for (Map.Entry replacement : iterator.asMapOfRanges().entrySet()) {
            Range range = replacement.getKey();
            String replaceWith = (String)replacement.getValue();
            int start = offset + (Integer)range.lowerEndpoint();
            int end = offset + (Integer)range.upperEndpoint();
            ((StringBuilder)sb).replace(start, end, replaceWith);
            if (!replaceWith.isEmpty()) {
                fixedRanges.add(Range.closedOpen(start, end));
            }
            offset += replaceWith.length() - ((Integer)range.upperEndpoint() - (Integer)range.lowerEndpoint());
        }
        return ((StringBuilder)charSequence).toString();
    }

    private static class UnusedImportScanner
    extends TreePathScanner<Void, Void> {
        private final Set<String> usedNames = new LinkedHashSet<String>();
        private final Multimap<String, Range<Integer>> usedInJavadoc = HashMultimap.create();
        final JavacTrees trees;
        final DocTreeScanner docTreeSymbolScanner;
        private static final Method CASE_TREE_GET_LABELS = UnusedImportScanner.caseTreeGetLabels();

        /*
         * WARNING - void declaration
         */
        private UnusedImportScanner(JavacTrees trees) {
            void var1_1;
            this.trees = var1_1;
            this.docTreeSymbolScanner = new DocTreeScanner(this);
        }

        @Override
        public Void visitImport(ImportTree importTree, Void usedSymbols) {
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitIdentifier(com.sun.source.tree.IdentifierTree tree, Void unused) {
            void var1_1;
            if (tree == null) {
                return null;
            }
            this.usedNames.add(var1_1.getName().toString());
            return null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void visitCase(CaseTree tree, Void unused) {
            void var1_1;
            if (CASE_TREE_GET_LABELS != null) {
                try {
                    this.scan((List)CASE_TREE_GET_LABELS.invoke((Object)tree, new Object[0]), null);
                }
                catch (ReflectiveOperationException e) {
                    void var1_2;
                    throw new LinkageError(e.getMessage(), (Throwable)var1_2);
                }
            }
            return (Void)super.visitCase((CaseTree)var1_1, null);
        }

        private static Method caseTreeGetLabels() {
            try {
                return CaseTree.class.getMethod("getLabels", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Void scan(Tree tree, Void unused) {
            void var2_2;
            void var1_1;
            if (tree == null) {
                return null;
            }
            this.scanJavadoc();
            return (Void)super.scan((Tree)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void scanJavadoc() {
            void var1_1;
            if (this.getCurrentPath() == null) {
                return;
            }
            DocCommentTree commentTree = this.trees.getDocCommentTree(this.getCurrentPath());
            if (commentTree == null) {
                return;
            }
            this.docTreeSymbolScanner.scan(new DocTreePath(this.getCurrentPath(), (DocCommentTree)var1_1), null);
        }

        class DocTreeScanner
        extends DocTreePathScanner<Void, Void> {
            final /* synthetic */ UnusedImportScanner this$0;

            /*
             * WARNING - void declaration
             */
            DocTreeScanner(UnusedImportScanner this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public Void visitIdentifier(IdentifierTree node, Void aVoid) {
                return null;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Void visitReference(ReferenceTree referenceTree, Void unused) {
                DCTree.DCReference reference = (DCTree.DCReference)referenceTree;
                long basePos = reference.pos((DCTree.DCDocComment)this.getCurrentPath().getDocComment()).getStartPosition();
                if (reference.qualifierExpression != null) {
                    new ReferenceScanner(basePos).scan(reference.qualifierExpression, null);
                }
                if (reference.paramTypes != null) {
                    Iterator<JCTree> iterator;
                    for (JCTree param : ((DCTree.DCReference)((Object)iterator)).paramTypes) {
                        void var2_2;
                        new ReferenceScanner(-1L).scan((Tree)var2_2, null);
                    }
                }
                return null;
            }

            private class ReferenceScanner
            extends TreeScanner<Void, Void> {
                private final long basePos;

                /*
                 * WARNING - void declaration
                 */
                public ReferenceScanner(long basePos) {
                    void var2_2;
                    this.basePos = var2_2;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Void visitIdentifier(com.sun.source.tree.IdentifierTree node, Void aVoid) {
                    void var2_2;
                    void var1_1;
                    DocTreeScanner.this.this$0.usedInJavadoc.put(node.getName().toString(), this.basePos != -1L ? Range.closedOpen((int)this.basePos, (int)this.basePos + node.getName().length()) : null);
                    return (Void)super.visitIdentifier((com.sun.source.tree.IdentifierTree)var1_1, var2_2);
                }
            }
        }
    }
}

