/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteOutput;
import com.google.protobuf.ByteString;
import com.google.protobuf.Internal;
import com.google.protobuf.LazyField;
import com.google.protobuf.LazyFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.UnknownFieldSet;
import com.google.protobuf.UnsafeUtil;
import com.google.protobuf.Utf8;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class CodedOutputStream
extends ByteOutput {
    private static final Logger logger = Logger.getLogger(CodedOutputStream.class.getName());
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.hasUnsafeArrayOperations();

    public static CodedOutputStream newInstance(byte[] flatArray) {
        byte[] byArray;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = flatArray;
        return new ArrayEncoder(byArray2, 0, n);
    }

    private CodedOutputStream() {
    }

    public abstract void writeTag(int var1, int var2) throws IOException;

    public abstract void writeInt32(int var1, int var2) throws IOException;

    public abstract void writeFixed32(int var1, int var2) throws IOException;

    public abstract void writeUInt64(int var1, long var2) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeUInt64((int)var1_1, CodedOutputStream.encodeZigZag64((long)var2_2));
    }

    public abstract void writeFixed64(int var1, long var2) throws IOException;

    public abstract void writeBool(int var1, boolean var2) throws IOException;

    public abstract void writeString(int var1, String var2) throws IOException;

    public abstract void writeBytes(int var1, ByteString var2) throws IOException;

    public abstract void writeMessage(int var1, MessageLite var2) throws IOException;

    public abstract void writeMessageSetExtension(int var1, MessageLite var2) throws IOException;

    public abstract void writeRawMessageSetExtension(int var1, ByteString var2) throws IOException;

    public abstract void writeInt32NoTag(int var1) throws IOException;

    public abstract void writeUInt32NoTag(int var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt32NoTag(int value) throws IOException {
        void var1_1;
        this.writeUInt32NoTag(CodedOutputStream.encodeZigZag32((int)var1_1));
    }

    public abstract void writeFixed32NoTag(int var1) throws IOException;

    public abstract void writeUInt64NoTag(long var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64NoTag(long value) throws IOException {
        void var1_1;
        this.writeUInt64NoTag(CodedOutputStream.encodeZigZag64((long)var1_1));
    }

    public abstract void writeFixed64NoTag(long var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeFloatNoTag(float value) throws IOException {
        void var1_1;
        this.writeFixed32NoTag(Float.floatToRawIntBits((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDoubleNoTag(double value) throws IOException {
        void var1_1;
        this.writeFixed64NoTag(Double.doubleToRawLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBoolNoTag(boolean value) throws IOException {
        void var1_1;
        this.write((byte)(var1_1 != false ? 1 : 0));
    }

    public abstract void writeStringNoTag(String var1) throws IOException;

    public abstract void writeBytesNoTag(ByteString var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public final void writeByteArrayNoTag(byte[] value) throws IOException {
        void var1_1;
        this.writeByteArrayNoTag(value, 0, ((void)var1_1).length);
    }

    public abstract void writeMessageNoTag(MessageLite var1) throws IOException;

    public abstract void write(byte var1) throws IOException;

    /*
     * WARNING - void declaration
     */
    public static int computeInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static int computeUInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(2) + CodedOutputStream.computeUInt32SizeNoTag((int)var1_1);
    }

    public static int computeFixed32Size(int fieldNumber, int value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 4;
    }

    /*
     * WARNING - void declaration
     */
    public static int computeInt64Size(int fieldNumber, long value) {
        void var1_1;
        void var3_2 = var1_1;
        return CodedOutputStream.computeTagSize(5) + CodedOutputStream.computeUInt64SizeNoTag((long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSInt64Size(int fieldNumber, long value) {
        void var1_1;
        void var3_2 = var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64((long)var3_2));
    }

    public static int computeFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 8;
    }

    public static int computeSFixed64Size(int fieldNumber, long value) {
        return CodedOutputStream.computeTagSize(5) + 8;
    }

    public static int computeDoubleSize(int fieldNumber, double value) {
        return CodedOutputStream.computeTagSize(6) + 8;
    }

    public static int computeBoolSize(int fieldNumber, boolean value) {
        return CodedOutputStream.computeTagSize(fieldNumber) + 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int computeEnumSize(int fieldNumber, int value) {
        void var1_1;
        int n = var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag(n);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeStringSize(int fieldNumber, String value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeStringSizeNoTag((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeBytesSize(int fieldNumber, ByteString value) {
        void var1_3;
        void var0_1 = var1_3;
        int n = var0_1.size();
        return CodedOutputStream.computeTagSize(fieldNumber) + (CodedOutputStream.computeUInt32SizeNoTag(n) + n);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeMessageSize(int fieldNumber, MessageLite value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag((MessageLite)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeMessageSetExtensionSize(int fieldNumber, MessageLite value) {
        void var1_1;
        int n;
        return (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeMessageSize(3, (MessageLite)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeRawMessageSetExtensionSize(int fieldNumber, ByteString value) {
        void var1_1;
        int n;
        return (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n) + CodedOutputStream.computeBytesSize(3, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeLazyFieldMessageSetExtensionSize$11c10712(int fieldNumber, LazyField value) {
        void var1_3;
        int n;
        int n2 = (CodedOutputStream.computeTagSize(1) << 1) + CodedOutputStream.computeUInt32Size(2, n);
        n = 3;
        void var0_1 = var1_3;
        int n3 = var0_1.getSerializedSize();
        return n2 + (CodedOutputStream.computeTagSize(3) + (CodedOutputStream.computeUInt32SizeNoTag(n3) + n3));
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeUInt32SizeNoTag(WireFormat.makeTag(fieldNumber, 0));
    }

    public static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            int n;
            return CodedOutputStream.computeUInt32SizeNoTag(n);
        }
        return 10;
    }

    public static int computeUInt32SizeNoTag(int value) {
        int n;
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public static int computeSInt32SizeNoTag(int value) {
        return CodedOutputStream.computeUInt32SizeNoTag(CodedOutputStream.encodeZigZag32(value));
    }

    public static int computeFixed32SizeNoTag$134621() {
        return 4;
    }

    public static int computeSFixed32SizeNoTag$134621() {
        return 4;
    }

    public static int computeInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(value);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeUInt64SizeNoTag(long value) {
        void var2_1;
        long l;
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if (value < 0L) {
            return 10;
        }
        int n = 2;
        if ((value & 0xFFFFFFF800000000L) != 0L) {
            n += 4;
            value >>>= 28;
        }
        if ((value & 0xFFFFFFFFFFE00000L) != 0L) {
            n += 2;
            value >>>= 14;
        }
        if ((l & 0xFFFFFFFFFFFFC000L) != 0L) {
            ++n;
        }
        return (int)var2_1;
    }

    public static int computeSInt64SizeNoTag(long value) {
        return CodedOutputStream.computeUInt64SizeNoTag(CodedOutputStream.encodeZigZag64(value));
    }

    public static int computeFixed64SizeNoTag$1349e2() {
        return 8;
    }

    public static int computeSFixed64SizeNoTag$1349e2() {
        return 8;
    }

    public static int computeFloatSizeNoTag$133ade() {
        return 4;
    }

    public static int computeDoubleSizeNoTag$13335c() {
        return 8;
    }

    public static int computeBoolSizeNoTag$1385f2() {
        return 1;
    }

    public static int computeEnumSizeNoTag(int value) {
        return CodedOutputStream.computeInt32SizeNoTag(value);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeStringSizeNoTag(String value) {
        void var1_2;
        int length;
        try {
            length = Utf8.encodedLength(value);
        }
        catch (Utf8.UnpairedSurrogateException unpairedSurrogateException) {
            Object object;
            byte[] byArray = ((String)object).getBytes(Internal.UTF_8);
            object = byArray;
            length = byArray.length;
        }
        void var0_1 = var1_2;
        return CodedOutputStream.computeUInt32SizeNoTag((int)var0_1) + var0_1;
    }

    public static int computeLazyFieldSizeNoTag(LazyFieldLite value) {
        int n = value.getSerializedSize();
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int computeBytesSizeNoTag(ByteString value) {
        int n = value.size();
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int computeByteArraySizeNoTag(byte[] value) {
        int n = value.length;
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    public static int computeMessageSizeNoTag(MessageLite value) {
        int n = value.getSerializedSize();
        return CodedOutputStream.computeUInt32SizeNoTag(n) + n;
    }

    private static int encodeZigZag32(int n) {
        int n2;
        return n << 1 ^ n2 >> 31;
    }

    private static long encodeZigZag64(long n) {
        long l;
        return n << 1 ^ l >> 63;
    }

    public abstract int spaceLeft();

    abstract void writeByteArrayNoTag(byte[] var1, int var2, int var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    final void inefficientWriteStringNoTag(String value, Utf8.UnpairedSurrogateException cause) throws IOException {
        void var2_3;
        logger.log(Level.WARNING, "Converting ill-formed UTF-16. Your Protocol Buffer will not round trip correctly!", (Throwable)var2_3);
        byte[] bytes = value.getBytes(Internal.UTF_8);
        try {
            this.writeUInt32NoTag(bytes.length);
            this.writeLazy(bytes, 0, bytes.length);
            return;
        }
        catch (IndexOutOfBoundsException e) {
            void var1_2;
            throw new OutOfSpaceException((Throwable)var1_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public final void writeGroup(int fieldNumber, MessageLite value) throws IOException {
        void var1_1;
        CodedOutputStream codedOutputStream;
        this.writeTag(fieldNumber, 3);
        void var3_3 = codedOutputStream;
        codedOutputStream = this;
        var3_3.writeTo(codedOutputStream);
        this.writeTag((int)var1_1, 4);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public static int computeGroupSize$18fe156d(int fieldNumber, UnknownFieldSet value) {
        void var1_1;
        return (CodedOutputStream.computeTagSize(fieldNumber) << 1) + var1_1.getSerializedSize();
    }

    @Deprecated
    public static int computeGroupSizeNoTag(MessageLite value) {
        return value.getSerializedSize();
    }

    /* synthetic */ CodedOutputStream(byte by) {
        this();
    }

    private static final class ArrayEncoder
    extends CodedOutputStream {
        private final byte[] buffer;
        private final int offset;
        private final int limit;
        private int position;

        /*
         * WARNING - void declaration
         */
        ArrayEncoder(byte[] buffer, int offset, int length) {
            super((byte)0);
            void var3_3;
            void var2_2;
            void var1_1;
            if (buffer == null) {
                throw new NullPointerException("buffer");
            }
            if ((offset | length | buffer.length - (offset + length)) < 0) {
                throw new IllegalArgumentException(String.format("Array range is invalid. Buffer.length=%d, offset=%d, length=%d", buffer.length, offset, length));
            }
            this.buffer = var1_1;
            this.offset = offset;
            this.position = offset;
            this.limit = var2_2 + var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeTag(int fieldNumber, int wireType) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(WireFormat.makeTag((int)var1_1, (int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private void writeUInt32(int fieldNumber, int value) throws IOException {
            void var2_2;
            ((CodedOutputStream)this).writeTag(2, 0);
            ((CodedOutputStream)this).writeUInt32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32(int fieldNumber, int value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 5);
            ((CodedOutputStream)this).writeFixed32NoTag((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).writeUInt64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64(int fieldNumber, long value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 1);
            ((CodedOutputStream)this).writeFixed64NoTag((long)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBool(int fieldNumber, boolean value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 0);
            ((CodedOutputStream)this).write((byte)(var2_2 != false ? 1 : 0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeString(int fieldNumber, String value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeStringNoTag((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeBytesNoTag((ByteString)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeBytesNoTag(ByteString value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.size());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeByteArrayNoTag(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(length);
            this.write((byte[])var1_1, 0, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessage(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag((int)var1_1, 2);
            ((CodedOutputStream)this).writeMessageNoTag((MessageLite)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            this.writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeMessage(3, (MessageLite)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeRawMessageSetExtension(int fieldNumber, ByteString value) throws IOException {
            void var2_2;
            void var1_1;
            ((CodedOutputStream)this).writeTag(1, 3);
            this.writeUInt32(2, (int)var1_1);
            ((CodedOutputStream)this).writeBytes(3, (ByteString)var2_2);
            ((CodedOutputStream)this).writeTag(1, 4);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeMessageNoTag(MessageLite value) throws IOException {
            void var1_1;
            ((CodedOutputStream)this).writeUInt32NoTag(value.getSerializedSize());
            var1_1.writeTo(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void write(byte value) throws IOException {
            try {
                this.buffer[this.position++] = value;
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeInt32NoTag(int value) throws IOException {
            void var1_1;
            if (value >= 0) {
                ((CodedOutputStream)this).writeUInt32NoTag(value);
                return;
            }
            ((CodedOutputStream)this).writeUInt64NoTag((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt32NoTag(int value) throws IOException {
            try {
                while (true) {
                    if ((value & 0xFFFFFF80) == 0) {
                        this.buffer[this.position++] = (byte)value;
                        return;
                    }
                    this.buffer[this.position++] = (byte)(value & 0x7F | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed32NoTag(int value) throws IOException {
            try {
                this.buffer[this.position++] = (byte)value;
                this.buffer[this.position++] = (byte)(value >> 8);
                this.buffer[this.position++] = (byte)(value >> 16);
                this.buffer[this.position++] = (byte)(value >>> 24);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeUInt64NoTag(long value) throws IOException {
            if (HAS_UNSAFE_ARRAY_OPERATIONS && ((CodedOutputStream)this).spaceLeft() >= 10) {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        UnsafeUtil.putByte(this.buffer, this.position++, (byte)value);
                        return;
                    }
                    UnsafeUtil.putByte(this.buffer, this.position++, (byte)((int)value & 0x7F | 0x80));
                    value >>>= 7;
                }
            }
            try {
                while (true) {
                    if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                        this.buffer[this.position++] = (byte)value;
                        return;
                    }
                    this.buffer[this.position++] = (byte)((int)value & 0x7F | 0x80);
                    value >>>= 7;
                }
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeFixed64NoTag(long value) throws IOException {
            try {
                this.buffer[this.position++] = (byte)value;
                this.buffer[this.position++] = (byte)(value >> 8);
                this.buffer[this.position++] = (byte)(value >> 16);
                this.buffer[this.position++] = (byte)(value >> 24);
                this.buffer[this.position++] = (byte)(value >> 32);
                this.buffer[this.position++] = (byte)(value >> 40);
                this.buffer[this.position++] = (byte)(value >> 48);
                this.buffer[this.position++] = (byte)(value >> 56);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, 1), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        private void write(byte[] value, int offset, int length) throws IOException {
            try {
                void var2_3;
                System.arraycopy(value, (int)var2_3, this.buffer, this.position, length);
                this.position += length;
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var1_2;
                void var3_4;
                throw new OutOfSpaceException(String.format("Pos: %d, limit: %d, len: %d", this.position, this.limit, (int)var3_4), (Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeLazy(byte[] value, int offset, int length) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            this.write((byte[])var1_1, (int)var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void writeStringNoTag(String value) throws IOException {
            int oldPosition = this.position;
            try {
                int n = value.length() * 3;
                int maxLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(n);
                int minLengthVarIntSize = ArrayEncoder.computeUInt32SizeNoTag(value.length());
                if (minLengthVarIntSize != maxLengthVarIntSize) {
                    int length = Utf8.encodedLength(value);
                    ((CodedOutputStream)this).writeUInt32NoTag(length);
                    this.position = Utf8.encode(value, this.buffer, this.position, ((CodedOutputStream)this).spaceLeft());
                    return;
                }
                this.position = oldPosition + minLengthVarIntSize;
                int newPosition = Utf8.encode(value, this.buffer, this.position, ((CodedOutputStream)this).spaceLeft());
                this.position = oldPosition;
                int length = newPosition - oldPosition - minLengthVarIntSize;
                ((CodedOutputStream)this).writeUInt32NoTag(length);
                this.position = newPosition;
            }
            catch (Utf8.UnpairedSurrogateException e) {
                void var1_1;
                void var2_2;
                this.position = var2_2;
                this.inefficientWriteStringNoTag((String)var1_1, e);
                return;
            }
            catch (IndexOutOfBoundsException e) {
                void var3_5;
                throw new OutOfSpaceException((Throwable)var3_5);
            }
        }

        @Override
        public final int spaceLeft() {
            return this.limit - this.position;
        }
    }

    public static final class OutOfSpaceException
    extends IOException {
        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }

        /*
         * WARNING - void declaration
         */
        OutOfSpaceException(Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.", (Throwable)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        OutOfSpaceException(String explanationMessage, Throwable cause) {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.: " + (String)var1_1, (Throwable)var2_2);
            void var2_2;
            void var1_1;
        }
    }
}

