/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.FieldSet;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormat;
import com.google.protobuf.WireFormat;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class Descriptors {
    private static final Logger logger = Logger.getLogger(Descriptors.class.getName());
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final Descriptor[] EMPTY_DESCRIPTORS = new Descriptor[0];
    private static final FieldDescriptor[] EMPTY_FIELD_DESCRIPTORS = new FieldDescriptor[0];
    private static final EnumDescriptor[] EMPTY_ENUM_DESCRIPTORS = new EnumDescriptor[0];
    private static final ServiceDescriptor[] EMPTY_SERVICE_DESCRIPTORS = new ServiceDescriptor[0];
    private static final OneofDescriptor[] EMPTY_ONEOF_DESCRIPTORS = new OneofDescriptor[0];

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$2100$59b1b5f5(GenericDescriptor[] x0, int x1, NumberGetter x2, int x3) {
        int n;
        GenericDescriptor[] genericDescriptorArray = x0;
        int n2 = 0;
        --n;
        while (n2 <= n) {
            void var3_3;
            void var2_2;
            int n3 = (n2 + n) / 2;
            GenericDescriptor genericDescriptor = genericDescriptorArray[n3];
            int n4 = var2_2.getNumber(genericDescriptor);
            if (var3_3 < n4) {
                n = n3 - 1;
                continue;
            }
            if (var3_3 > n4) {
                n2 = n3 + 1;
                continue;
            }
            return genericDescriptor;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$2300(FileDescriptor x0, Descriptor x1, String x2) {
        void var2_2;
        void var1_1;
        Object object = x0;
        if (var1_1 != null) {
            return var1_1.getFullName() + '.' + (String)var2_2;
        }
        if (!((String)(object = ((FileDescriptor)object).getPackage())).isEmpty()) {
            return (String)object + '.' + (String)var2_2;
        }
        return var2_2;
    }

    private static interface NumberGetter<T> {
        public int getNumber(T var1);
    }

    public static final class OneofDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.OneofDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private Descriptor containingType;
        private int fieldCount;
        private FieldDescriptor[] fields;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        public final Descriptor getContainingType() {
            return this.containingType;
        }

        public final int getFieldCount() {
            return this.fieldCount;
        }

        public final List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        @Deprecated
        public final boolean isSynthetic() {
            return this.fields.length == 1 && this.fields[0].isProto3Optional;
        }

        /*
         * WARNING - void declaration
         */
        private OneofDescriptor(DescriptorProtos.OneofDescriptorProto proto, FileDescriptor file, Descriptor parent, int index) {
            super((byte)0);
            void var3_3;
            void var2_2;
            void var1_1;
            this.proto = proto;
            this.fullName = Descriptors.access$2300(file, parent, var1_1.getName());
            this.file = var2_2;
            this.index = index;
            this.containingType = var3_3;
            this.fieldCount = 0;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ OneofDescriptor(DescriptorProtos.OneofDescriptorProto x0, FileDescriptor x1, Descriptor x2, int x3, byte by) {
            this((DescriptorProtos.OneofDescriptorProto)var1_1, (FileDescriptor)var2_2, (Descriptor)var3_3, x3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ FieldDescriptor[] access$2502(OneofDescriptor x0, FieldDescriptor[] x1) {
            void var1_1;
            x0.fields = var1_1;
            return x0.fields;
        }

        static /* synthetic */ int access$2602(OneofDescriptor x0, int x1) {
            x0.fieldCount = 0;
            return 0;
        }
    }

    private static final class DescriptorPool {
        private final Set<FileDescriptor> dependencies;
        private final boolean allowUnknownDependencies;
        private final Map<String, GenericDescriptor> descriptorsByName = new HashMap<String, GenericDescriptor>();

        /*
         * WARNING - void declaration
         */
        DescriptorPool(FileDescriptor[] dependencies, boolean allowUnknownDependencies) {
            Iterator<FileDescriptor> iterator;
            this.dependencies = Collections.newSetFromMap(new IdentityHashMap(dependencies.length));
            this.allowUnknownDependencies = allowUnknownDependencies;
            for (void dependency : iterator) {
                this.dependencies.add((FileDescriptor)dependency);
                this.importPublicDependencies((FileDescriptor)dependency);
            }
            for (FileDescriptor dependency : this.dependencies) {
                try {
                    void var2_3;
                    this.addPackage(dependency.getPackage(), (FileDescriptor)var2_3);
                }
                catch (DescriptorValidationException e) {
                    void var3_5;
                    throw new AssertionError(var3_5);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private void importPublicDependencies(FileDescriptor file) {
            for (FileDescriptor dependency : file.getPublicDependencies()) {
                void var2_2;
                if (!this.dependencies.add(dependency)) continue;
                this.importPublicDependencies((FileDescriptor)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        final GenericDescriptor findSymbol(String fullName) {
            void var1_1;
            return this.findSymbol$1fc6aab4((String)var1_1, SearchFilter.ALL_SYMBOLS$57ab58ea);
        }

        private GenericDescriptor findSymbol$1fc6aab4(String fullName, int filter) {
            GenericDescriptor genericDescriptor = this.descriptorsByName.get(fullName);
            if (genericDescriptor != null && (filter == SearchFilter.ALL_SYMBOLS$57ab58ea || filter == SearchFilter.TYPES_ONLY$57ab58ea && DescriptorPool.isType(genericDescriptor) || filter == SearchFilter.AGGREGATES_ONLY$57ab58ea && DescriptorPool.isAggregate(genericDescriptor))) {
                return genericDescriptor;
            }
            for (FileDescriptor fileDescriptor : this.dependencies) {
                GenericDescriptor genericDescriptor2 = ((FileDescriptor)fileDescriptor).pool.descriptorsByName.get(fullName);
                if (genericDescriptor2 == null || filter != SearchFilter.ALL_SYMBOLS$57ab58ea && (filter != SearchFilter.TYPES_ONLY$57ab58ea || !DescriptorPool.isType(genericDescriptor2)) && (filter != SearchFilter.AGGREGATES_ONLY$57ab58ea || !DescriptorPool.isAggregate(genericDescriptor2))) continue;
                return genericDescriptor2;
            }
            return null;
        }

        private static boolean isType(GenericDescriptor descriptor) {
            GenericDescriptor genericDescriptor;
            return descriptor instanceof Descriptor || genericDescriptor instanceof EnumDescriptor;
        }

        private static boolean isAggregate(GenericDescriptor descriptor) {
            GenericDescriptor genericDescriptor;
            return descriptor instanceof Descriptor || descriptor instanceof EnumDescriptor || descriptor instanceof PackageDescriptor || genericDescriptor instanceof ServiceDescriptor;
        }

        /*
         * WARNING - void declaration
         */
        final GenericDescriptor lookupSymbol$45e5caf3(String name, GenericDescriptor relativeTo, int filter) throws DescriptorValidationException {
            GenericDescriptor result;
            String fullname2;
            if (name.startsWith(".")) {
                fullname2 = name.substring(1);
                result = this.findSymbol$1fc6aab4(fullname2, filter);
            } else {
                int firstPartLength = name.indexOf(46);
                String firstPart = firstPartLength == -1 ? name : name.substring(0, firstPartLength);
                StringBuilder scopeToTry = new StringBuilder(relativeTo.getFullName());
                while (true) {
                    int dotpos;
                    if ((dotpos = scopeToTry.lastIndexOf(".")) == -1) {
                        fullname2 = name;
                        result = this.findSymbol$1fc6aab4(name, filter);
                        break;
                    }
                    scopeToTry.setLength(dotpos + 1);
                    scopeToTry.append(firstPart);
                    result = this.findSymbol$1fc6aab4(scopeToTry.toString(), SearchFilter.AGGREGATES_ONLY$57ab58ea);
                    if (result != null) {
                        void fullname;
                        if (fullname != -1) {
                            scopeToTry.setLength(dotpos + 1);
                            scopeToTry.append(name);
                            result = this.findSymbol$1fc6aab4(scopeToTry.toString(), filter);
                        }
                        fullname2 = scopeToTry.toString();
                        break;
                    }
                    scopeToTry.setLength(dotpos);
                }
            }
            if (result == null) {
                void var1_1;
                void var2_2;
                void var3_3;
                if (this.allowUnknownDependencies && var3_3 == SearchFilter.TYPES_ONLY$57ab58ea) {
                    logger.warning("The descriptor for message type \"" + name + "\" cannot be found and a placeholder is created for it");
                    result = new Descriptor(fullname2);
                    this.dependencies.add(result.getFile());
                    return result;
                }
                throw new DescriptorValidationException((GenericDescriptor)var2_2, "\"" + (String)var1_1 + "\" is not defined.", 0);
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        final void addSymbol(GenericDescriptor descriptor) throws DescriptorValidationException {
            GenericDescriptor genericDescriptor = descriptor;
            String string = genericDescriptor.getName();
            if (string.length() == 0) {
                throw new DescriptorValidationException(genericDescriptor, "Missing name.", 0);
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '_' || '0' <= c && c <= '9' && i > 0) continue;
                throw new DescriptorValidationException(genericDescriptor, "\"" + string + "\" is not a valid identifier.", 0);
            }
            String fullName = descriptor.getFullName();
            GenericDescriptor old = this.descriptorsByName.put(fullName, descriptor);
            if (old != null) {
                void var1_1;
                this.descriptorsByName.put(fullName, old);
                if (descriptor.getFile() == old.getFile()) {
                    void var3_4;
                    int dotpos = fullName.lastIndexOf(46);
                    if (dotpos == -1) {
                        throw new DescriptorValidationException(descriptor, "\"" + fullName + "\" is already defined.", 0);
                    }
                    throw new DescriptorValidationException(descriptor, "\"" + fullName.substring(dotpos + 1) + "\" is already defined in \"" + fullName.substring(0, (int)var3_4) + "\".", 0);
                }
                throw new DescriptorValidationException((GenericDescriptor)var1_1, "\"" + (String)((Object)genericDescriptor) + "\" is already defined in file \"" + ((GenericDescriptor)((GenericDescriptor)((Object)string)).getFile()).getName() + "\".", 0);
            }
        }

        /*
         * WARNING - void declaration
         */
        final void addPackage(String fullName, FileDescriptor file) throws DescriptorValidationException {
            String name22;
            int dotpos = fullName.lastIndexOf(46);
            if (dotpos == -1) {
                name22 = fullName;
            } else {
                void name22;
                this.addPackage(fullName.substring(0, (int)name22), file);
                name22 = fullName.substring((int)(name22 + true));
            }
            GenericDescriptor old = this.descriptorsByName.put(fullName, new PackageDescriptor(name22, fullName, file));
            if (old != null) {
                void var1_1;
                this.descriptorsByName.put((String)var1_1, old);
                if (!(old instanceof PackageDescriptor)) {
                    void var3_4;
                    void var2_2;
                    throw new DescriptorValidationException((FileDescriptor)var2_2, "\"" + (String)var3_4 + "\" is already defined (as something other than a package) in file \"" + ((GenericDescriptor)old.getFile()).getName() + "\".", 0);
                }
            }
        }

        private static final class PackageDescriptor
        extends GenericDescriptor {
            private final String name;
            private final String fullName;
            private final FileDescriptor file;

            @Override
            public final GeneratedMessageV3 toProto$7e8c9165() {
                return this.file.toProto();
            }

            @Override
            public final String getName() {
                return this.name;
            }

            @Override
            public final String getFullName() {
                return this.fullName;
            }

            @Override
            public final FileDescriptor getFile() {
                return this.file;
            }

            /*
             * WARNING - void declaration
             */
            PackageDescriptor(String name, String fullName, FileDescriptor file) {
                super((byte)0);
                void var1_1;
                void var2_2;
                void var3_3;
                this.file = var3_3;
                this.fullName = var2_2;
                this.name = var1_1;
            }
        }

        static final class SearchFilter
        extends Enum<SearchFilter> {
            public static final int TYPES_ONLY$57ab58ea = 1;
            public static final int AGGREGATES_ONLY$57ab58ea = 2;
            public static final int ALL_SYMBOLS$57ab58ea = 3;

            static {
                int[] nArray = new int[]{TYPES_ONLY$57ab58ea, AGGREGATES_ONLY$57ab58ea, ALL_SYMBOLS$57ab58ea};
            }
        }
    }

    public static final class DescriptorValidationException
    extends Exception {
        private final String name;
        private final Message proto;
        private final String description;

        /*
         * WARNING - void declaration
         */
        private DescriptorValidationException(GenericDescriptor problemDescriptor, String description) {
            super(problemDescriptor.getFullName() + ": " + description);
            void var2_2;
            void var1_1;
            this.name = problemDescriptor.getFullName();
            this.proto = var1_1.toProto$7e8c9165();
            this.description = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        private DescriptorValidationException(GenericDescriptor problemDescriptor, String description, Throwable cause) {
            this((GenericDescriptor)var1_1, (String)var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.initCause((Throwable)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        private DescriptorValidationException(FileDescriptor problemDescriptor, String description) {
            super(((GenericDescriptor)problemDescriptor).getName() + ": " + description);
            void var2_2;
            void var1_1;
            this.name = ((GenericDescriptor)problemDescriptor).getName();
            this.proto = var1_1.toProto();
            this.description = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DescriptorValidationException(FileDescriptor x0, String x1, byte by) {
            this((FileDescriptor)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DescriptorValidationException(GenericDescriptor x0, String x1, byte by) {
            this((GenericDescriptor)var1_1, (String)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ DescriptorValidationException(FieldDescriptor x0, String x1, Throwable x2) {
            this((GenericDescriptor)var1_1, (String)var2_2, (Throwable)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public static abstract class GenericDescriptor {
        private GenericDescriptor() {
        }

        public abstract GeneratedMessageV3 toProto$7e8c9165();

        public abstract String getName();

        public abstract String getFullName();

        public abstract FileDescriptor getFile();

        /* synthetic */ GenericDescriptor(byte by) {
            this();
        }
    }

    public static final class MethodDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.MethodDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final ServiceDescriptor service;
        private Descriptor inputType;
        private Descriptor outputType;

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        /*
         * WARNING - void declaration
         */
        private MethodDescriptor(DescriptorProtos.MethodDescriptorProto proto, FileDescriptor file, ServiceDescriptor parent, int index) throws DescriptorValidationException {
            super((byte)0);
            void var2_2;
            void var1_1;
            void var3_3;
            this.index = index;
            this.proto = proto;
            this.file = file;
            this.service = parent;
            this.fullName = var3_3.getFullName() + '.' + var1_1.getName();
            ((FileDescriptor)var2_2).pool.addSymbol(this);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ MethodDescriptor(DescriptorProtos.MethodDescriptorProto x0, FileDescriptor x1, ServiceDescriptor x2, int x3, byte by) throws DescriptorValidationException {
            this((DescriptorProtos.MethodDescriptorProto)var1_1, (FileDescriptor)var2_2, (ServiceDescriptor)var3_3, x3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        static /* synthetic */ void access$4000(MethodDescriptor x0) throws DescriptorValidationException {
            MethodDescriptor methodDescriptor;
            GenericDescriptor genericDescriptor = methodDescriptor = x0;
            genericDescriptor = methodDescriptor.file.pool.lookupSymbol$45e5caf3(methodDescriptor.proto.getInputType(), methodDescriptor, DescriptorPool.SearchFilter.TYPES_ONLY$57ab58ea);
            if (!(genericDescriptor instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)methodDescriptor, "\"" + methodDescriptor.proto.getInputType() + "\" is not a message type.", 0);
            }
            methodDescriptor.inputType = (Descriptor)genericDescriptor;
            genericDescriptor = methodDescriptor;
            genericDescriptor = genericDescriptor.file.pool.lookupSymbol$45e5caf3(methodDescriptor.proto.getOutputType(), methodDescriptor, DescriptorPool.SearchFilter.TYPES_ONLY$57ab58ea);
            if (!(genericDescriptor instanceof Descriptor)) {
                throw new DescriptorValidationException((GenericDescriptor)methodDescriptor, "\"" + methodDescriptor.proto.getOutputType() + "\" is not a message type.", 0);
            }
            methodDescriptor.outputType = (Descriptor)genericDescriptor;
        }
    }

    public static final class ServiceDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.ServiceDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private MethodDescriptor[] methods;

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        /*
         * WARNING - void declaration
         */
        private ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto proto, FileDescriptor file, int index) throws DescriptorValidationException {
            super((byte)0);
            void var2_2;
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.access$2300(file, null, proto.getName());
            this.file = file;
            this.methods = new MethodDescriptor[proto.getMethodCount()];
            for (int i = 0; i < proto.getMethodCount(); ++i) {
                this.methods[i] = new MethodDescriptor(proto.getMethod(i), file, this, i, 0);
            }
            ((FileDescriptor)var2_2).pool.addSymbol(this);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ServiceDescriptor(DescriptorProtos.ServiceDescriptorProto x0, FileDescriptor x1, int x2, byte by) throws DescriptorValidationException {
            this((DescriptorProtos.ServiceDescriptorProto)var1_1, (FileDescriptor)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        static /* synthetic */ void access$1300(ServiceDescriptor x0) throws DescriptorValidationException {
            ServiceDescriptor serviceDescriptor = x0;
            MethodDescriptor[] methodDescriptorArray = serviceDescriptor;
            methodDescriptorArray = serviceDescriptor.methods;
            int n = serviceDescriptor.methods.length;
            for (int i = 0; i < n; ++i) {
                MethodDescriptor methodDescriptor = methodDescriptorArray[i];
                MethodDescriptor.access$4000(methodDescriptor);
            }
        }
    }

    public static final class EnumValueDescriptor
    extends GenericDescriptor
    implements Internal.EnumLite {
        static final Comparator<EnumValueDescriptor> BY_NUMBER$3706e907 = new Comparator<EnumValueDescriptor>(){};
        static final NumberGetter<EnumValueDescriptor> NUMBER_GETTER$765ad3f = new NumberGetter<EnumValueDescriptor>(){};
        private final int index;
        private DescriptorProtos.EnumValueDescriptorProto proto;
        private final String fullName;
        private final EnumDescriptor type;

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final int getNumber() {
            return this.proto.getNumber();
        }

        public final String toString() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.type.file;
        }

        /*
         * WARNING - void declaration
         */
        private EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto proto, FileDescriptor file, EnumDescriptor parent, int index) throws DescriptorValidationException {
            super((byte)0);
            void var2_2;
            void var1_1;
            void var3_3;
            this.index = index;
            this.proto = proto;
            this.type = parent;
            this.fullName = var3_3.getFullName() + '.' + var1_1.getName();
            ((FileDescriptor)var2_2).pool.addSymbol(this);
        }

        /*
         * WARNING - void declaration
         */
        private EnumValueDescriptor(EnumDescriptor parent, Integer number) {
            super((byte)0);
            void var2_2;
            void var1_1;
            void var3_3;
            String name = "UNKNOWN_ENUM_VALUE_" + ((GenericDescriptor)parent).getName() + "_" + number;
            DescriptorProtos.EnumValueDescriptorProto proto = DescriptorProtos.EnumValueDescriptorProto.newBuilder().setName((String)var3_3).setNumber(number).build();
            this.index = -1;
            this.proto = proto;
            this.type = parent;
            this.fullName = var1_1.getFullName() + '.' + var2_2.getName();
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EnumValueDescriptor(EnumDescriptor x0, Integer x1, byte by) {
            this((EnumDescriptor)var1_1, (Integer)var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EnumValueDescriptor(DescriptorProtos.EnumValueDescriptorProto x0, FileDescriptor x1, EnumDescriptor x2, int x3, byte by) throws DescriptorValidationException {
            this((DescriptorProtos.EnumValueDescriptorProto)var1_1, (FileDescriptor)var2_2, (EnumDescriptor)var3_3, x3);
            void var3_3;
            void var2_2;
            void var1_1;
        }
    }

    public static final class EnumDescriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.EnumDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final EnumValueDescriptor[] values;
        private final EnumValueDescriptor[] valuesSortedByNumber;
        private final int distinctNumbers;
        private Map<Integer, WeakReference<EnumValueDescriptor>> unknownValues = null;
        private ReferenceQueue<EnumValueDescriptor> cleanupQueue = null;

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final List<EnumValueDescriptor> getValues() {
            return Collections.unmodifiableList(Arrays.asList(this.values));
        }

        /*
         * WARNING - void declaration
         */
        public final EnumValueDescriptor findValueByName(String name) {
            GenericDescriptor result = this.file.pool.findSymbol(this.fullName + '.' + name);
            if (result instanceof EnumValueDescriptor) {
                void var1_1;
                return (EnumValueDescriptor)var1_1;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final EnumValueDescriptor findValueByNumber(int number) {
            void var1_1;
            return (EnumValueDescriptor)Descriptors.access$2100$59b1b5f5(this.valuesSortedByNumber, this.distinctNumbers, EnumValueDescriptor.NUMBER_GETTER$765ad3f, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final EnumValueDescriptor findValueByNumberCreatingIfUnknown(int number) {
            EnumValueDescriptor enumValueDescriptor;
            EnumValueDescriptor result = this.findValueByNumber(number);
            if (result != null) {
                return result;
            }
            EnumDescriptor enumDescriptor = this;
            synchronized (enumDescriptor) {
                if (this.cleanupQueue == null) {
                    this.cleanupQueue = new ReferenceQueue();
                    this.unknownValues = new HashMap<Integer, WeakReference<EnumValueDescriptor>>();
                } else {
                    UnknownEnumValueReference toClean;
                    while ((toClean = (UnknownEnumValueReference)this.cleanupQueue.poll()) != null) {
                        this.unknownValues.remove(toClean.number);
                    }
                }
                WeakReference<EnumValueDescriptor> reference = this.unknownValues.get(number);
                enumValueDescriptor = reference == null ? null : (EnumValueDescriptor)((Reference)((Object)enumValueDescriptor)).get();
                if (enumValueDescriptor == null) {
                    void var1_1;
                    enumValueDescriptor = new EnumValueDescriptor(this, number, 0);
                    this.unknownValues.put(number, new UnknownEnumValueReference((int)var1_1, enumValueDescriptor, 0));
                }
            }
            return enumValueDescriptor;
        }

        /*
         * WARNING - void declaration
         */
        private EnumDescriptor(DescriptorProtos.EnumDescriptorProto proto, FileDescriptor file, Descriptor parent, int index) throws DescriptorValidationException {
            super((byte)0);
            void var2_2;
            void var1_1;
            void var3_4;
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.access$2300(file, parent, proto.getName());
            this.file = file;
            this.containingType = parent;
            if (proto.getValueCount() == 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Enums must contain at least one value.", 0);
            }
            this.values = new EnumValueDescriptor[proto.getValueCount()];
            for (int i = 0; i < proto.getValueCount(); ++i) {
                this.values[i] = new EnumValueDescriptor(proto.getValue(i), file, this, i, 0);
            }
            this.valuesSortedByNumber = (EnumValueDescriptor[])this.values.clone();
            Arrays.sort(this.valuesSortedByNumber, EnumValueDescriptor.BY_NUMBER$3706e907);
            int j = 0;
            for (int i = 1; i < proto.getValueCount(); ++i) {
                EnumValueDescriptor oldValue = this.valuesSortedByNumber[j];
                EnumValueDescriptor newValue = this.valuesSortedByNumber[i];
                if (oldValue.getNumber() == newValue.getNumber()) continue;
                this.valuesSortedByNumber[++j] = newValue;
            }
            this.distinctNumbers = var3_4 + true;
            Arrays.fill(this.valuesSortedByNumber, this.distinctNumbers, var1_1.getValueCount(), null);
            ((FileDescriptor)var2_2).pool.addSymbol(this);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EnumDescriptor(DescriptorProtos.EnumDescriptorProto x0, FileDescriptor x1, Descriptor x2, int x3, byte by) throws DescriptorValidationException {
            this((DescriptorProtos.EnumDescriptorProto)var1_1, (FileDescriptor)var2_2, (Descriptor)var3_3, x3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        private static final class UnknownEnumValueReference
        extends WeakReference<EnumValueDescriptor> {
            private final int number;

            /*
             * WARNING - void declaration
             */
            private UnknownEnumValueReference(int number, EnumValueDescriptor descriptor) {
                super(var2_2);
                void var1_1;
                void var2_2;
                this.number = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            /* synthetic */ UnknownEnumValueReference(int x0, EnumValueDescriptor x1, byte by) {
                this((int)var1_1, (EnumValueDescriptor)var2_2);
                void var2_2;
                void var1_1;
            }
        }
    }

    public static final class FieldDescriptor
    extends GenericDescriptor
    implements FieldSet.FieldDescriptorLite<FieldDescriptor>,
    Comparable<FieldDescriptor> {
        private static final NumberGetter<FieldDescriptor> NUMBER_GETTER$765ad3f = new NumberGetter<FieldDescriptor>(){};
        private static final WireFormat.FieldType[] table = WireFormat.FieldType.values();
        private final int index;
        private DescriptorProtos.FieldDescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor extensionScope;
        private final boolean isProto3Optional;
        private Type type;
        private Descriptor containingType;
        private Descriptor messageType;
        private OneofDescriptor containingOneof;
        private EnumDescriptor enumType;
        private Object defaultValue;

        public final int getIndex() {
            return this.index;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final int getNumber() {
            return this.proto.getNumber();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        public final JavaType getJavaType() {
            return this.type.getJavaType();
        }

        @Override
        public final WireFormat.JavaType getLiteJavaType() {
            return this.getLiteType().getJavaType();
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final Type getType() {
            return this.type;
        }

        @Override
        public final WireFormat.FieldType getLiteType() {
            return table[this.type.ordinal()];
        }

        public final boolean needsUtf8Check() {
            if (this.type != Type.STRING) {
                return false;
            }
            FieldDescriptor fieldDescriptor = this;
            if (fieldDescriptor.containingType.getOptions().getMapEntry()) {
                return true;
            }
            fieldDescriptor = this;
            if (fieldDescriptor.file.getSyntax() == FileDescriptor.Syntax.PROTO3) {
                return true;
            }
            fieldDescriptor = this;
            return fieldDescriptor.file.getOptions().getJavaStringCheckUtf8();
        }

        public final boolean isMapField() {
            FieldDescriptor fieldDescriptor = this;
            return fieldDescriptor.type == Type.MESSAGE && this.isRepeated() && this.getMessageType().getOptions().getMapEntry();
        }

        public final boolean isRequired() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED;
        }

        public final boolean isOptional() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL;
        }

        @Override
        public final boolean isRepeated() {
            return this.proto.getLabel() == DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED;
        }

        @Override
        public final boolean isPacked() {
            block6: {
                block5: {
                    if (!this.isPackable()) {
                        return false;
                    }
                    FieldDescriptor fieldDescriptor = this;
                    if (fieldDescriptor.file.getSyntax() == FileDescriptor.Syntax.PROTO2) {
                        fieldDescriptor = this;
                        return fieldDescriptor.proto.getOptions().getPacked();
                    }
                    fieldDescriptor = this;
                    if (!fieldDescriptor.proto.getOptions().hasPacked()) break block5;
                    fieldDescriptor = this;
                    if (!fieldDescriptor.proto.getOptions().getPacked()) break block6;
                }
                return true;
            }
            return false;
        }

        public final boolean isPackable() {
            return this.isRepeated() && this.getLiteType().isPackable();
        }

        public final Object getDefaultValue() {
            FieldDescriptor fieldDescriptor = this;
            if (fieldDescriptor.type.getJavaType() == JavaType.MESSAGE) {
                throw new UnsupportedOperationException("FieldDescriptor.getDefaultValue() called on an embedded message field.");
            }
            return this.defaultValue;
        }

        public final boolean isExtension() {
            return this.proto.hasExtendee();
        }

        public final Descriptor getContainingType() {
            return this.containingType;
        }

        public final OneofDescriptor getContainingOneof() {
            return this.containingOneof;
        }

        public final OneofDescriptor getRealContainingOneof() {
            if (this.containingOneof != null && !this.containingOneof.isSynthetic()) {
                return this.containingOneof;
            }
            return null;
        }

        @Deprecated
        public final boolean hasOptionalKeyword() {
            block3: {
                block2: {
                    if (this.isProto3Optional) break block2;
                    if (this.file.getSyntax() != FileDescriptor.Syntax.PROTO2 || !this.isOptional()) break block3;
                    FieldDescriptor fieldDescriptor = this;
                    if (fieldDescriptor.containingOneof != null) break block3;
                }
                return true;
            }
            return false;
        }

        public final boolean hasPresence() {
            block5: {
                block4: {
                    if (this.isRepeated()) {
                        return false;
                    }
                    FieldDescriptor fieldDescriptor = this;
                    if (fieldDescriptor.type == Type.MESSAGE) break block4;
                    fieldDescriptor = this;
                    if (fieldDescriptor.type == Type.GROUP) break block4;
                    fieldDescriptor = this;
                    if (fieldDescriptor.containingOneof == null && this.file.getSyntax() != FileDescriptor.Syntax.PROTO2) break block5;
                }
                return true;
            }
            return false;
        }

        public final Descriptor getExtensionScope() {
            FieldDescriptor fieldDescriptor = this;
            if (!fieldDescriptor.proto.hasExtendee()) {
                throw new UnsupportedOperationException(String.format("This field is not an extension. (%s)", this.fullName));
            }
            return this.extensionScope;
        }

        public final Descriptor getMessageType() {
            FieldDescriptor fieldDescriptor = this;
            if (fieldDescriptor.type.getJavaType() != JavaType.MESSAGE) {
                throw new UnsupportedOperationException(String.format("This field is not of message type. (%s)", this.fullName));
            }
            return this.messageType;
        }

        public final EnumDescriptor getEnumType() {
            FieldDescriptor fieldDescriptor = this;
            if (fieldDescriptor.type.getJavaType() != JavaType.ENUM) {
                throw new UnsupportedOperationException(String.format("This field is not of enum type. (%s)", this.fullName));
            }
            return this.enumType;
        }

        public final boolean legacyEnumFieldTreatedAsClosed() {
            FieldDescriptor fieldDescriptor = this;
            if (fieldDescriptor.type == Type.ENUM) {
                fieldDescriptor = this;
                if (fieldDescriptor.file.getSyntax() == FileDescriptor.Syntax.PROTO2) {
                    return true;
                }
            }
            return false;
        }

        public final String toString() {
            FieldDescriptor fieldDescriptor = this;
            return fieldDescriptor.fullName;
        }

        /*
         * WARNING - void declaration
         */
        private FieldDescriptor(DescriptorProtos.FieldDescriptorProto proto, FileDescriptor file, Descriptor parent, int index, boolean isExtension) throws DescriptorValidationException {
            super((byte)0);
            void var2_2;
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.access$2300(file, parent, proto.getName());
            this.file = file;
            if (proto.hasType()) {
                this.type = Type.valueOf(proto.getType());
            }
            this.isProto3Optional = proto.getProto3Optional();
            FieldDescriptor fieldDescriptor = this;
            if (fieldDescriptor.proto.getNumber() <= 0) {
                throw new DescriptorValidationException((GenericDescriptor)this, "Field numbers must be positive integers.", 0);
            }
            if (isExtension) {
                if (!proto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee not set for extension field.", 0);
                }
                this.containingType = null;
                this.extensionScope = parent != null ? parent : null;
                if (proto.hasOneofIndex()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index set for extension field.", 0);
                }
                this.containingOneof = null;
            } else {
                if (proto.hasExtendee()) {
                    throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.extendee set for non-extension field.", 0);
                }
                this.containingType = parent;
                if (proto.hasOneofIndex()) {
                    void var1_1;
                    void var3_3;
                    if (proto.getOneofIndex() < 0 || proto.getOneofIndex() >= parent.toProto().getOneofDeclCount()) {
                        throw new DescriptorValidationException((GenericDescriptor)this, "FieldDescriptorProto.oneof_index is out of range for type " + ((GenericDescriptor)parent).getName(), 0);
                    }
                    this.containingOneof = var3_3.getOneofs().get(var1_1.getOneofIndex());
                    this.containingOneof.fieldCount++;
                } else {
                    this.containingOneof = null;
                }
                this.extensionScope = null;
            }
            ((FileDescriptor)var2_2).pool.addSymbol(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final MessageLite.Builder internalMergeFrom(MessageLite.Builder to, MessageLite from) {
            void var2_2;
            return ((Message.Builder)to).mergeFrom$1fb6aa50((Message)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ FieldDescriptor(DescriptorProtos.FieldDescriptorProto x0, FileDescriptor x1, Descriptor x2, int x3, boolean x4, byte by) throws DescriptorValidationException {
            this((DescriptorProtos.FieldDescriptorProto)var1_1, (FileDescriptor)var2_2, (Descriptor)var3_3, x3, x4);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        static /* synthetic */ void access$1400(FieldDescriptor x0) throws DescriptorValidationException {
            block58: {
                FieldDescriptor fieldDescriptor;
                block59: {
                    block60: {
                        FieldDescriptor fieldDescriptor2;
                        block57: {
                            block56: {
                                block53: {
                                    block55: {
                                        block51: {
                                            block54: {
                                                GenericDescriptor genericDescriptor;
                                                block52: {
                                                    fieldDescriptor = x0;
                                                    if (fieldDescriptor.proto.hasExtendee()) {
                                                        genericDescriptor = fieldDescriptor.file.pool.lookupSymbol$45e5caf3(fieldDescriptor.proto.getExtendee(), fieldDescriptor, DescriptorPool.SearchFilter.TYPES_ONLY$57ab58ea);
                                                        if (!(genericDescriptor instanceof Descriptor)) {
                                                            throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "\"" + fieldDescriptor.proto.getExtendee() + "\" is not a message type.", 0);
                                                        }
                                                        fieldDescriptor.containingType = (Descriptor)genericDescriptor;
                                                        FieldDescriptor fieldDescriptor3 = fieldDescriptor;
                                                        fieldDescriptor2 = fieldDescriptor3;
                                                        fieldDescriptor2 = fieldDescriptor;
                                                        if (!fieldDescriptor3.containingType.isExtensionNumber(fieldDescriptor2.proto.getNumber())) {
                                                            FieldDescriptor fieldDescriptor4 = fieldDescriptor;
                                                            fieldDescriptor2 = fieldDescriptor4;
                                                            fieldDescriptor2 = fieldDescriptor;
                                                            throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "\"" + ((GenericDescriptor)fieldDescriptor4.containingType).getFullName() + "\" does not declare " + fieldDescriptor2.proto.getNumber() + " as an extension number.", 0);
                                                        }
                                                    }
                                                    if (!fieldDescriptor.proto.hasTypeName()) break block51;
                                                    genericDescriptor = fieldDescriptor.file.pool.lookupSymbol$45e5caf3(fieldDescriptor.proto.getTypeName(), fieldDescriptor, DescriptorPool.SearchFilter.TYPES_ONLY$57ab58ea);
                                                    if (!fieldDescriptor.proto.hasType()) {
                                                        if (genericDescriptor instanceof Descriptor) {
                                                            fieldDescriptor.type = Type.MESSAGE;
                                                        } else if (genericDescriptor instanceof EnumDescriptor) {
                                                            fieldDescriptor.type = Type.ENUM;
                                                        } else {
                                                            throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "\"" + fieldDescriptor.proto.getTypeName() + "\" is not a type.", 0);
                                                        }
                                                    }
                                                    fieldDescriptor2 = fieldDescriptor;
                                                    if (fieldDescriptor2.type.getJavaType() != JavaType.MESSAGE) break block52;
                                                    if (!(genericDescriptor instanceof Descriptor)) {
                                                        throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "\"" + fieldDescriptor.proto.getTypeName() + "\" is not a message type.", 0);
                                                    }
                                                    fieldDescriptor.messageType = (Descriptor)genericDescriptor;
                                                    if (fieldDescriptor.proto.hasDefaultValue()) {
                                                        throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Messages can't have default values.", 0);
                                                    }
                                                    break block53;
                                                }
                                                fieldDescriptor2 = fieldDescriptor;
                                                if (fieldDescriptor2.type.getJavaType() != JavaType.ENUM) break block54;
                                                if (!(genericDescriptor instanceof EnumDescriptor)) {
                                                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "\"" + fieldDescriptor.proto.getTypeName() + "\" is not an enum type.", 0);
                                                }
                                                fieldDescriptor.enumType = (EnumDescriptor)genericDescriptor;
                                                break block53;
                                            }
                                            throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Field with primitive type has type_name.", 0);
                                        }
                                        fieldDescriptor2 = fieldDescriptor;
                                        if (fieldDescriptor2.type.getJavaType() == JavaType.MESSAGE) break block55;
                                        fieldDescriptor2 = fieldDescriptor;
                                        if (fieldDescriptor2.type.getJavaType() != JavaType.ENUM) break block53;
                                    }
                                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Field with message or enum type missing type_name.", 0);
                                }
                                if (fieldDescriptor.proto.getOptions().getPacked() && !fieldDescriptor.isPackable()) {
                                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "[packed = true] can only be specified for repeated primitive fields.", 0);
                                }
                                if (!fieldDescriptor.proto.hasDefaultValue()) break block56;
                                if (fieldDescriptor.isRepeated()) {
                                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Repeated fields cannot have default values.", 0);
                                }
                                try {
                                    fieldDescriptor2 = fieldDescriptor;
                                    switch (fieldDescriptor2.type) {
                                        case INT32: 
                                        case SINT32: 
                                        case SFIXED32: {
                                            fieldDescriptor.defaultValue = TextFormat.parseInt32(fieldDescriptor.proto.getDefaultValue());
                                            break;
                                        }
                                        case UINT32: 
                                        case FIXED32: {
                                            fieldDescriptor.defaultValue = TextFormat.parseUInt32(fieldDescriptor.proto.getDefaultValue());
                                            break;
                                        }
                                        case INT64: 
                                        case SINT64: 
                                        case SFIXED64: {
                                            fieldDescriptor.defaultValue = TextFormat.parseInt64(fieldDescriptor.proto.getDefaultValue());
                                            break;
                                        }
                                        case UINT64: 
                                        case FIXED64: {
                                            fieldDescriptor.defaultValue = TextFormat.parseUInt64(fieldDescriptor.proto.getDefaultValue());
                                            break;
                                        }
                                        case FLOAT: {
                                            if (fieldDescriptor.proto.getDefaultValue().equals("inf")) {
                                                fieldDescriptor.defaultValue = Float.valueOf(Float.POSITIVE_INFINITY);
                                                break;
                                            }
                                            if (fieldDescriptor.proto.getDefaultValue().equals("-inf")) {
                                                fieldDescriptor.defaultValue = Float.valueOf(Float.NEGATIVE_INFINITY);
                                                break;
                                            }
                                            if (fieldDescriptor.proto.getDefaultValue().equals("nan")) {
                                                fieldDescriptor.defaultValue = Float.valueOf(Float.NaN);
                                                break;
                                            }
                                            fieldDescriptor.defaultValue = Float.valueOf(fieldDescriptor.proto.getDefaultValue());
                                            break;
                                        }
                                        case DOUBLE: {
                                            if (fieldDescriptor.proto.getDefaultValue().equals("inf")) {
                                                fieldDescriptor.defaultValue = Double.POSITIVE_INFINITY;
                                                break;
                                            }
                                            if (fieldDescriptor.proto.getDefaultValue().equals("-inf")) {
                                                fieldDescriptor.defaultValue = Double.NEGATIVE_INFINITY;
                                                break;
                                            }
                                            if (fieldDescriptor.proto.getDefaultValue().equals("nan")) {
                                                fieldDescriptor.defaultValue = Double.NaN;
                                                break;
                                            }
                                            fieldDescriptor.defaultValue = Double.valueOf(fieldDescriptor.proto.getDefaultValue());
                                            break;
                                        }
                                        case BOOL: {
                                            fieldDescriptor.defaultValue = Boolean.valueOf(fieldDescriptor.proto.getDefaultValue());
                                            break;
                                        }
                                        case STRING: {
                                            fieldDescriptor.defaultValue = fieldDescriptor.proto.getDefaultValue();
                                            break;
                                        }
                                        case BYTES: {
                                            try {
                                                fieldDescriptor.defaultValue = TextFormat.unescapeBytes(fieldDescriptor.proto.getDefaultValue());
                                                break;
                                            }
                                            catch (TextFormat.InvalidEscapeSequenceException invalidEscapeSequenceException) {
                                                throw new DescriptorValidationException(fieldDescriptor, "Couldn't parse default value: " + invalidEscapeSequenceException.getMessage(), (Throwable)invalidEscapeSequenceException);
                                            }
                                        }
                                        case ENUM: {
                                            fieldDescriptor.defaultValue = fieldDescriptor.enumType.findValueByName(fieldDescriptor.proto.getDefaultValue());
                                            if (fieldDescriptor.defaultValue == null) {
                                                throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Unknown enum default value: \"" + fieldDescriptor.proto.getDefaultValue() + '\"', 0);
                                            }
                                            break block57;
                                        }
                                        case MESSAGE: 
                                        case GROUP: {
                                            throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Message type had default value.", 0);
                                        }
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    throw new DescriptorValidationException(fieldDescriptor, "Could not parse default value: \"" + fieldDescriptor.proto.getDefaultValue() + '\"', (Throwable)numberFormatException);
                                }
                            }
                            if (fieldDescriptor.isRepeated()) {
                                fieldDescriptor.defaultValue = Collections.emptyList();
                            } else {
                                fieldDescriptor2 = fieldDescriptor;
                                switch (fieldDescriptor2.type.getJavaType()) {
                                    case ENUM: {
                                        fieldDescriptor.defaultValue = fieldDescriptor.enumType.getValues().get(0);
                                        break;
                                    }
                                    case MESSAGE: {
                                        fieldDescriptor.defaultValue = null;
                                        break;
                                    }
                                    default: {
                                        fieldDescriptor2 = fieldDescriptor;
                                        fieldDescriptor2.defaultValue = fieldDescriptor2.type.getJavaType().defaultDefault;
                                    }
                                }
                            }
                        }
                        if (fieldDescriptor.containingType == null || !fieldDescriptor.containingType.getOptions().getMessageSetWireFormat()) break block58;
                        fieldDescriptor2 = fieldDescriptor;
                        if (!fieldDescriptor2.proto.hasExtendee()) break block59;
                        if (!fieldDescriptor.isOptional()) break block60;
                        fieldDescriptor2 = fieldDescriptor;
                        if (fieldDescriptor2.type == Type.MESSAGE) break block58;
                    }
                    throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "Extensions of MessageSets must be optional messages.", 0);
                }
                throw new DescriptorValidationException((GenericDescriptor)fieldDescriptor, "MessageSets cannot have fields, only extensions.", 0);
            }
        }

        static {
            if (Type.types.length != DescriptorProtos.FieldDescriptorProto.Type.values().length) {
                throw new RuntimeException("descriptor.proto has a new declared type but Descriptors.java wasn't updated.");
            }
        }

        public static final class JavaType
        extends Enum<JavaType> {
            public static final /* enum */ JavaType INT = new JavaType(0);
            public static final /* enum */ JavaType LONG = new JavaType(0L);
            public static final /* enum */ JavaType FLOAT = new JavaType(Float.valueOf(0.0f));
            public static final /* enum */ JavaType DOUBLE = new JavaType(0.0);
            public static final /* enum */ JavaType BOOLEAN = new JavaType(Boolean.FALSE);
            public static final /* enum */ JavaType STRING = new JavaType("");
            public static final /* enum */ JavaType BYTE_STRING = new JavaType(ByteString.EMPTY$6bb3303a);
            public static final /* enum */ JavaType ENUM = new JavaType(null);
            public static final /* enum */ JavaType MESSAGE = new JavaType(null);
            private final Object defaultDefault;
            private static final /* synthetic */ JavaType[] $VALUES;

            public static JavaType[] values() {
                return (JavaType[])$VALUES.clone();
            }

            /*
             * WARNING - void declaration
             */
            private JavaType(Object defaultDefault) {
                void var3_3;
                this.defaultDefault = var3_3;
            }

            static {
                $VALUES = new JavaType[]{INT, LONG, FLOAT, DOUBLE, BOOLEAN, STRING, BYTE_STRING, ENUM, MESSAGE};
            }
        }

        public static enum Type {
            DOUBLE(JavaType.DOUBLE),
            FLOAT(JavaType.FLOAT),
            INT64(JavaType.LONG),
            UINT64(JavaType.LONG),
            INT32(JavaType.INT),
            FIXED64(JavaType.LONG),
            FIXED32(JavaType.INT),
            BOOL(JavaType.BOOLEAN),
            STRING(JavaType.STRING),
            GROUP(JavaType.MESSAGE),
            MESSAGE(JavaType.MESSAGE),
            BYTES(JavaType.BYTE_STRING),
            UINT32(JavaType.INT),
            ENUM(JavaType.ENUM),
            SFIXED32(JavaType.INT),
            SFIXED64(JavaType.LONG),
            SINT32(JavaType.INT),
            SINT64(JavaType.LONG);

            private static final Type[] types;
            private final JavaType javaType;

            /*
             * WARNING - void declaration
             */
            private Type(JavaType javaType) {
                void var3_3;
                this.javaType = var3_3;
            }

            public final JavaType getJavaType() {
                return this.javaType;
            }

            static {
                types = Type.values();
            }
        }
    }

    public static final class Descriptor
    extends GenericDescriptor {
        private final int index;
        private DescriptorProtos.DescriptorProto proto;
        private final String fullName;
        private final FileDescriptor file;
        private final Descriptor containingType;
        private final Descriptor[] nestedTypes;
        private final EnumDescriptor[] enumTypes;
        private final FieldDescriptor[] fields;
        private final FieldDescriptor[] fieldsSortedByNumber;
        private final FieldDescriptor[] extensions;
        private final OneofDescriptor[] oneofs;
        private final int realOneofCount;
        private final int[] extensionRangeLowerBounds;
        private final int[] extensionRangeUpperBounds;

        public final DescriptorProtos.DescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final String getFullName() {
            return this.fullName;
        }

        @Override
        public final FileDescriptor getFile() {
            return this.file;
        }

        public final DescriptorProtos.MessageOptions getOptions() {
            return this.proto.getOptions();
        }

        public final List<FieldDescriptor> getFields() {
            return Collections.unmodifiableList(Arrays.asList(this.fields));
        }

        public final List<OneofDescriptor> getOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs));
        }

        public final List<OneofDescriptor> getRealOneofs() {
            return Collections.unmodifiableList(Arrays.asList(this.oneofs).subList(0, this.realOneofCount));
        }

        public final List<Descriptor> getNestedTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.nestedTypes));
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isExtensionNumber(int number) {
            void var2_2;
            void var1_1;
            int index = Arrays.binarySearch(this.extensionRangeLowerBounds, number);
            if (index < 0) {
                index = ~index - 1;
            }
            return index >= 0 && var1_1 < this.extensionRangeUpperBounds[var2_2];
        }

        public final boolean isExtendable() {
            return !this.proto.getExtensionRangeList().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        public final FieldDescriptor findFieldByName(String name) {
            GenericDescriptor result = this.file.pool.findSymbol(this.fullName + '.' + name);
            if (result instanceof FieldDescriptor) {
                void var1_1;
                return (FieldDescriptor)var1_1;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final FieldDescriptor findFieldByNumber(int number) {
            void var1_1;
            return (FieldDescriptor)Descriptors.access$2100$59b1b5f5(this.fieldsSortedByNumber, this.fieldsSortedByNumber.length, FieldDescriptor.NUMBER_GETTER$765ad3f, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        Descriptor(String fullname) throws DescriptorValidationException {
            super((byte)0);
            void var3_3;
            void var1_1;
            void var2_2;
            String name = fullname;
            String packageName = "";
            int pos = fullname.lastIndexOf(46);
            if (pos != -1) {
                name = fullname.substring(pos + 1);
                packageName = fullname.substring(0, pos);
            }
            this.index = 0;
            this.proto = DescriptorProtos.DescriptorProto.newBuilder().setName((String)var2_2).addExtensionRange(DescriptorProtos.DescriptorProto.ExtensionRange.newBuilder().setStart(1).setEnd(0x20000000).build()).build();
            this.fullName = var1_1;
            this.containingType = null;
            this.nestedTypes = EMPTY_DESCRIPTORS;
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.fields = EMPTY_FIELD_DESCRIPTORS;
            this.fieldsSortedByNumber = EMPTY_FIELD_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.oneofs = EMPTY_ONEOF_DESCRIPTORS;
            this.realOneofCount = 0;
            this.file = new FileDescriptor((String)var3_3, this);
            this.extensionRangeLowerBounds = new int[]{1};
            this.extensionRangeUpperBounds = new int[]{0x20000000};
        }

        /*
         * WARNING - void declaration
         */
        private Descriptor(DescriptorProtos.DescriptorProto proto, FileDescriptor file, Descriptor parent, int index) throws DescriptorValidationException {
            super((byte)0);
            void var2_2;
            void var3_4;
            int i;
            this.index = index;
            this.proto = proto;
            this.fullName = Descriptors.access$2300(file, parent, proto.getName());
            this.file = file;
            this.containingType = parent;
            this.oneofs = proto.getOneofDeclCount() > 0 ? new OneofDescriptor[proto.getOneofDeclCount()] : EMPTY_ONEOF_DESCRIPTORS;
            for (i = 0; i < proto.getOneofDeclCount(); ++i) {
                this.oneofs[i] = new OneofDescriptor(proto.getOneofDecl(i), file, this, i, 0);
            }
            this.nestedTypes = proto.getNestedTypeCount() > 0 ? new Descriptor[proto.getNestedTypeCount()] : EMPTY_DESCRIPTORS;
            for (i = 0; i < proto.getNestedTypeCount(); ++i) {
                this.nestedTypes[i] = new Descriptor(proto.getNestedType(i), file, this, i);
            }
            this.enumTypes = proto.getEnumTypeCount() > 0 ? new EnumDescriptor[proto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (i = 0; i < proto.getEnumTypeCount(); ++i) {
                this.enumTypes[i] = new EnumDescriptor(proto.getEnumType(i), file, this, i, 0);
            }
            this.fields = proto.getFieldCount() > 0 ? new FieldDescriptor[proto.getFieldCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (i = 0; i < proto.getFieldCount(); ++i) {
                this.fields[i] = new FieldDescriptor(proto.getField(i), file, this, i, false, 0);
            }
            this.fieldsSortedByNumber = proto.getFieldCount() > 0 ? (FieldDescriptor[])this.fields.clone() : EMPTY_FIELD_DESCRIPTORS;
            this.extensions = proto.getExtensionCount() > 0 ? new FieldDescriptor[proto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (i = 0; i < proto.getExtensionCount(); ++i) {
                this.extensions[i] = new FieldDescriptor(proto.getExtension(i), file, this, i, true, 0);
            }
            for (i = 0; i < proto.getOneofDeclCount(); ++i) {
                OneofDescriptor.access$2502(this.oneofs[i], new FieldDescriptor[this.oneofs[i].getFieldCount()]);
                OneofDescriptor.access$2602(this.oneofs[i], 0);
            }
            for (i = 0; i < proto.getFieldCount(); ++i) {
                OneofDescriptor oneofDescriptor = this.fields[i].getContainingOneof();
                if (oneofDescriptor == null) continue;
                ((OneofDescriptor)oneofDescriptor).fields[((OneofDescriptor)oneofDescriptor).fieldCount++] = this.fields[i];
            }
            int syntheticOneofCount = 0;
            OneofDescriptor[] oneofDescriptor = this.oneofs;
            int n = this.oneofs.length;
            for (int j = 0; j < n; ++j) {
                OneofDescriptor oneofDescriptor2 = oneofDescriptor[j];
                if (oneofDescriptor2.isSynthetic()) {
                    ++syntheticOneofCount;
                    continue;
                }
                if (syntheticOneofCount <= 0) continue;
                throw new DescriptorValidationException((GenericDescriptor)this, "Synthetic oneofs must come last.", 0);
            }
            this.realOneofCount = this.oneofs.length - var3_4;
            ((FileDescriptor)var2_2).pool.addSymbol(this);
            if (proto.getExtensionRangeCount() > 0) {
                void var1_1;
                this.extensionRangeLowerBounds = new int[proto.getExtensionRangeCount()];
                this.extensionRangeUpperBounds = new int[proto.getExtensionRangeCount()];
                int i2 = 0;
                for (DescriptorProtos.DescriptorProto.ExtensionRange range : var1_1.getExtensionRangeList()) {
                    this.extensionRangeLowerBounds[i2] = range.getStart();
                    this.extensionRangeUpperBounds[i2] = range.getEnd();
                    ++i2;
                }
                Arrays.sort(this.extensionRangeLowerBounds);
                Arrays.sort(this.extensionRangeUpperBounds);
                return;
            }
            this.extensionRangeLowerBounds = EMPTY_INT_ARRAY;
            this.extensionRangeUpperBounds = EMPTY_INT_ARRAY;
        }

        private void crossLink() throws DescriptorValidationException {
            GenericDescriptor genericDescriptor;
            int n;
            Object object = this.nestedTypes;
            int n2 = this.nestedTypes.length;
            for (n = 0; n < n2; ++n) {
                genericDescriptor = object[n];
                ((Descriptor)genericDescriptor).crossLink();
            }
            object = this.fields;
            n2 = this.fields.length;
            for (n = 0; n < n2; ++n) {
                genericDescriptor = object[n];
                FieldDescriptor.access$1400((FieldDescriptor)genericDescriptor);
            }
            Arrays.sort(this.fieldsSortedByNumber);
            object = this;
            n2 = 0;
            while (n2 + 1 < object.fieldsSortedByNumber.length) {
                FieldDescriptor fieldDescriptor = object.fieldsSortedByNumber[n2];
                genericDescriptor = object.fieldsSortedByNumber[n2 + 1];
                if (fieldDescriptor.getNumber() == ((FieldDescriptor)genericDescriptor).getNumber()) {
                    object = ((FieldDescriptor)genericDescriptor).getContainingType();
                    throw new DescriptorValidationException(genericDescriptor, "Field number " + ((FieldDescriptor)genericDescriptor).getNumber() + " has already been used in \"" + object.fullName + "\" by field \"" + ((GenericDescriptor)fieldDescriptor).getName() + "\".", 0);
                }
                ++n2;
            }
            object = this.extensions;
            n2 = this.extensions.length;
            for (n = 0; n < n2; ++n) {
                genericDescriptor = object[n];
                FieldDescriptor.access$1400((FieldDescriptor)genericDescriptor);
            }
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ Descriptor(DescriptorProtos.DescriptorProto x0, FileDescriptor x1, Descriptor x2, int x3, byte by) throws DescriptorValidationException {
            this((DescriptorProtos.DescriptorProto)var1_1, (FileDescriptor)var2_2, null, x3);
            void var2_2;
            void var1_1;
        }
    }

    public static final class FileDescriptor
    extends GenericDescriptor {
        private DescriptorProtos.FileDescriptorProto proto;
        private final Descriptor[] messageTypes;
        private final EnumDescriptor[] enumTypes;
        private final ServiceDescriptor[] services;
        private final FieldDescriptor[] extensions;
        private final FileDescriptor[] dependencies;
        private final FileDescriptor[] publicDependencies;
        private final DescriptorPool pool;

        public final DescriptorProtos.FileDescriptorProto toProto() {
            return this.proto;
        }

        @Override
        public final String getName() {
            return this.proto.getName();
        }

        @Override
        public final FileDescriptor getFile() {
            return this;
        }

        @Override
        public final String getFullName() {
            return this.proto.getName();
        }

        public final String getPackage() {
            return this.proto.getPackage();
        }

        public final DescriptorProtos.FileOptions getOptions() {
            return this.proto.getOptions();
        }

        public final List<Descriptor> getMessageTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.messageTypes));
        }

        public final List<EnumDescriptor> getEnumTypes() {
            return Collections.unmodifiableList(Arrays.asList(this.enumTypes));
        }

        public final List<FileDescriptor> getPublicDependencies() {
            return Collections.unmodifiableList(Arrays.asList(this.publicDependencies));
        }

        @Deprecated
        public final Syntax getSyntax() {
            if (Syntax.PROTO3.name.equals(this.proto.getSyntax())) {
                return Syntax.PROTO3;
            }
            if (Syntax.EDITIONS.name.equals(this.proto.getSyntax())) {
                return Syntax.EDITIONS;
            }
            return Syntax.PROTO2;
        }

        /*
         * WARNING - void declaration
         */
        public static FileDescriptor internalBuildGeneratedFileFrom(String[] descriptorDataParts, FileDescriptor[] dependencies) {
            DescriptorProtos.FileDescriptorProto proto;
            StringBuilder stringBuilder;
            byte[] byArray;
            String[] stringArray = descriptorDataParts;
            if (descriptorDataParts.length == 1) {
                byArray = stringArray[0].getBytes(Internal.ISO_8859_1);
            } else {
                stringBuilder = new StringBuilder();
                for (String object : stringArray) {
                    stringBuilder.append(object);
                }
                byArray = stringBuilder.toString().getBytes(Internal.ISO_8859_1);
            }
            DescriptorProtos.FileDescriptorProto descriptorBytes = (DescriptorProtos.FileDescriptorProto)byArray;
            try {
                proto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])descriptorBytes);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Failed to parse protocol buffer descriptor for generated code.", e);
            }
            try {
                int n;
                FileDescriptor fileDescriptor;
                boolean bl = true;
                stringBuilder = e;
                DescriptorProtos.FileDescriptorProto fileDescriptorProto = proto;
                Object object2 = new DescriptorPool((FileDescriptor[])stringBuilder, true);
                FileDescriptor fileDescriptor2 = fileDescriptor = new FileDescriptor(fileDescriptorProto, (FileDescriptor[])stringBuilder, (DescriptorPool)object2, true);
                GenericDescriptor[] e = fileDescriptor.messageTypes;
                int n2 = fileDescriptor.messageTypes.length;
                for (n = 0; n < n2; ++n) {
                    object2 = e[n];
                    ((Descriptor)object2).crossLink();
                }
                e = fileDescriptor2.services;
                n2 = fileDescriptor2.services.length;
                for (n = 0; n < n2; ++n) {
                    object2 = e[n];
                    ServiceDescriptor.access$1300((ServiceDescriptor)object2);
                }
                e = fileDescriptor2.extensions;
                n2 = fileDescriptor2.extensions.length;
                for (n = 0; n < n2; ++n) {
                    object2 = e[n];
                    FieldDescriptor.access$1400((FieldDescriptor)object2);
                }
                return fileDescriptor;
            }
            catch (DescriptorValidationException e) {
                void var1_3;
                DescriptorProtos.FileDescriptorProto fileDescriptorProto;
                throw new IllegalArgumentException("Invalid embedded descriptor for \"" + fileDescriptorProto.getName() + "\".", (Throwable)var1_3);
            }
        }

        /*
         * WARNING - void declaration
         */
        private FileDescriptor(DescriptorProtos.FileDescriptorProto proto, FileDescriptor[] dependencies, DescriptorPool pool, boolean allowUnknownDependencies) throws DescriptorValidationException {
            super((byte)0);
            void var3_3;
            void var2_2;
            int i;
            FileDescriptor fileDescriptor;
            this.pool = pool;
            this.proto = proto;
            this.dependencies = (FileDescriptor[])dependencies.clone();
            HashMap<String, FileDescriptor> nameToFileMap = new HashMap<String, FileDescriptor>();
            int n = dependencies.length;
            for (int j = 0; j < n; ++j) {
                FileDescriptor file;
                fileDescriptor = file = dependencies[j];
                nameToFileMap.put(fileDescriptor.proto.getName(), file);
            }
            ArrayList<FileDescriptor> publicDependencies = new ArrayList<FileDescriptor>();
            for (i = 0; i < proto.getPublicDependencyCount(); ++i) {
                int index = proto.getPublicDependency(i);
                if (index < 0 || index >= proto.getDependencyCount()) {
                    throw new DescriptorValidationException(this, "Invalid public dependency index.", 0);
                }
                String name = proto.getDependency(index);
                FileDescriptor file = (FileDescriptor)nameToFileMap.get(name);
                if (file == null) {
                    if (allowUnknownDependencies) continue;
                    throw new DescriptorValidationException(this, "Invalid public dependency: " + name, 0);
                }
                publicDependencies.add(file);
            }
            this.publicDependencies = new FileDescriptor[publicDependencies.size()];
            var2_2.toArray(this.publicDependencies);
            fileDescriptor = this;
            var3_3.addPackage(fileDescriptor.proto.getPackage(), this);
            this.messageTypes = proto.getMessageTypeCount() > 0 ? new Descriptor[proto.getMessageTypeCount()] : EMPTY_DESCRIPTORS;
            for (i = 0; i < proto.getMessageTypeCount(); ++i) {
                this.messageTypes[i] = new Descriptor(proto.getMessageType(i), this, null, i, 0);
            }
            this.enumTypes = proto.getEnumTypeCount() > 0 ? new EnumDescriptor[proto.getEnumTypeCount()] : EMPTY_ENUM_DESCRIPTORS;
            for (i = 0; i < proto.getEnumTypeCount(); ++i) {
                this.enumTypes[i] = new EnumDescriptor(proto.getEnumType(i), this, null, i, 0);
            }
            this.services = proto.getServiceCount() > 0 ? new ServiceDescriptor[proto.getServiceCount()] : EMPTY_SERVICE_DESCRIPTORS;
            for (i = 0; i < proto.getServiceCount(); ++i) {
                this.services[i] = new ServiceDescriptor(proto.getService(i), this, i, 0);
            }
            this.extensions = proto.getExtensionCount() > 0 ? new FieldDescriptor[proto.getExtensionCount()] : EMPTY_FIELD_DESCRIPTORS;
            for (i = 0; i < proto.getExtensionCount(); ++i) {
                this.extensions[i] = new FieldDescriptor(proto.getExtension(i), this, null, i, true, 0);
            }
        }

        /*
         * WARNING - void declaration
         */
        FileDescriptor(String packageName, Descriptor message) throws DescriptorValidationException {
            super((byte)0);
            void var2_2;
            void var1_1;
            this.pool = new DescriptorPool(new FileDescriptor[0], true);
            this.proto = DescriptorProtos.FileDescriptorProto.newBuilder().setName(((GenericDescriptor)message).getFullName() + ".placeholder.proto").setPackage(packageName).addMessageType(message.toProto()).build();
            this.dependencies = new FileDescriptor[0];
            this.publicDependencies = new FileDescriptor[0];
            this.messageTypes = new Descriptor[]{message};
            this.enumTypes = EMPTY_ENUM_DESCRIPTORS;
            this.services = EMPTY_SERVICE_DESCRIPTORS;
            this.extensions = EMPTY_FIELD_DESCRIPTORS;
            this.pool.addPackage((String)var1_1, this);
            this.pool.addSymbol((GenericDescriptor)var2_2);
        }

        @Deprecated
        public static final class Syntax
        extends Enum<Syntax> {
            private static /* enum */ Syntax UNKNOWN = new Syntax("unknown");
            public static final /* enum */ Syntax PROTO2 = new Syntax("proto2");
            public static final /* enum */ Syntax PROTO3 = new Syntax("proto3");
            public static final /* enum */ Syntax EDITIONS = new Syntax("editions");
            private final String name;
            private static final /* synthetic */ Syntax[] $VALUES;

            public static Syntax[] values() {
                return (Syntax[])$VALUES.clone();
            }

            /*
             * WARNING - void declaration
             */
            private Syntax(String name) {
                void var3_3;
                this.name = var3_3;
            }

            static {
                $VALUES = new Syntax[]{UNKNOWN, PROTO2, PROTO3, EDITIONS};
            }
        }
    }
}

