/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.Position;
import com.github.javaparser.Provider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class UnicodeEscapeProcessingProvider
implements Provider {
    private char[] _data;
    private int _len = 0;
    private int _pos = 0;
    private boolean _backslashSeen;
    private final LineCounter _inputLine = new LineCounter();
    private final LineCounter _outputLine = new LineCounter();
    private final PositionMappingBuilder _mappingBuilder = new PositionMappingBuilder(this._outputLine, this._inputLine);
    private Provider _input;

    /*
     * WARNING - void declaration
     */
    public UnicodeEscapeProcessingProvider(Provider input) {
        this(2048, (Provider)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private UnicodeEscapeProcessingProvider(int bufferSize, Provider input) {
        void var2_2;
        this._input = var2_2;
        this._data = new char[2048];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int read(char[] buffer, int offset, int len) throws IOException {
        void var2_2;
        int pos = offset;
        int stop = offset + len;
        while (pos < stop) {
            int n;
            UnicodeEscapeProcessingProvider unicodeEscapeProcessingProvider = this;
            int n2 = unicodeEscapeProcessingProvider.nextInputChar();
            block0 : switch (n2) {
                case -1: {
                    n = -1;
                    break;
                }
                case 92: {
                    if (!unicodeEscapeProcessingProvider._backslashSeen) {
                        v1._backslashSeen = true;
                        n2 = unicodeEscapeProcessingProvider.nextInputChar();
                        switch (n2) {
                            case -1: {
                                n = 92;
                                break block0;
                            }
                            case 117: {
                                int n3;
                                n2 = 1;
                                block13: while (true) {
                                    n3 = unicodeEscapeProcessingProvider.nextInputChar();
                                    switch (n3) {
                                        case -1: {
                                            unicodeEscapeProcessingProvider.pushBackUs(n2);
                                            n = 92;
                                            break block0;
                                        }
                                        case 117: {
                                            ++n2;
                                            continue block13;
                                        }
                                    }
                                    break;
                                }
                                int n4 = UnicodeEscapeProcessingProvider.digit(n3);
                                if (n4 < 0) {
                                    unicodeEscapeProcessingProvider.pushBack(n3);
                                    unicodeEscapeProcessingProvider.pushBackUs(n2);
                                    n = 92;
                                    break block0;
                                }
                                int n5 = unicodeEscapeProcessingProvider.nextInputChar();
                                int n6 = UnicodeEscapeProcessingProvider.digit(n5);
                                if (n6 < 0) {
                                    unicodeEscapeProcessingProvider.pushBack(n5);
                                    unicodeEscapeProcessingProvider.pushBack(n3);
                                    unicodeEscapeProcessingProvider.pushBackUs(n2);
                                    n = 92;
                                    break block0;
                                }
                                int n7 = unicodeEscapeProcessingProvider.nextInputChar();
                                int n8 = UnicodeEscapeProcessingProvider.digit(n7);
                                if (n8 < 0) {
                                    unicodeEscapeProcessingProvider.pushBack(n7);
                                    unicodeEscapeProcessingProvider.pushBack(n5);
                                    unicodeEscapeProcessingProvider.pushBack(n3);
                                    unicodeEscapeProcessingProvider.pushBackUs(n2);
                                    n = 92;
                                    break block0;
                                }
                                int n9 = unicodeEscapeProcessingProvider.nextInputChar();
                                int n10 = UnicodeEscapeProcessingProvider.digit(n9);
                                if (n10 < 0) {
                                    unicodeEscapeProcessingProvider.pushBack(n9);
                                    unicodeEscapeProcessingProvider.pushBack(n7);
                                    unicodeEscapeProcessingProvider.pushBack(n5);
                                    unicodeEscapeProcessingProvider.pushBack(n3);
                                    unicodeEscapeProcessingProvider.pushBackUs(n2);
                                    n = 92;
                                    break block0;
                                }
                                n2 = n4 << 12 | n6 << 8 | n8 << 4 | n10;
                                v2._backslashSeen = false;
                                n = n2;
                                break block0;
                            }
                        }
                        unicodeEscapeProcessingProvider.pushBack(n2);
                        n = 92;
                        break;
                    }
                }
                default: {
                    v3._backslashSeen = false;
                    n = n2;
                }
            }
            int ch = this._outputLine.process(n);
            if (ch < 0) {
                if (pos != offset) break;
                return -1;
            }
            this._mappingBuilder.update();
            buffer[pos++] = (char)ch;
        }
        return pos - var2_2;
    }

    @Override
    public final void close() throws IOException {
        this._input.close();
    }

    private void pushBackUs(int cnt) {
        for (int n = 0; n < cnt; ++n) {
            this.pushBack(117);
        }
    }

    private static int digit(int ch) {
        if (ch >= 48 && ch <= 57) {
            return ch - 48;
        }
        if (ch >= 65 && ch <= 70) {
            return ch + 10 - 65;
        }
        if (ch >= 97 && ch <= 102) {
            int n;
            return n + 10 - 97;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    private int nextInputChar() throws IOException {
        void var1_1;
        int result = this.nextBufferedChar();
        return this._inputLine.process((int)var1_1);
    }

    private int nextBufferedChar() throws IOException {
        while (this.isBufferEmpty()) {
            int n = this.fillBuffer();
            if (n >= 0) continue;
            return -1;
        }
        return this._data[this._pos++];
    }

    private boolean isBufferEmpty() {
        return this._pos >= this._len;
    }

    /*
     * WARNING - void declaration
     */
    private int fillBuffer() throws IOException {
        void var1_1;
        this._pos = 0;
        int direct = this._input.read(this._data, 0, this._data.length);
        if (direct != 0) {
            this._len = direct;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void pushBack(int ch) {
        void var1_1;
        if (ch < 0) {
            return;
        }
        if (this.isBufferEmpty()) {
            this._pos = this._data.length;
            this._len = this._data.length;
        } else if (this._pos == 0) {
            if (this._len == this._data.length) {
                char[] newData = new char[this._data.length + 1024];
                this._len = newData.length;
                this._pos = newData.length - this._data.length;
                System.arraycopy(this._data, 0, newData, this._pos, this._data.length);
                this._data = newData;
            } else {
                void var2_3;
                int cnt = this._len - this._pos;
                this._pos = this._data.length - this._len;
                this._len = this._data.length;
                System.arraycopy(this._data, 0, this._data, this._pos, (int)var2_3);
            }
        }
        this._data[--this._pos] = (char)var1_1;
    }

    public final PositionMapping getPositionMapping() {
        return this._mappingBuilder.getMapping();
    }

    public static final class LineCounter {
        private boolean _crSeen;
        private int _line = 1;
        private int _column = 1;

        public final int getLine() {
            return this._line;
        }

        public final int getColumn() {
            return this._column;
        }

        /*
         * WARNING - void declaration
         */
        public final int process(int ch) {
            void var1_1;
            switch (ch) {
                case -1: {
                    break;
                }
                case 13: {
                    this.incLine();
                    this._crSeen = true;
                    break;
                }
                case 10: {
                    if (this._crSeen) {
                        this._crSeen = false;
                        break;
                    }
                    this.incLine();
                    break;
                }
                default: {
                    this._crSeen = false;
                    ++this._column;
                }
            }
            return (int)var1_1;
        }

        private void incLine() {
            ++this._line;
            this._column = 1;
        }
    }

    private static final class PositionMappingBuilder {
        private LineCounter _left;
        private LineCounter _right;
        private final PositionMapping _mapping = new PositionMapping();
        private int _lineDelta = 0;
        private int _columnDelta = 0;

        /*
         * WARNING - void declaration
         */
        public PositionMappingBuilder(LineCounter left, LineCounter right) {
            void var2_2;
            void var1_1;
            this._left = var1_1;
            this._right = var2_2;
            this.update();
        }

        public final PositionMapping getMapping() {
            return this._mapping;
        }

        /*
         * WARNING - void declaration
         */
        public final void update() {
            int lineDelta = this._right.getLine() - this._left.getLine();
            int columnDelta = this._right.getColumn() - this._left.getColumn();
            if (lineDelta != this._lineDelta || columnDelta != this._columnDelta) {
                void var2_2;
                void var1_1;
                this._mapping.add(this._left.getLine(), this._left.getColumn(), lineDelta, columnDelta);
                this._lineDelta = var1_1;
                this._columnDelta = var2_2;
            }
        }
    }

    public static final class PositionMapping {
        private final List<DeltaInfo> _deltas = new ArrayList<DeltaInfo>();

        public final boolean isEmpty() {
            return this._deltas.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        final void add(int line, int column, int lineDelta, int columnDelta) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._deltas.add(new DeltaInfo((int)var1_1, (int)var2_2, (int)var3_3, columnDelta));
        }

        /*
         * WARNING - void declaration
         */
        private PositionUpdate lookup(Position position) {
            void var1_2;
            int result = Collections.binarySearch(this._deltas, position);
            if (result >= 0) {
                return this._deltas.get(result);
            }
            int insertIndex = -result - 1;
            if (insertIndex == 0) {
                return PositionUpdate.NONE$3874b1ec;
            }
            return this._deltas.get((int)(var1_2 - true));
        }

        /*
         * WARNING - void declaration
         */
        public final Position transform(Position pos) {
            void var1_1;
            return this.lookup(pos).transform((Position)var1_1);
        }

        private static final class DeltaInfo
        extends Position
        implements PositionUpdate {
            private final int _lineDelta;
            private final int _columnDelta;

            /*
             * WARNING - void declaration
             */
            public DeltaInfo(int line, int column, int lineDelta, int columnDelta) {
                super((int)var1_1, (int)var2_2);
                void var3_3;
                void var2_2;
                void var1_1;
                this._lineDelta = var3_3;
                this._columnDelta = columnDelta;
            }

            @Override
            public final int transformLine(int sourceLine) {
                return sourceLine + this._lineDelta;
            }

            @Override
            public final int transformColumn(int sourceColumn) {
                return sourceColumn + this._columnDelta;
            }

            @Override
            public final String toString() {
                return "(" + this.line + ", " + this.column + ": " + this._lineDelta + ", " + this._columnDelta + ")";
            }
        }

        public static interface PositionUpdate {
            public static final 1 NONE$3874b1ec = new PositionUpdate(){

                @Override
                public final int transformLine(int line) {
                    return line;
                }

                @Override
                public final int transformColumn(int column) {
                    return column;
                }

                @Override
                public final Position transform(Position pos) {
                    return pos;
                }
            };

            public int transformLine(int var1);

            public int transformColumn(int var1);

            /*
             * WARNING - void declaration
             */
            default public Position transform(Position pos) {
                void var1_2;
                void var2_3;
                int line = pos.line;
                int column = pos.column;
                int transformedLine = this.transformLine(line);
                int transformedColumn = this.transformColumn(column);
                return new Position((int)var2_3, (int)var1_2);
            }
        }
    }
}

