/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.printer;

import com.github.javaparser.Position;
import com.github.javaparser.printer.configuration.ConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultConfigurationOption;
import com.github.javaparser.printer.configuration.DefaultPrinterConfiguration;
import com.github.javaparser.printer.configuration.Indentation;
import com.github.javaparser.printer.configuration.PrinterConfiguration;
import java.util.Deque;
import java.util.LinkedList;

public final class SourcePrinter {
    private String endOfLineCharacter;
    private Indentation indentation;
    private final Deque<String> indents = new LinkedList<String>();
    private final Deque<String> reindentedIndents = new LinkedList<String>();
    private String lastPrintedIndent = "";
    private final StringBuilder buf = new StringBuilder();
    private Position cursor = new Position(1, 0);
    private boolean indented = false;

    SourcePrinter() {
        this(new DefaultPrinterConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    SourcePrinter(PrinterConfiguration configuration) {
        this((Indentation)((ConfigurationOption)configuration.get$2fe6467a(new DefaultConfigurationOption(DefaultPrinterConfiguration.ConfigOption.INDENTATION)).get()).asValue(), ((ConfigurationOption)var1_1.get$2fe6467a(new DefaultConfigurationOption(DefaultPrinterConfiguration.ConfigOption.END_OF_LINE_CHARACTER)).get()).asString());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private SourcePrinter(Indentation indentation, String eol) {
        void var2_2;
        void var1_1;
        this.indentation = var1_1;
        this.endOfLineCharacter = var2_2;
        this.indents.push("");
    }

    /*
     * WARNING - void declaration
     */
    public final SourcePrinter indent() {
        String currentIndent = this.indents.peek();
        switch (this.indentation.getType()) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                this.indents.push(currentIndent + this.indentation.getIndent());
                break;
            }
            case TABS: {
                void var1_1;
                this.indents.push(this.indentation.getIndent() + (String)var1_1);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SourcePrinter indentWithAlignTo(int column) {
        void var1_1;
        this.indents.push(this.calculateIndentWithAlignTo((int)var1_1));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    private String calculateIndentWithAlignTo(int column) {
        void var2_4;
        if (column < this.lastPrintedIndent.length()) {
            throw new IllegalStateException("Attempt to indent less than the previous indent.");
        }
        StringBuilder newIndent = new StringBuilder(this.lastPrintedIndent);
        switch (this.indentation.getType()) {
            case SPACES: 
            case TABS_WITH_SPACE_ALIGN: {
                while (newIndent.length() < column) {
                    newIndent.append(Indentation.IndentType.SPACES.getCar());
                }
                break;
            }
            case TABS: {
                void var3_5;
                void var1_3;
                Indentation.IndentType currentIndentType = this.indentation.getType();
                int logicalIndentLength = newIndent.length();
                while (logicalIndentLength + currentIndentType.getWidth() <= column) {
                    newIndent.insert(0, currentIndentType.getCar());
                    logicalIndentLength += currentIndentType.getWidth();
                }
                while (logicalIndentLength < column) {
                    newIndent.append(Indentation.IndentType.SPACES.getCar());
                    ++logicalIndentLength;
                }
                StringBuilder fullTab = new StringBuilder();
                for (int i = 0; i < currentIndentType.getWidth(); ++i) {
                    fullTab.append(Indentation.IndentType.SPACES.getCar());
                }
                String fullTabString = fullTab.toString();
                if (newIndent.length() < currentIndentType.getWidth()) break;
                StringBuilder stringBuilder = newIndent;
                if (!stringBuilder.substring(stringBuilder.length() - currentIndentType.getWidth()).equals(fullTabString)) break;
                int i = newIndent.indexOf(fullTabString);
                void v1 = var1_3;
                newIndent.replace((int)v1, (int)(v1 + currentIndentType.getWidth()), var3_5.getCar().toString());
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled indent type");
            }
        }
        return var2_4.toString();
    }

    public final SourcePrinter unindent() {
        if (this.indents.isEmpty()) {
            throw new IllegalStateException("Indent/unindent calls are not well-balanced.");
        }
        this.indents.pop();
        return this;
    }

    private void append(String arg2) {
        Position position;
        this.buf.append(arg2);
        int n = this.cursor.column + ((String)((Object)position)).length();
        position = this.cursor;
        this.cursor = new Position(position.line, n);
    }

    /*
     * WARNING - void declaration
     */
    public final SourcePrinter print(String arg2) {
        void var1_1;
        if (!this.indented) {
            this.lastPrintedIndent = this.indents.peek();
            SourcePrinter sourcePrinter = this;
            sourcePrinter.append(sourcePrinter.lastPrintedIndent);
            this.indented = true;
        }
        this.append((String)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public final SourcePrinter println(String arg2) {
        void var1_1;
        this.print((String)var1_1);
        this.println();
        return this;
    }

    public final SourcePrinter println() {
        this.buf.append(this.endOfLineCharacter);
        this.cursor = new Position(this.cursor.line + 1, 0);
        this.indented = false;
        return this;
    }

    public final Position getCursor() {
        return this.cursor;
    }

    public final String toString() {
        return this.buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void reindentWithAlignToCursor() {
        void var1_1;
        SourcePrinter sourcePrinter = this;
        String newIndent = sourcePrinter.calculateIndentWithAlignTo(sourcePrinter.cursor.column);
        this.reindentedIndents.push(this.indents.pop());
        this.indents.push((String)var1_1);
    }

    public final void reindentToPreviousLevel() {
        if (this.reindentedIndents.isEmpty()) {
            throw new IllegalStateException("Reindent calls are not well-balanced.");
        }
        this.indents.pop();
        this.indents.push(this.reindentedIndents.pop());
    }

    public final void duplicateIndent() {
        this.indents.push(this.indents.peek());
    }
}

