/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.Arrays;

public abstract class CharMatcher
implements Predicate<Character> {
    public static CharMatcher none() {
        return None.INSTANCE$22b9cf5;
    }

    public static CharMatcher whitespace() {
        return Whitespace.INSTANCE$22b9cf5;
    }

    public static CharMatcher breakingWhitespace() {
        return BreakingWhitespace.INSTANCE$22b9cf5;
    }

    public static Is is$8d21c63(char match) {
        char c;
        return new Is(c);
    }

    public static IsNot isNot$8d21c63(char match) {
        char c;
        return new IsNot(c);
    }

    public static CharMatcher anyOf(CharSequence sequence2) {
        CharSequence charSequence;
        switch (sequence2.length()) {
            case 0: {
                return None.INSTANCE$22b9cf5;
            }
            case 1: {
                return CharMatcher.is$8d21c63(sequence2.charAt(0));
            }
            case 2: {
                char c = sequence2.charAt(1);
                char sequence2 = sequence2.charAt(0);
                return new IsEither(sequence2, c);
            }
        }
        return new AnyOf(charSequence);
    }

    protected CharMatcher() {
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new Negated(this);
    }

    /*
     * WARNING - void declaration
     */
    public CharMatcher or(CharMatcher other) {
        void var1_1;
        return new Or(this, (CharMatcher)var1_1);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        for (int i = sequence.length() - 1; i >= 0; --i) {
            if (this.matches(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchesNoneOf(CharSequence sequence) {
        void var1_1;
        return this.indexIn((CharSequence)var1_1) == -1;
    }

    /*
     * WARNING - void declaration
     */
    public int indexIn(CharSequence sequence) {
        void var1_1;
        return this.indexIn((CharSequence)var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    public int indexIn(CharSequence sequence, int start) {
        void i;
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        while (i < length) {
            if (this.matches(sequence.charAt((int)i))) {
                return (int)i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public int countIn(CharSequence sequence) {
        void var2_2;
        int count = 0;
        for (int i = 0; i < sequence.length(); ++i) {
            if (!this.matches(sequence.charAt(i))) continue;
            ++count;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public String removeFrom(CharSequence sequence) {
        void var3_3;
        void var2_2;
        void var1_1;
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int spread = 1;
        while (++pos != chars.length) {
            if (!this.matches(chars[pos])) {
                chars[pos - spread] = chars[pos];
                continue;
            }
            ++spread;
        }
        return new String((char[])var1_1, 0, (int)(var2_2 - var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public final String retainFrom(CharSequence sequence) {
        void var1_1;
        return this.negate().removeFrom((CharSequence)var1_1);
    }

    public String trimLeadingFrom(CharSequence sequence) {
        int len = sequence.length();
        for (int first = 0; first < len; ++first) {
            if (this.matches(sequence.charAt(first))) continue;
            return sequence.subSequence(first, len).toString();
        }
        return "";
    }

    public String trimTrailingFrom(CharSequence sequence) {
        int n = sequence.length();
        for (int last = n - 1; last >= 0; --last) {
            if (this.matches(sequence.charAt(last))) continue;
            return sequence.subSequence(0, last + 1).toString();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public final boolean apply(Character character) {
        void var1_1;
        return this.matches(var1_1.charValue());
    }

    public String toString() {
        return super.toString();
    }

    static /* synthetic */ String access$100(char x0) {
        char c = x0;
        String string = "0123456789ABCDEF";
        char[] cArray = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i = 0; i < 4; ++i) {
            cArray[5 - i] = string.charAt(c & 0xF);
            c = (char)(c >> 4);
        }
        return String.copyValueOf(cArray);
    }

    private static final class Any
    extends NamedFastMatcher {
        static final Any INSTANCE$22b9cf5 = new Any();

        private Any() {
            super("CharMatcher.any()");
        }

        @Override
        public final boolean matches(char c) {
            return true;
        }

        @Override
        public final int indexIn(CharSequence sequence) {
            if (sequence.length() == 0) {
                return -1;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexIn(CharSequence sequence, int start) {
            void var2_3;
            void var1_2;
            int length = sequence.length();
            Preconditions.checkPositionIndex(start, length);
            if (start == var1_2) {
                return -1;
            }
            return (int)var2_3;
        }

        @Override
        public final boolean matchesAllOf(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return true;
        }

        @Override
        public final boolean matchesNoneOf(CharSequence sequence) {
            return sequence.length() == 0;
        }

        @Override
        public final String removeFrom(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return "";
        }

        @Override
        public final int countIn(CharSequence sequence) {
            return sequence.length();
        }

        @Override
        public final CharMatcher or(CharMatcher other) {
            Preconditions.checkNotNull(other);
            return this;
        }

        @Override
        public final CharMatcher negate() {
            return None.INSTANCE$22b9cf5;
        }
    }

    private static final class None
    extends NamedFastMatcher {
        static final None INSTANCE$22b9cf5 = new None();

        private None() {
            super("CharMatcher.none()");
        }

        @Override
        public final boolean matches(char c) {
            return false;
        }

        @Override
        public final int indexIn(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexIn(CharSequence sequence, int start) {
            void var1_2;
            void var2_3;
            int length = sequence.length();
            Preconditions.checkPositionIndex((int)var2_3, (int)var1_2);
            return -1;
        }

        @Override
        public final boolean matchesAllOf(CharSequence sequence) {
            return sequence.length() == 0;
        }

        @Override
        public final boolean matchesNoneOf(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return true;
        }

        @Override
        public final String removeFrom(CharSequence sequence) {
            return sequence.toString();
        }

        @Override
        public final String trimLeadingFrom(CharSequence sequence) {
            return sequence.toString();
        }

        @Override
        public final String trimTrailingFrom(CharSequence sequence) {
            return sequence.toString();
        }

        @Override
        public final int countIn(CharSequence sequence) {
            Preconditions.checkNotNull(sequence);
            return 0;
        }

        @Override
        public final CharMatcher or(CharMatcher other) {
            return Preconditions.checkNotNull(other);
        }

        @Override
        public final CharMatcher negate() {
            return Any.INSTANCE$22b9cf5;
        }
    }

    static final class Whitespace
    extends NamedFastMatcher {
        private static int SHIFT = Integer.numberOfLeadingZeros(32 - 1);
        static final Whitespace INSTANCE$22b9cf5 = new Whitespace();

        Whitespace() {
            super("CharMatcher.whitespace()");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".charAt(c * 1682554634 >>> SHIFT) == var1_1;
        }
    }

    private static final class BreakingWhitespace
    extends CharMatcher {
        static final BreakingWhitespace INSTANCE$22b9cf5 = new BreakingWhitespace();

        private BreakingWhitespace() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            switch (c) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': {
                    return true;
                }
                case '\u2007': {
                    return false;
                }
            }
            return c >= '\u2000' && var1_1 <= 8202;
        }

        @Override
        public final String toString() {
            return "CharMatcher.breakingWhitespace()";
        }
    }

    private static final class Is
    extends FastMatcher {
        private final char match;

        /*
         * WARNING - void declaration
         */
        Is(char match) {
            void var1_1;
            this.match = var1_1;
        }

        @Override
        public final boolean matches(char c) {
            return c == this.match;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final CharMatcher or(CharMatcher other) {
            void var1_1;
            if (other.matches(this.match)) {
                return other;
            }
            return super.or((CharMatcher)var1_1);
        }

        @Override
        public final CharMatcher negate() {
            return Is.isNot$8d21c63(this.match);
        }

        @Override
        public final String toString() {
            return "CharMatcher.is('" + CharMatcher.access$100(this.match) + "')";
        }
    }

    private static final class IsNot
    extends FastMatcher {
        private final char match;

        /*
         * WARNING - void declaration
         */
        IsNot(char match) {
            void var1_1;
            this.match = var1_1;
        }

        @Override
        public final boolean matches(char c) {
            return c != this.match;
        }

        @Override
        public final CharMatcher or(CharMatcher other) {
            if (other.matches(this.match)) {
                return Any.INSTANCE$22b9cf5;
            }
            return this;
        }

        @Override
        public final CharMatcher negate() {
            return IsNot.is$8d21c63(this.match);
        }

        @Override
        public final String toString() {
            return "CharMatcher.isNot('" + CharMatcher.access$100(this.match) + "')";
        }
    }

    private static final class IsEither
    extends FastMatcher {
        private final char match1;
        private final char match2;

        /*
         * WARNING - void declaration
         */
        IsEither(char match1, char match2) {
            void var2_2;
            void var1_1;
            this.match1 = var1_1;
            this.match2 = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return c == this.match1 || var1_1 == this.match2;
        }

        @Override
        public final String toString() {
            return "CharMatcher.anyOf(\"" + CharMatcher.access$100(this.match1) + CharMatcher.access$100(this.match2) + "\")";
        }
    }

    private static final class AnyOf
    extends CharMatcher {
        private final char[] chars;

        /*
         * WARNING - void declaration
         */
        public AnyOf(CharSequence chars) {
            void var1_1;
            this.chars = var1_1.toString().toCharArray();
            Arrays.sort(this.chars);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return Arrays.binarySearch(this.chars, (char)var1_1) >= 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final String toString() {
            void var1_1;
            StringBuilder description = new StringBuilder("CharMatcher.anyOf(\"");
            char[] cArray = this.chars;
            int n = this.chars.length;
            for (int i = 0; i < n; ++i) {
                char c = cArray[i];
                description.append(CharMatcher.access$100(c));
            }
            description.append("\")");
            return var1_1.toString();
        }
    }

    private static class Negated
    extends CharMatcher {
        private CharMatcher original;

        /*
         * WARNING - void declaration
         */
        Negated(CharMatcher original) {
            void var1_1;
            this.original = (CharMatcher)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return !this.original.matches((char)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matchesAllOf(CharSequence sequence) {
            void var1_1;
            return this.original.matchesNoneOf((CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matchesNoneOf(CharSequence sequence) {
            void var1_1;
            return this.original.matchesAllOf((CharSequence)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int countIn(CharSequence sequence) {
            void var1_1;
            return sequence.length() - this.original.countIn((CharSequence)var1_1);
        }

        @Override
        public final CharMatcher negate() {
            return this.original;
        }

        @Override
        public String toString() {
            return this.original + ".negate()";
        }
    }

    private static final class Or
    extends CharMatcher {
        private CharMatcher first;
        private CharMatcher second;

        /*
         * WARNING - void declaration
         */
        Or(CharMatcher a, CharMatcher b) {
            void var2_2;
            void var1_1;
            this.first = (CharMatcher)Preconditions.checkNotNull(var1_1);
            this.second = (CharMatcher)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean matches(char c) {
            void var1_1;
            return this.first.matches(c) || this.second.matches((char)var1_1);
        }

        @Override
        public final String toString() {
            return "CharMatcher.or(" + this.first + ", " + this.second + ")";
        }
    }

    private static final class NegatedFastMatcher
    extends Negated {
        /*
         * WARNING - void declaration
         */
        NegatedFastMatcher(FastMatcher original) {
            super((CharMatcher)var1_1);
            void var1_1;
        }
    }

    static abstract class NamedFastMatcher
    extends FastMatcher {
        private final String description;

        /*
         * WARNING - void declaration
         */
        NamedFastMatcher(String description) {
            void var1_1;
            this.description = (String)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final String toString() {
            return this.description;
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }
    }
}

