/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.AbstractIterator;
import com.google.common.base.CharMatcher;
import com.google.common.base.CommonMatcher;
import com.google.common.base.CommonPattern;
import com.google.common.base.Joiner;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class Splitter {
    private final CharMatcher trimmer;
    private final boolean omitEmptyStrings;
    private final Strategy strategy;
    private final int limit;

    /*
     * WARNING - void declaration
     */
    private Splitter(Strategy strategy) {
        this((Strategy)var1_1, false, CharMatcher.none(), Integer.MAX_VALUE);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Splitter(Strategy strategy, boolean omitEmptyStrings, CharMatcher trimmer, int limit) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.strategy = var1_1;
        this.omitEmptyStrings = var2_2;
        this.trimmer = var3_3;
        this.limit = limit;
    }

    public static Splitter on(char separator) {
        return Splitter.on(CharMatcher.is$8d21c63(separator));
    }

    public static Splitter on(CharMatcher separatorMatcher) {
        CharMatcher charMatcher;
        Preconditions.checkNotNull(separatorMatcher);
        return new Splitter(new Strategy(){});
    }

    public static Splitter onPattern(String separatorPattern) {
        CommonPattern commonPattern = Platform.compilePattern(separatorPattern);
        Preconditions.checkArgument(!((CommonMatcher)commonPattern.matcher$d3b49d9("")).matches(), "The pattern may not match the empty string: %s", commonPattern);
        return new Splitter(new Strategy(commonPattern){
            private /* synthetic */ CommonPattern val$separatorPattern;
            {
                this.val$separatorPattern = commonPattern;
            }
        });
    }

    public final Splitter omitEmptyStrings() {
        return new Splitter(this.strategy, true, this.trimmer, this.limit);
    }

    public final Splitter trimResults() {
        CharMatcher charMatcher = CharMatcher.whitespace();
        Splitter splitter = this;
        Preconditions.checkNotNull(charMatcher);
        return new Splitter(splitter.strategy, splitter.omitEmptyStrings, charMatcher, splitter.limit);
    }

    /*
     * WARNING - void declaration
     */
    public final Iterable<String> split$7a1f82da(CharSequence sequence) {
        void var1_1;
        Preconditions.checkNotNull(sequence);
        return new Iterable<String>(){
            private /* synthetic */ CharSequence val$sequence;
            private /* synthetic */ Splitter this$0;
            {
                void var1_1;
                this.val$sequence = charSequence;
                this.this$0 = var1_1;
            }

            @Override
            public final Iterator<String> iterator() {
                return Splitter.access$000(this.this$0, this.val$sequence);
            }

            public final String toString() {
                return Joiner.on(", ").appendTo(new StringBuilder("["), this).append(']').toString();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private Iterator<String> splittingIterator(CharSequence sequence) {
        void var1_1;
        return this.strategy.iterator$202dd7f0(this, (CharSequence)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final List<String> splitToList(CharSequence sequence) {
        void var2_2;
        Preconditions.checkNotNull(sequence);
        Iterator<String> iterator = this.splittingIterator(sequence);
        ArrayList<String> result = new ArrayList<String>();
        while (iterator.hasNext()) {
            result.add(iterator.next());
        }
        return Collections.unmodifiableList(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Iterator access$000(Splitter x0, CharSequence x1) {
        void var1_1;
        return x0.splittingIterator((CharSequence)var1_1);
    }

    private static interface Strategy {
        public Iterator<String> iterator$202dd7f0(Splitter var1, CharSequence var2);
    }

    private static abstract class SplittingIterator
    extends AbstractIterator<String> {
        final CharSequence toSplit;
        private CharMatcher trimmer;
        private boolean omitEmptyStrings;
        private int offset = 0;
        private int limit;

        abstract int separatorStart(int var1);

        abstract int separatorEnd(int var1);

        /*
         * WARNING - void declaration
         */
        protected SplittingIterator(Splitter splitter, CharSequence toSplit) {
            void var2_2;
            void var1_1;
            this.trimmer = splitter.trimmer;
            this.omitEmptyStrings = splitter.omitEmptyStrings;
            this.limit = ((Splitter)var1_1).limit;
            this.toSplit = var2_2;
        }
    }
}

