/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.base.Preconditions;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class Throwables {
    private static final Object jla = Throwables.getJLA();

    /*
     * WARNING - void declaration
     */
    public static <X extends Throwable> void throwIfInstanceOf(Throwable throwable, Class<X> declaredType) throws X {
        Preconditions.checkNotNull(throwable);
        if (declaredType.isInstance(throwable)) {
            Throwable throwable2;
            void var1_1;
            throw (Throwable)var1_1.cast(throwable2);
        }
    }

    public static void throwIfUnchecked(Throwable throwable) {
        Preconditions.checkNotNull(throwable);
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            Throwable throwable2;
            throw (Error)throwable2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getStackTraceAsString(Throwable throwable) {
        void var1_1;
        Throwable throwable2;
        StringWriter stringWriter = new StringWriter();
        throwable2.printStackTrace(new PrintWriter(stringWriter));
        return var1_1.toString();
    }

    private static Object getJLA() {
        try {
            GenericDeclaration genericDeclaration = Class.forName("sun.misc.SharedSecrets", false, null);
            genericDeclaration = genericDeclaration.getMethod("getJavaLangAccess", new Class[0]);
            return ((Method)genericDeclaration).invoke(null, new Object[0]);
        }
        catch (ThreadDeath threadDeath) {
            ThreadDeath threadDeath2 = threadDeath;
            throw threadDeath;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Method getSizeMethod(Object jla) {
        try {
            void var1_1;
            Object object;
            Method getStackTraceDepth = Throwables.getJlaMethod("getStackTraceDepth", Throwable.class);
            if (getStackTraceDepth == null) {
                return null;
            }
            getStackTraceDepth.invoke(object, new Throwable());
            return var1_1;
        }
        catch (IllegalAccessException | UnsupportedOperationException | InvocationTargetException exception) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static Method getJlaMethod(String name, Class<?> ... parameterTypes) throws ThreadDeath {
        ThreadDeath threadDeath;
        try {
            void var1_1;
            return Class.forName("sun.misc.JavaLangAccess", false, null).getMethod((String)((Object)threadDeath), (Class<?>)var1_1);
        }
        catch (ThreadDeath threadDeath2) {
            threadDeath = threadDeath2;
            throw threadDeath2;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static {
        if (jla != null) {
            Throwables.getJlaMethod("getStackTraceElement", Throwable.class, Integer.TYPE);
        }
        if (jla != null) {
            Throwables.getSizeMethod(jla);
        }
    }
}

