/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;

public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    private static final Object[] EMPTY_ARRAY = new Object[0];

    ImmutableCollection() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 1296);
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] other) {
        void var1_1;
        Preconditions.checkNotNull(other);
        int size = this.size();
        if (other.length < size) {
            T[] TArray;
            Object[] internal = this.internalArray();
            if (internal != null) {
                T[] TArray2 = other;
                int n = this.internalArrayEnd();
                size = this.internalArrayStart();
                other = TArray;
                return Arrays.copyOfRange(other, size, n, TArray2.getClass());
            }
            T[] TArray3 = other;
            int n = size;
            TArray = TArray3;
            other = TArray3.length == 0 ? TArray : Arrays.copyOf(TArray, 0);
            other = Arrays.copyOf(other, n);
        } else if (other.length > size) {
            other[var2_2] = null;
        }
        this.copyIntoArray(other, 0);
        return var1_1;
    }

    Object[] internalArray() {
        return null;
    }

    int internalArrayStart() {
        throw new UnsupportedOperationException();
    }

    int internalArrayEnd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    @Deprecated
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> asList() {
        switch (this.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of$714caac3(this.iterator().next());
            }
        }
        ImmutableCollection immutableCollection = this;
        return new RegularImmutableAsList(immutableCollection, immutableCollection.toArray());
    }

    abstract boolean isPartialView();

    /*
     * WARNING - void declaration
     */
    int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        for (Object e : this) {
            dst[offset++] = e;
        }
        return (int)var2_2;
    }

    public static abstract class Builder<E> {
        /*
         * WARNING - void declaration
         */
        static int expandedCapacity(int oldCapacity, int minCapacity) {
            int n;
            if (minCapacity < 0) {
                throw new IllegalArgumentException("cannot store more than MAX_VALUE elements");
            }
            if (minCapacity <= oldCapacity) {
                return oldCapacity;
            }
            int n2 = oldCapacity;
            int newCapacity = n2 + (n2 >> 1) + 1;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = Integer.highestOneBit((int)(var1_1 - true)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return n;
        }

        Builder() {
        }

        public abstract Builder<E> add(E var1);

        /*
         * WARNING - void declaration
         */
        public Builder<E> addAll(Iterable<? extends E> elements) {
            for (E element : elements) {
                void var2_2;
                this.add(var2_2);
            }
            return this;
        }

        public Builder<E> addAll(Iterator<? extends E> elements) {
            while (elements.hasNext()) {
                this.add(elements.next());
            }
            return this;
        }
    }
}

