/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.TransformedIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class Iterables {
    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    static Object[] toArray(Iterable<?> iterable) {
        Iterable<?> iterable2 = iterable;
        return (iterable2 instanceof Collection ? (ArrayList<?>)iterable2 : Lists.newArrayList(iterable2.iterator())).toArray();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<List<T>> partition$79fc6ffa(Iterable<T> iterable, int size) {
        void var1_1;
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument(size > 0);
        return new FluentIterable<List<T>>(iterable2, (int)var1_1){
            private /* synthetic */ Iterable val$iterable;
            private /* synthetic */ int val$size;
            {
                this.val$iterable = iterable;
                this.val$size = n;
            }

            @Override
            public final Iterator<List<T>> iterator() {
                return Iterators.partition(this.val$iterable.iterator(), this.val$size);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> filter$73b06d87(Iterable<T> unfiltered, com.google.common.base.Predicate<? super T> retainIfTrue) {
        void var1_1;
        Iterable<T> iterable;
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(retainIfTrue);
        return new FluentIterable<T>(iterable, (com.google.common.base.Predicate)var1_1){
            private /* synthetic */ Iterable val$unfiltered;
            private /* synthetic */ com.google.common.base.Predicate val$retainIfTrue;
            {
                this.val$unfiltered = iterable;
                this.val$retainIfTrue = predicate;
            }

            @Override
            public final Iterator<T> iterator() {
                com.google.common.base.Predicate predicate = this.val$retainIfTrue;
                Iterator iterator = this.val$unfiltered.iterator();
                Preconditions.checkNotNull(iterator);
                Preconditions.checkNotNull(predicate);
                return new AbstractIterator<T>(iterator, predicate){
                    private /* synthetic */ Iterator val$unfiltered;
                    private /* synthetic */ com.google.common.base.Predicate val$retainIfTrue;
                    {
                        this.val$unfiltered = iterator;
                        this.val$retainIfTrue = predicate;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    protected final T computeNext() {
                        while (this.val$unfiltered.hasNext()) {
                            void var1_1;
                            E element = this.val$unfiltered.next();
                            if (!this.val$retainIfTrue.apply(element)) continue;
                            return var1_1;
                        }
                        return this.endOfData();
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void forEach(Consumer<? super T> action) {
                void var1_1;
                Preconditions.checkNotNull(action);
                this.val$unfiltered.forEach(arg_0 -> 4.lambda$forEach$0(this.val$retainIfTrue, (Consumer)var1_1, arg_0));
            }

            @Override
            public final Spliterator<T> spliterator() {
                return CollectSpliterators.filter$1d29940e(this.val$unfiltered.spliterator(), (Predicate)this.val$retainIfTrue);
            }

            /*
             * WARNING - void declaration
             */
            private static /* synthetic */ void lambda$forEach$0(com.google.common.base.Predicate retainIfTrue, Consumer action, Object a) {
                if (retainIfTrue.test(a)) {
                    void var2_2;
                    void var1_1;
                    var1_1.accept(var2_2);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Iterable<T> transform$59a95d6(Iterable<F> fromIterable, Function<? super F, ? extends T> function) {
        void var1_1;
        Iterable<F> iterable;
        Preconditions.checkNotNull(fromIterable);
        Preconditions.checkNotNull(function);
        return new FluentIterable<T>(iterable, (Function)var1_1){
            private /* synthetic */ Iterable val$fromIterable;
            private /* synthetic */ Function val$function;
            {
                this.val$fromIterable = iterable;
                this.val$function = function;
            }

            @Override
            public final Iterator<T> iterator() {
                Function function = this.val$function;
                Iterator iterator = this.val$fromIterable.iterator();
                Preconditions.checkNotNull(function);
                return new TransformedIterator<F, T>(iterator, function){
                    private /* synthetic */ Function val$function;
                    {
                        void var1_1;
                        this.val$function = function;
                        super(var1_1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    final T transform(F from) {
                        void var1_1;
                        return this.val$function.apply(var1_1);
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void forEach(Consumer<? super T> action) {
                void var1_1;
                Preconditions.checkNotNull(action);
                this.val$fromIterable.forEach(arg_0 -> 5.lambda$forEach$0((Consumer)var1_1, this.val$function, arg_0));
            }

            @Override
            public final Spliterator<T> spliterator() {
                return CollectSpliterators.map$6379d89(this.val$fromIterable.spliterator(), (java.util.function.Function)this.val$function);
            }

            /*
             * WARNING - void declaration
             */
            private static /* synthetic */ void lambda$forEach$0(Consumer action, Function function, Object f) {
                void var2_2;
                void var1_1;
                action.accept(var1_1.apply(var2_2));
            }
        };
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public static Object getFirst$4f661e18(ImmutableSortedSet iterable, Object defaultValue) {
        return Iterators.getNext(iterable.iterator(), null);
    }

    public static <T> T getLast(Iterable<T> iterable) {
        List list2;
        if (iterable instanceof List) {
            List list3 = (List)iterable;
            if (list3.isEmpty()) {
                throw new NoSuchElementException();
            }
            return (T)list2.get(list2.size() - 1);
        }
        return Iterators.getLast(list2.iterator());
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        Iterable<?> iterable2;
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable2.iterator().hasNext();
    }
}

