/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.TransformedListIterator;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.function.Predicate;

public final class Lists {
    /*
     * WARNING - void declaration
     */
    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        void var1_1;
        Iterator<? extends E> iterator;
        ArrayList list2 = new ArrayList();
        Iterators.addAll(list2, iterator);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> List<T> transform(List<F> fromList, Function<? super F, ? extends T> function) {
        void var1_1;
        List<F> list2;
        if (fromList instanceof RandomAccess) {
            return new TransformingRandomAccessList<F, T>(fromList, function);
        }
        return new TransformingSequentialList(list2, var1_1);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    static int indexOfImpl$48b700b5(ImmutableList list2, Object element) {
        void var1_1;
        ImmutableList immutableList = list2;
        int n = immutableList.size();
        if (var1_1 == null) {
            for (int i = 0; i < n; ++i) {
                if (immutableList.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                if (!var1_1.equals(immutableList.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    static int lastIndexOfImpl$48b700b5(ImmutableList list2, Object element) {
        void var1_1;
        ImmutableList immutableList = list2;
        if (var1_1 == null) {
            for (int i = immutableList.size() - 1; i >= 0; --i) {
                if (immutableList.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = immutableList.size() - 1; i >= 0; --i) {
                if (!var1_1.equals(immutableList.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    private static final class TransformingRandomAccessList<F, T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        private List<F> fromList;
        final Function<? super F, ? extends T> function;

        /*
         * WARNING - void declaration
         */
        TransformingRandomAccessList(List<F> fromList, Function<? super F, ? extends T> function) {
            void var2_2;
            void var1_1;
            this.fromList = (List)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void removeRange(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            this.fromList.subList((int)var1_1, (int)var2_2).clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T get(int index) {
            void var1_1;
            return this.function.apply(this.fromList.get((int)var1_1));
        }

        @Override
        public final Iterator<T> iterator() {
            return this.listIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListIterator<T> listIterator(int index) {
            void var1_1;
            TransformingRandomAccessList transformingRandomAccessList = this;
            return new TransformedListIterator<F, T>(transformingRandomAccessList, transformingRandomAccessList.fromList.listIterator((int)var1_1)){
                private /* synthetic */ TransformingRandomAccessList this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                final T transform(F from) {
                    void var1_1;
                    return this.this$0.function.apply(var1_1);
                }
            };
        }

        @Override
        public final boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeIf(Predicate<? super T> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return this.fromList.removeIf(arg_0 -> this.lambda$removeIf$0((Predicate)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final T remove(int index) {
            void var1_1;
            return this.function.apply(this.fromList.remove((int)var1_1));
        }

        @Override
        public final int size() {
            return this.fromList.size();
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ boolean lambda$removeIf$0(Predicate filter, Object element) {
            void var2_2;
            return filter.test(this.function.apply(var2_2));
        }
    }

    private static final class TransformingSequentialList<F, T>
    extends AbstractSequentialList<T>
    implements Serializable {
        private List<F> fromList;
        final Function<? super F, ? extends T> function;

        /*
         * WARNING - void declaration
         */
        TransformingSequentialList(List<F> fromList, Function<? super F, ? extends T> function) {
            void var2_2;
            void var1_1;
            this.fromList = (List)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final void removeRange(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            this.fromList.subList((int)var1_1, (int)var2_2).clear();
        }

        @Override
        public final int size() {
            return this.fromList.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ListIterator<T> listIterator(int index) {
            void var1_1;
            TransformingSequentialList transformingSequentialList = this;
            return new TransformedListIterator<F, T>(transformingSequentialList, transformingSequentialList.fromList.listIterator((int)var1_1)){
                private /* synthetic */ TransformingSequentialList this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                final T transform(F from) {
                    void var1_1;
                    return this.this$0.function.apply(var1_1);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeIf(Predicate<? super T> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return this.fromList.removeIf(arg_0 -> this.lambda$removeIf$0((Predicate)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ boolean lambda$removeIf$0(Predicate filter, Object element) {
            void var2_2;
            return filter.test(this.function.apply(var2_2));
        }
    }
}

