/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.Iterators;
import com.google.common.collect.NaturalOrdering;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.TransformedIterator;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

public final class Maps {
    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        int n;
        return new HashMap(Maps.capacity(n));
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            int n;
            return (int)Math.ceil((double)n / 0.75);
        }
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map.Entry<K, V> immutableEntry$5733d0c(K key, V value) {
        void var1_1;
        K k;
        return new ImmutableEntry<K, void>(k, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <V> V safeGet(Map<?, V> map, Object key) {
        Preconditions.checkNotNull(map);
        try {
            void var1_1;
            Map<?, V> map2;
            return map2.get(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean safeContainsKey(Map<?, ?> map, Object key) {
        Preconditions.checkNotNull(map);
        try {
            void var1_1;
            Map<?, ?> map2;
            return map2.containsKey(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static <V> V safeRemove(Map<?, V> map, Object key) {
        Preconditions.checkNotNull(map);
        try {
            void var1_1;
            Map<?, V> map2;
            return map2.remove(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static String toStringImpl(Map<?, ?> map) {
        void var1_1;
        Object object;
        StringBuilder sb = Collections2.newStringBuilderForCollection(map.size()).append('{');
        boolean first = true;
        for (Map.Entry entry : object.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return var1_1.append('}').toString();
    }

    static <K> K keyOrNull(Map.Entry<K, ?> entry) {
        Map.Entry<K, ?> entry2;
        if (entry == null) {
            return null;
        }
        return entry2.getKey();
    }

    private static abstract class EntryFunction
    extends Enum<EntryFunction>
    implements Function<Map.Entry<?, ?>, Object> {
        public static final /* enum */ 1 KEY$60601a0f = new EntryFunction(){};
        public static final /* enum */ 2 VALUE$60601a0f = new EntryFunction(){};

        private EntryFunction() {
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ EntryFunction(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            EntryFunction[] entryFunctionArray = new EntryFunction[]{KEY$60601a0f, VALUE$60601a0f};
        }
    }

    static abstract class DescendingMap<K, V>
    extends ForwardingMap<K, V>
    implements NavigableMap<K, V> {
        private transient Comparator<? super K> comparator$3706e907;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient NavigableSet<K> navigableKeySet$74b29718;

        DescendingMap() {
        }

        abstract NavigableMap<K, V> forward$fbf12f();

        @Override
        protected final Map<K, V> delegate() {
            return this.forward$fbf12f();
        }

        @Override
        public Comparator<? super K> comparator() {
            Ordering ordering;
            Comparator<? super K> result = this.comparator$3706e907;
            if (result == null) {
                NaturalOrdering forwardCmp = this.forward$fbf12f().comparator();
                if (forwardCmp == null) {
                    forwardCmp = Ordering.natural$75ffd5c5();
                }
                this.comparator$3706e907 = Ordering.from(ordering).reverse();
                ordering = this.comparator$3706e907;
            }
            return ordering;
        }

        @Override
        public K firstKey() {
            return this.forward$fbf12f().lastKey();
        }

        @Override
        public K lastKey() {
            return this.forward$fbf12f().firstKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            void var1_1;
            return this.forward$fbf12f().higherEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lowerKey(K key) {
            void var1_1;
            return this.forward$fbf12f().higherKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            void var1_1;
            return this.forward$fbf12f().ceilingEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floorKey(K key) {
            void var1_1;
            return this.forward$fbf12f().ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            void var1_1;
            return this.forward$fbf12f().floorEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceilingKey(K key) {
            void var1_1;
            return this.forward$fbf12f().floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            void var1_1;
            return this.forward$fbf12f().lowerEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higherKey(K key) {
            void var1_1;
            return this.forward$fbf12f().lowerKey(var1_1);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.forward$fbf12f().lastEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.forward$fbf12f().firstEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.forward$fbf12f().pollLastEntry();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.forward$fbf12f().pollFirstEntry();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return this.forward$fbf12f();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            void var1_1;
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                result = this;
                final class EntrySetImpl
                extends EntrySet<K, V> {
                    private /* synthetic */ DescendingMap this$0;

                    /*
                     * WARNING - void declaration
                     */
                    EntrySetImpl(DescendingMap this$0) {
                        void var1_1;
                        this.this$0 = var1_1;
                    }

                    @Override
                    final Map<K, V> map() {
                        return this.this$0;
                    }

                    @Override
                    public final Iterator<Map.Entry<K, V>> iterator() {
                        return this.this$0.entryIterator();
                    }
                }
                this.entrySet = new EntrySetImpl((DescendingMap)((Object)result));
                return this.entrySet;
            }
            return var1_1;
        }

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> navigableKeySet() {
            void var1_1;
            NavigableSet<K> result = this.navigableKeySet$74b29718;
            if (result == null) {
                this.navigableKeySet$74b29718 = new NavigableKeySet(this);
                return this.navigableKeySet$74b29718;
            }
            return var1_1;
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.forward$fbf12f().navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            void var2_2;
            void var1_1;
            void var3_3;
            return this.forward$fbf12f().subMap(var3_3, toInclusive, var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            void var2_2;
            void var1_1;
            return this.subMap(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward$fbf12f().tailMap(var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(K toKey) {
            void var1_1;
            return this.headMap(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward$fbf12f().headMap(var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            void var1_1;
            return this.tailMap(var1_1, true);
        }

        @Override
        public Collection<V> values() {
            return new Values(this);
        }

        @Override
        public String toString() {
            DescendingMap descendingMap = this;
            return Maps.toStringImpl(descendingMap);
        }
    }

    static abstract class EntrySet<K, V>
    extends Sets.ImprovedAbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                void var2_2;
                void var3_3;
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                V value = Maps.safeGet(this.map(), key);
                return Objects.equal(value, var1_1.getValue()) && (var3_3 != null || this.map().containsKey(var2_2));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (this.contains(o) && o instanceof Map.Entry) {
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                return this.map().keySet().remove(var1_1.getKey());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var1_1;
                return Sets.removeAllImpl(this, var1_1.iterator());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                Iterator iterator;
                HashSet keys = Sets.newHashSetWithExpectedSize(c.size());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var3_3;
                    Object o = iterator.next();
                    if (!this.contains(o) || !(o instanceof Map.Entry)) continue;
                    Map.Entry entry = (Map.Entry)o;
                    keys.add(var3_3.getKey());
                }
                return this.map().keySet().retainAll((Collection<?>)var2_2);
            }
        }
    }

    static final class Values<K, V>
    extends AbstractCollection<V> {
        private Map<K, V> map;

        /*
         * WARNING - void declaration
         */
        Values(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public final Iterator<V> iterator() {
            Object object = this;
            object = ((Values)object).map.entrySet().iterator();
            return new TransformedIterator<Map.Entry<K, V>, V>((Iterator)object){
                {
                    void var1_1;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void forEach(Consumer<? super V> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.map.forEach((arg_0, arg_1) -> Values.lambda$forEach$0((Consumer)var1_1, arg_0, arg_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            try {
                return super.remove(o);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Object object = this;
                object = ((Values)object).map.entrySet().iterator();
                while (object.hasNext()) {
                    void var3_3;
                    Map.Entry entry = (Map.Entry)object.next();
                    if (!Objects.equal(o, entry.getValue())) continue;
                    object = this;
                    ((Values)object).map.remove(var3_3.getKey());
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                HashSet toRemove = new HashSet();
                Object object = this;
                for (Map.Entry entry : ((Values)object).map.entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRemove.add(entry.getKey());
                }
                object = this;
                return ((Values)object).map.keySet().removeAll((Collection<?>)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                HashSet toRetain = new HashSet();
                Object object = this;
                for (Map.Entry entry : ((Values)object).map.entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRetain.add(entry.getKey());
                }
                object = this;
                return ((Values)object).map.keySet().retainAll((Collection<?>)var2_2);
            }
        }

        @Override
        public final int size() {
            Values values = this;
            return values.map.size();
        }

        @Override
        public final boolean isEmpty() {
            Values values = this;
            return values.map.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            Values values = this;
            return values.map.containsValue(var1_1);
        }

        @Override
        public final void clear() {
            Values values = this;
            values.map.clear();
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEach$0(Consumer action, Object k, Object v) {
            void var2_2;
            action.accept(var2_2);
        }
    }

    static final class NavigableKeySet<K, V>
    extends SortedKeySet<K, V>
    implements NavigableSet<K> {
        /*
         * WARNING - void declaration
         */
        NavigableKeySet(NavigableMap<K, V> map) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K lower(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).lowerKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K floor(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K ceiling(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K higher(K e) {
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).higherKey(var1_1);
        }

        @Override
        public final K pollFirst() {
            NavigableKeySet navigableKeySet = this;
            return Maps.keyOrNull(((NavigableMap)navigableKeySet.map).pollFirstEntry());
        }

        @Override
        public final K pollLast() {
            NavigableKeySet navigableKeySet = this;
            return Maps.keyOrNull(((NavigableMap)navigableKeySet.map).pollLastEntry());
        }

        @Override
        public final NavigableSet<K> descendingSet() {
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).descendingKeySet();
        }

        @Override
        public final Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<K> subSet(K fromElement, boolean fromInclusive, K toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).subMap(var1_1, (boolean)var2_2, var3_3, toInclusive).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final SortedSet<K> subSet(K fromElement, K toElement) {
            void var2_2;
            void var1_1;
            return this.subSet(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<K> headSet(K toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).headMap(var1_1, (boolean)var2_2).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final SortedSet<K> headSet(K toElement) {
            void var1_1;
            return this.headSet(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            NavigableKeySet navigableKeySet = this;
            return ((NavigableMap)navigableKeySet.map).tailMap(var1_1, (boolean)var2_2).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final SortedSet<K> tailSet(K fromElement) {
            void var1_1;
            return this.tailSet(var1_1, true);
        }
    }

    static class SortedKeySet<K, V>
    extends KeySet<K, V>
    implements SortedSet<K> {
        /*
         * WARNING - void declaration
         */
        SortedKeySet(SortedMap<K, V> map) {
            super(var1_1);
            void var1_1;
        }

        @Override
        SortedMap<K, V> map() {
            return (SortedMap)super.map();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map().comparator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            void var2_2;
            void var1_1;
            return new SortedKeySet(this.map().subMap(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> headSet(K toElement) {
            void var1_1;
            return new SortedKeySet(this.map().headMap(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> tailSet(K fromElement) {
            void var1_1;
            return new SortedKeySet(this.map().tailMap(var1_1));
        }

        @Override
        public K first() {
            return this.map().firstKey();
        }

        @Override
        public K last() {
            return this.map().lastKey();
        }
    }

    static class KeySet<K, V>
    extends Sets.ImprovedAbstractSet<K> {
        final Map<K, V> map;

        /*
         * WARNING - void declaration
         */
        KeySet(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Preconditions.checkNotNull(var1_1);
        }

        Map<K, V> map() {
            return this.map;
        }

        @Override
        public Iterator<K> iterator() {
            Iterator<Map.Entry<K, V>> iterator = this.map().entrySet().iterator();
            return new TransformedIterator<Map.Entry<K, V>, K>(iterator){
                {
                    void var1_1;
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(Consumer<? super K> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.map.forEach((arg_0, arg_1) -> KeySet.lambda$forEach$0((Consumer)var1_1, arg_0, arg_1));
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.map().containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                void var1_1;
                this.map().remove(var1_1);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEach$0(Consumer action, Object k, Object v) {
            void var1_1;
            action.accept(var1_1);
        }
    }

    static abstract class IteratorBasedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        IteratorBasedAbstractMap() {
        }

        @Override
        public abstract int size();

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet<K, V>(this){
                private /* synthetic */ IteratorBasedAbstractMap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                final Map<K, V> map() {
                    return this.this$0;
                }

                @Override
                public final Iterator<Map.Entry<K, V>> iterator() {
                    return this.this$0.entryIterator();
                }

                @Override
                public final Spliterator<Map.Entry<K, V>> spliterator() {
                    IteratorBasedAbstractMap iteratorBasedAbstractMap = this.this$0;
                    return Spliterators.spliterator(iteratorBasedAbstractMap.entryIterator(), (long)iteratorBasedAbstractMap.size(), 65);
                }

                @Override
                public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
                    IteratorBasedAbstractMap iteratorBasedAbstractMap;
                    void var2_2 = iteratorBasedAbstractMap;
                    iteratorBasedAbstractMap = this.this$0;
                    iteratorBasedAbstractMap.entryIterator().forEachRemaining(var2_2);
                }
            };
        }

        @Override
        public void clear() {
            Iterators.clear(this.entryIterator());
        }
    }

    static abstract class ViewCachingAbstractMap<K, V>
    extends AbstractMap<K, V> {
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Set<K> keySet;
        private transient Collection<V> values;

        ViewCachingAbstractMap() {
        }

        abstract Set<Map.Entry<K, V>> createEntrySet$6051c6a4();

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            void var1_1;
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                this.entrySet = this.createEntrySet$6051c6a4();
                return this.entrySet;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<K> keySet() {
            void var1_1;
            Set<K> result = this.keySet;
            if (result == null) {
                result = this;
                this.keySet = new KeySet(result);
                return this.keySet;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> values() {
            void var1_1;
            Collection<V> result = this.values;
            if (result == null) {
                result = this;
                this.values = new Values(result);
                return this.values;
            }
            return var1_1;
        }
    }
}

