/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Cut;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

final class SortedLists {
    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    public static int binarySearch$1c53ff7f(ImmutableList list2, Function keyFunction, Cut key, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        void var3_3;
        void var2_2;
        void var1_1;
        ImmutableList immutableList;
        Preconditions.checkNotNull(key);
        return SortedLists.binarySearch$53cb8e33(immutableList, (Function)var1_1, var2_2, Ordering.natural$75ffd5c5(), (KeyPresentBehavior)var3_3, absentBehavior);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     * WARNING - void declaration
     */
    public static int binarySearch$53cb8e33(List list2, Function keyFunction, Object key, Ordering keyComparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        void var3_3;
        void var2_2;
        void var1_1;
        return SortedLists.binarySearch(Lists.transform(list2, var1_1), var2_2, var3_3, presentBehavior, absentBehavior);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> int binarySearch(List<? extends E> list2, E key, Comparator<? super E> comparator, KeyPresentBehavior presentBehavior, KeyAbsentBehavior absentBehavior) {
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(list2);
        Preconditions.checkNotNull(presentBehavior);
        Preconditions.checkNotNull(absentBehavior);
        if (!(list2 instanceof RandomAccess)) {
            list2 = new ArrayList<E>(list2);
        }
        int lower = 0;
        int upper = list2.size() - 1;
        while (lower <= upper) {
            List<E> list3;
            void var1_1;
            void var2_2;
            void var3_3;
            int middle = lower + upper >>> 1;
            int c = comparator.compare(key, list2.get(middle));
            if (c < 0) {
                upper = middle - 1;
                continue;
            }
            if (c > 0) {
                lower = middle + 1;
                continue;
            }
            return lower + var3_3.resultIndex(var2_2, var1_1, list3.subList(lower, upper + 1), middle - lower);
        }
        return absentBehavior.resultIndex(lower);
    }

    static abstract class KeyPresentBehavior
    extends Enum<KeyPresentBehavior> {
        public static final /* enum */ 1 ANY_PRESENT$8552d4 = new KeyPresentBehavior(){

            @Override
            final <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list2, int foundIndex) {
                return foundIndex;
            }
        };
        public static final /* enum */ 2 LAST_PRESENT$8552d4 = new KeyPresentBehavior(){

            @Override
            final <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list2, int foundIndex) {
                int lower = foundIndex;
                int upper = list2.size() - 1;
                while (lower < upper) {
                    int middle = lower + upper + 1 >>> 1;
                    int n = comparator.compare(list2.get(middle), key);
                    if (n > 0) {
                        upper = middle - 1;
                        continue;
                    }
                    lower = middle;
                }
                return lower;
            }
        };
        public static final /* enum */ 3 FIRST_PRESENT$8552d4 = new KeyPresentBehavior(){

            @Override
            final <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list2, int foundIndex) {
                int lower = 0;
                int upper = foundIndex;
                while (lower < upper) {
                    int middle = lower + upper >>> 1;
                    int n = comparator.compare(list2.get(middle), key);
                    if (n < 0) {
                        lower = middle + 1;
                        continue;
                    }
                    upper = middle;
                }
                return lower;
            }
        };
        public static final /* enum */ 4 FIRST_AFTER$8552d4 = new KeyPresentBehavior(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list2, int foundIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                return ((KeyPresentBehavior)LAST_PRESENT$8552d4).resultIndex(var1_1, var2_2, var3_3, foundIndex) + 1;
            }
        };
        private static /* enum */ 5 LAST_BEFORE$8552d4 = new KeyPresentBehavior(){

            /*
             * WARNING - void declaration
             */
            @Override
            public final <E> int resultIndex(Comparator<? super E> comparator, E key, List<? extends E> list2, int foundIndex) {
                void var3_3;
                void var2_2;
                void var1_1;
                return ((KeyPresentBehavior)FIRST_PRESENT$8552d4).resultIndex(var1_1, var2_2, var3_3, foundIndex) - 1;
            }
        };

        private KeyPresentBehavior() {
        }

        abstract <E> int resultIndex(Comparator<? super E> var1, E var2, List<? extends E> var3, int var4);

        /*
         * WARNING - void declaration
         */
        /* synthetic */ KeyPresentBehavior(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            KeyPresentBehavior[] keyPresentBehaviorArray = new KeyPresentBehavior[]{ANY_PRESENT$8552d4, LAST_PRESENT$8552d4, FIRST_PRESENT$8552d4, FIRST_AFTER$8552d4, LAST_BEFORE$8552d4};
        }
    }

    static abstract class KeyAbsentBehavior
    extends Enum<KeyAbsentBehavior> {
        public static final /* enum */ 1 NEXT_LOWER$6589c8f6 = new KeyAbsentBehavior(){

            @Override
            final int resultIndex(int higherIndex) {
                return higherIndex - 1;
            }
        };
        public static final /* enum */ 2 NEXT_HIGHER$6589c8f6 = new KeyAbsentBehavior(){

            @Override
            public final int resultIndex(int higherIndex) {
                return higherIndex;
            }
        };
        private static /* enum */ 3 INVERTED_INSERTION_INDEX$6589c8f6 = new KeyAbsentBehavior(){

            @Override
            public final int resultIndex(int higherIndex) {
                return ~higherIndex;
            }
        };

        private KeyAbsentBehavior() {
        }

        abstract int resultIndex(int var1);

        /*
         * WARNING - void declaration
         */
        /* synthetic */ KeyAbsentBehavior(String x0, int x1, byte by) {
            this();
            void var2_2;
            void var1_1;
        }

        static {
            KeyAbsentBehavior[] keyAbsentBehaviorArray = new KeyAbsentBehavior[]{NEXT_LOWER$6589c8f6, NEXT_HIGHER$6589c8f6, INVERTED_INSERTION_INDEX$6589c8f6};
        }
    }
}

