/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.CharSequenceReader;
import com.google.common.io.CharStreams;
import com.google.common.io.Closer;
import java.io.IOException;
import java.io.Reader;

public abstract class CharSource {
    protected CharSource() {
    }

    public abstract Reader openStream() throws IOException;

    /*
     * WARNING - void declaration
     */
    public String read() throws IOException {
        Object object;
        Closer closer = Closer.create();
        try {
            object = closer.register(this.openStream());
            object = CharStreams.toString((Readable)object);
        }
        catch (Throwable e) {
            try {
                void var2_3;
                throw closer.rethrow((Throwable)var2_3);
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        closer.close();
        return object;
    }

    public static CharSequenceCharSource wrap$366b43ec(CharSequence charSequence) {
        CharSequence charSequence2;
        return new CharSequenceCharSource(charSequence2);
    }

    private static class CharSequenceCharSource
    extends CharSource {
        protected final CharSequence seq;

        /*
         * WARNING - void declaration
         */
        protected CharSequenceCharSource(CharSequence seq) {
            void var1_1;
            this.seq = (CharSequence)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public Reader openStream() {
            return new CharSequenceReader(this.seq);
        }

        @Override
        public final String read() {
            return this.seq.toString();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("CharSource.wrap(");
            String string = "...";
            int n = 30;
            CharSequence charSequence = this.seq;
            Preconditions.checkNotNull(charSequence);
            int n2 = 30 - string.length();
            Preconditions.checkArgument(n2 >= 0, "maxLength (%s) must be >= length of the truncation indicator (%s)", 30, string.length());
            return stringBuilder.append((String)(charSequence.length() <= 30 && ((String)(charSequence = charSequence.toString())).length() <= 30 ? charSequence : new StringBuilder(30).append(charSequence, 0, n2).append(string).toString())).append(")").toString();
        }

        static {
            Splitter.onPattern("\r\n|\n|\r");
        }
    }
}

