/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.logging.Level;

public final class Closer
implements Closeable {
    private Suppressor suppressor;
    private final Deque<Closeable> stack = new ArrayDeque<Closeable>(4);
    private Throwable thrown;
    private static final Suppressor SUPPRESSING_SUPPRESSOR = (closeable, thrown, suppressed) -> {
        if (thrown == suppressed) {
            return;
        }
        try {
            void var1_1;
            var1_1.addSuppressed(suppressed);
            return;
        }
        catch (Throwable throwable) {
            void var2_2;
            Closeable closeable2;
            Closeables.logger.log(Level.WARNING, "Suppressing exception thrown when closing " + closeable2, (Throwable)var2_2);
            return;
        }
    };

    public static Closer create() {
        return new Closer(SUPPRESSING_SUPPRESSOR);
    }

    /*
     * WARNING - void declaration
     */
    private Closer(Suppressor suppressor) {
        void var1_1;
        this.suppressor = (Suppressor)Preconditions.checkNotNull(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <C extends Closeable> C register(C closeable) {
        void var1_1;
        if (closeable != null) {
            this.stack.addFirst(closeable);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final RuntimeException rethrow(Throwable e) throws IOException {
        void var1_1;
        Preconditions.checkNotNull(e);
        this.thrown = e;
        Throwables.throwIfInstanceOf(e, IOException.class);
        Throwables.throwIfUnchecked(e);
        throw new RuntimeException((Throwable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void close() throws IOException {
        Throwable throwable = this.thrown;
        while (!this.stack.isEmpty()) {
            Closeable closeable = this.stack.removeFirst();
            try {
                closeable.close();
            }
            catch (Throwable e) {
                void var3_3;
                void var2_2;
                if (throwable == null) {
                    throwable = e;
                    continue;
                }
                this.suppressor.suppress((Closeable)var2_2, throwable, (Throwable)var3_3);
            }
        }
        if (this.thrown == null && throwable != null) {
            void var1_1;
            Throwables.throwIfInstanceOf(throwable, IOException.class);
            Throwables.throwIfUnchecked(throwable);
            throw new AssertionError(var1_1);
        }
    }

    static interface Suppressor {
        public void suppress(Closeable var1, Throwable var2, Throwable var3);
    }
}

