/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.util.concurrent.Internal;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public final class MoreExecutors {
    /*
     * WARNING - void declaration
     */
    public static boolean shutdownAndAwaitTermination(ExecutorService service, Duration timeout) {
        void var1_1;
        return MoreExecutors.shutdownAndAwaitTermination(service, Internal.toNanosSaturated((Duration)var1_1), TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean shutdownAndAwaitTermination(ExecutorService service, long timeout, TimeUnit unit) {
        ExecutorService executorService;
        void var1_1;
        long halfTimeoutNanos = unit.toNanos((long)var1_1) / 2L;
        service.shutdown();
        try {
            if (!service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS)) {
                service.shutdownNow();
                service.awaitTermination(halfTimeoutNanos, TimeUnit.NANOSECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            service.shutdownNow();
        }
        return executorService.isTerminated();
    }
}

