/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.collect.ImmutableList;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.SequencedCollection;

class DimensionHelpers {
    DimensionHelpers() {
    }

    /*
     * WARNING - void declaration
     */
    static TypeWithDims extractDims(Tree node, SortedDims sorted) {
        void var1_1;
        Tree tree;
        void var2_2;
        ArrayDeque<List<AnnotationTree>> builder = new ArrayDeque<List<AnnotationTree>>();
        node = DimensionHelpers.extractDims(builder, node);
        Object dims = sorted == SortedDims.YES ? DimensionHelpers.reorderBySourcePosition(builder) : var2_2;
        return new TypeWithDims(tree, ImmutableList.copyOf(var1_1));
    }

    private static Iterable<List<AnnotationTree>> reorderBySourcePosition(Deque<List<AnnotationTree>> dims) {
        SequencedCollection<List<AnnotationTree>> sequencedCollection;
        int lastAnnotation = -1;
        int lastPos = -1;
        int idx = 0;
        for (List<AnnotationTree> dim : dims) {
            if (!dim.isEmpty()) {
                int pos = ((JCTree)((Object)dim.get(0))).getStartPosition();
                if (pos < lastPos) {
                    SequencedCollection<List<AnnotationTree>> list2 = new ArrayList<List<AnnotationTree>>(dims);
                    Collections.rotate(list2, -(lastAnnotation + 1));
                    return sequencedCollection;
                }
                lastPos = pos;
                lastAnnotation = idx;
            }
            ++idx;
        }
        return sequencedCollection;
    }

    /*
     * WARNING - void declaration
     */
    private static Tree extractDims(Deque<List<AnnotationTree>> dims, Tree node) {
        void var1_1;
        block4: while (true) {
            switch (node.getKind()) {
                case ARRAY_TYPE: {
                    node = ((ArrayTypeTree)node).getType();
                    continue block4;
                }
                case ANNOTATED_TYPE: {
                    void var2_2;
                    Deque<List<AnnotationTree>> deque;
                    AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)node;
                    if (annotatedTypeTree.getUnderlyingType().getKind() != Tree.Kind.ARRAY_TYPE) {
                        return node;
                    }
                    node = DimensionHelpers.extractDims(dims, annotatedTypeTree.getUnderlyingType());
                    deque.addFirst(ImmutableList.copyOf(var2_2.getAnnotations()));
                    return node;
                }
            }
            break;
        }
        return var1_1;
    }

    static enum SortedDims {
        YES,
        NO;

    }

    static class TypeWithDims {
        final Tree node;
        final ImmutableList<List<AnnotationTree>> dims;

        /*
         * WARNING - void declaration
         */
        public TypeWithDims(Tree node, ImmutableList<List<AnnotationTree>> dims) {
            void var2_2;
            void var1_1;
            this.node = var1_1;
            this.dims = var2_2;
        }
    }
}

