/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.googlejavaformat.FormatterDiagnostic;
import com.google.googlejavaformat.java.CommandLineOptions;
import com.google.googlejavaformat.java.CommandLineOptionsParser;
import com.google.googlejavaformat.java.FormatFileCallable;
import com.google.googlejavaformat.java.GoogleJavaFormatVersion;
import com.google.googlejavaformat.java.JavaFormatterOptions;
import com.google.googlejavaformat.java.UsageException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public final class Main {
    private static final int MAX_THREADS = 20;
    private static final String STDIN_FILENAME = "<stdin>";
    private final PrintWriter outWriter;
    private final PrintWriter errWriter;
    private final InputStream inStream;

    static String versionString() {
        return "google-java-format: Version " + GoogleJavaFormatVersion.version();
    }

    /*
     * WARNING - void declaration
     */
    public Main(PrintWriter outWriter, PrintWriter errWriter, InputStream inStream) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.outWriter = var1_1;
        this.errWriter = var2_2;
        this.inStream = var3_3;
    }

    public static void main(String ... args) {
        String[] stringArray;
        int n = Main.main(System.in, System.out, System.err, stringArray);
        System.exit(n);
    }

    /*
     * WARNING - void declaration
     */
    static int main(InputStream in, PrintStream out, PrintStream err, String ... args) {
        void var3_3;
        void var2_2;
        void var1_1;
        InputStream inputStream;
        PrintWriter outWriter = new PrintWriter(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
        PrintWriter errWriter = new PrintWriter(new OutputStreamWriter((OutputStream)err, StandardCharsets.UTF_8));
        return Main.main(inputStream, (PrintWriter)var1_1, (PrintWriter)var2_2, (String[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static int main(InputStream in2, PrintWriter out, PrintWriter err, String ... args) {
        try {
            void var3_6;
            in2 = new Main(out, err, (InputStream)in2);
            int in2 = ((Main)in2).format((String[])var3_6);
            err.flush();
            out.flush();
            return in2;
        }
        catch (UsageException e) {
            try {
                void var0_2;
                err.print(var0_2.getMessage());
                err.flush();
                out.flush();
                return 2;
            }
            catch (Throwable throwable) {
                void var1_4;
                void var2_5;
                var2_5.flush();
                var1_4.flush();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int format(String ... args) throws UsageException {
        void var2_2;
        void var1_1;
        CommandLineOptions parameters = Main.processArgs(args);
        if (parameters.version()) {
            this.errWriter.println(Main.versionString());
            return 0;
        }
        if (parameters.help()) {
            throw new UsageException();
        }
        JavaFormatterOptions options = JavaFormatterOptions.builder().style(parameters.aosp() ? JavaFormatterOptions.Style.AOSP : JavaFormatterOptions.Style.GOOGLE).formatJavadoc(parameters.formatJavadoc()).build();
        if (parameters.stdin()) {
            return this.formatStdin(parameters, options);
        }
        return this.formatFiles((CommandLineOptions)var1_1, (JavaFormatterOptions)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private int formatFiles(CommandLineOptions parameters, JavaFormatterOptions options) {
        void var3_5;
        int n = Math.min(20, parameters.files().size());
        ExecutorService executorService = Executors.newFixedThreadPool(n);
        ExecutorCompletionService<FormatFileCallable.Result> cs = new ExecutorCompletionService<FormatFileCallable.Result>(executorService);
        boolean allOk = true;
        int files = 0;
        for (String fileName : parameters.files()) {
            if (!fileName.endsWith(".java")) {
                this.errWriter.println("Skipping non-Java file: " + fileName);
                continue;
            }
            Path path = Paths.get(fileName, new String[0]);
            try {
                String input = new String(Files.readAllBytes(path), StandardCharsets.UTF_8);
                cs.submit(new FormatFileCallable(parameters, path, input, (JavaFormatterOptions)options));
                ++files;
            }
            catch (IOException e) {
                this.errWriter.println(fileName + ": could not read file: " + e.getMessage());
                allOk = false;
            }
        }
        ArrayList<FormatFileCallable.Result> results = new ArrayList<FormatFileCallable.Result>();
        while (files > 0) {
            try {
                --files;
                results.add((FormatFileCallable.Result)cs.take().get());
            }
            catch (InterruptedException e) {
                this.errWriter.println(e.getMessage());
                allOk = false;
            }
            catch (ExecutionException e) {
                this.errWriter.println("error: " + e.getCause().getMessage());
                e.getCause().printStackTrace(this.errWriter);
                allOk = false;
            }
        }
        Collections.sort(results, Comparator.comparing(FormatFileCallable.Result::path));
        for (FormatFileCallable.Result result : results) {
            void var2_2;
            Path path = result.path();
            if (result.exception() != null) {
                for (FormatterDiagnostic diagnostic : result.exception().diagnostics()) {
                    this.errWriter.println(String.valueOf(path) + ":" + String.valueOf(diagnostic));
                }
                allOk = false;
                continue;
            }
            String formatted = result.output();
            boolean changed = result.changed();
            if (changed && parameters.setExitIfChanged()) {
                allOk = false;
            }
            if (parameters.inPlace()) {
                if (!changed) continue;
                try {
                    Files.write(path, formatted.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                }
                catch (IOException e) {
                    void var2_3;
                    this.errWriter.println(String.valueOf(path) + ": could not write file: " + var2_3.getMessage());
                    allOk = false;
                }
                continue;
            }
            if (parameters.dryRun()) {
                if (!changed) continue;
                this.outWriter.println(path);
                continue;
            }
            this.outWriter.write((String)var2_2);
        }
        if (!MoreExecutors.shutdownAndAwaitTermination((ExecutorService)var3_5, Duration.ofSeconds(5L))) {
            this.errWriter.println("Failed to shut down ExecutorService");
            allOk = false;
        }
        if (allOk) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private int formatStdin(CommandLineOptions parameters, JavaFormatterOptions options) {
        String input;
        try {
            input = new String(ByteStreams.toByteArray(this.inStream), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        String stdinFilename = parameters.assumeFilename().orElse(STDIN_FILENAME);
        boolean ok = true;
        FormatFileCallable.Result result = new FormatFileCallable(parameters, null, input, options).call();
        if (result.exception() != null) {
            for (FormatterDiagnostic diagnostic : result.exception().diagnostics()) {
                this.errWriter.println(stdinFilename + ":" + String.valueOf(diagnostic));
            }
            ok = false;
        } else {
            void var1_1;
            FormatterDiagnostic diagnostic;
            String output = ((FormatFileCallable.Result)((Object)diagnostic)).output();
            boolean changed = ((FormatFileCallable.Result)((Object)diagnostic)).changed();
            if (changed && parameters.setExitIfChanged()) {
                ok = false;
            }
            if (var1_1.dryRun()) {
                void var2_3;
                if (var2_3 != false) {
                    this.outWriter.println(stdinFilename);
                }
            } else {
                void var3_4;
                this.outWriter.write((String)var3_4);
            }
        }
        if (ok) {
            return 0;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static CommandLineOptions processArgs(String ... args) throws UsageException {
        CommandLineOptions commandLineOptions;
        void var1_3;
        CommandLineOptions parameters;
        try {
            parameters = CommandLineOptionsParser.parse(Arrays.asList(args));
        }
        catch (IllegalArgumentException e) {
            throw new UsageException(e.getMessage());
        }
        catch (Throwable throwable) {
            Throwable t = throwable;
            throwable.printStackTrace();
            throw new UsageException(t.getMessage());
        }
        int filesToFormat = parameters.files().size();
        if (parameters.stdin()) {
            ++filesToFormat;
        }
        if (parameters.inPlace() && parameters.files().isEmpty()) {
            throw new UsageException("in-place formatting was requested but no files were provided");
        }
        if (parameters.isSelection() && filesToFormat != 1) {
            throw new UsageException("partial formatting is only support for a single file");
        }
        if (parameters.offsets().size() != parameters.lengths().size()) {
            throw new UsageException("-offsets and -lengths flags must be provided in matching pairs");
        }
        if (var1_3 <= 0 && !parameters.version() && !parameters.help()) {
            throw new UsageException("no files were provided");
        }
        if (parameters.stdin() && !parameters.files().isEmpty()) {
            throw new UsageException("cannot format from standard input and files simultaneously");
        }
        if (parameters.assumeFilename().isPresent() && !parameters.stdin()) {
            throw new UsageException("--assume-filename is only supported when formatting standard input");
        }
        if (parameters.dryRun() && parameters.inPlace()) {
            throw new UsageException("cannot use --dry-run and --in-place at the same time");
        }
        return commandLineOptions;
    }
}

