/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.IntArrayList;
import com.google.protobuf.Utf8;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class Internal {
    static final Charset UTF_8;
    static final Charset ISO_8859_1;
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final ByteBuffer EMPTY_BYTE_BUFFER;

    static <T> T checkNotNull(T obj) {
        T t;
        if (obj == null) {
            throw new NullPointerException();
        }
        return t;
    }

    /*
     * WARNING - void declaration
     */
    static <T> T checkNotNull(T obj, String message) {
        T t;
        if (obj == null) {
            void var1_1;
            throw new NullPointerException((String)var1_1);
        }
        return t;
    }

    public static boolean isValidUtf8(byte[] byteArray) {
        return Utf8.isValidUtf8(byteArray);
    }

    public static String toStringUtf8(byte[] bytes) {
        byte[] byArray;
        return new String(byArray, UTF_8);
    }

    public static int hashLong(long n) {
        long l = n;
        return (int)(l ^ l >>> 32);
    }

    public static int hashBoolean(boolean b) {
        if (b) {
            return 1231;
        }
        return 1237;
    }

    public static int hashEnum(EnumLite e) {
        return e.getNumber();
    }

    /*
     * WARNING - void declaration
     */
    public static int hashEnumList(List<? extends EnumLite> list2) {
        void var1_1;
        Iterator<? extends EnumLite> iterator;
        int hash22 = 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            EnumLite e = (EnumLite)iterator.next();
            void hash22 = var2_3;
            hash22 = hash22 * 31 + hash22.getNumber();
        }
        return (int)var1_1;
    }

    public static int hashCode(byte[] bytes) {
        byte[] byArray;
        int n = byArray.length;
        boolean bl = false;
        byte[] byArray2 = bytes;
        int n2 = Internal.partialHash(n, byArray2, 0, n);
        if (n2 == 0) {
            return 1;
        }
        return n2;
    }

    static int partialHash(int h, byte[] bytes, int offset, int length) {
        int n;
        for (int i = offset; i < offset + length; ++i) {
            h = h * 31 + bytes[i];
        }
        return n;
    }

    static {
        Charset.forName("US-ASCII");
        UTF_8 = Charset.forName("UTF-8");
        ISO_8859_1 = Charset.forName("ISO-8859-1");
        EMPTY_BYTE_ARRAY = new byte[0];
        EMPTY_BYTE_BUFFER = ByteBuffer.wrap(EMPTY_BYTE_ARRAY);
        CodedInputStream.newInstance(EMPTY_BYTE_ARRAY);
    }

    public static interface FloatList
    extends ProtobufList<Float> {
        public FloatList mutableCopyWithCapacity$596335f8();
    }

    public static interface DoubleList
    extends ProtobufList<Double> {
        public DoubleList mutableCopyWithCapacity$43654745();
    }

    public static interface LongList
    extends ProtobufList<Long> {
        public LongList mutableCopyWithCapacity$44a51646();
    }

    public static interface BooleanList
    extends ProtobufList<Boolean> {
        public BooleanList mutableCopyWithCapacity$47858e04();
    }

    public static interface IntList
    extends ProtobufList<Integer> {
        public int getInt(int var1);

        public void addInt(int var1);

        public IntArrayList mutableCopyWithCapacity$3f369615(int var1);
    }

    public static interface ProtobufList<E>
    extends List<E>,
    RandomAccess {
        public void makeImmutable();

        public boolean isModifiable();

        public ProtobufList<E> mutableCopyWithCapacity(int var1);
    }

    public static interface EnumVerifier {
    }

    public static interface EnumLite {
        public int getNumber();
    }
}

