/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;

public class ASN1Boolean
extends ASN1Primitive {
    private static ASN1Boolean FALSE;
    private static ASN1Boolean TRUE;
    private final byte value;

    private ASN1Boolean(byte by) {
        this.value = by;
    }

    private boolean isTrue() {
        return this.value != 0;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, 1);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        byte by = this.value;
        boolean bl2 = true;
        ASN1OutputStream aSN1OutputStream2 = aSN1OutputStream;
        aSN1OutputStream2.writeIdentifier(bl, 1);
        aSN1OutputStream2.writeDL(1);
        aSN1OutputStream2.write(by);
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Boolean)) {
            return false;
        }
        aSN1Primitive = (ASN1Boolean)aSN1Primitive;
        return this.isTrue() == ((ASN1Boolean)aSN1Primitive).isTrue();
    }

    public int hashCode() {
        if (this.isTrue()) {
            return 1;
        }
        return 0;
    }

    final ASN1Primitive toDERObject() {
        if (this.isTrue()) {
            return TRUE;
        }
        return FALSE;
    }

    public String toString() {
        if (this.isTrue()) {
            return "TRUE";
        }
        return "FALSE";
    }

    static ASN1Boolean createPrimitive(byte[] byArray) {
        if (byArray.length != 1) {
            throw new IllegalArgumentException("BOOLEAN value should have 1 byte in it");
        }
        byte by = byArray[0];
        switch (by) {
            case 0: {
                return FALSE;
            }
            case -1: {
                return TRUE;
            }
        }
        return new ASN1Boolean(by);
    }

    static {
        new ASN1UniversalType(ASN1Boolean.class, 1){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1Boolean.createPrimitive(dEROctetString.string);
            }
        };
        FALSE = new ASN1Boolean(0);
        TRUE = new ASN1Boolean(-1);
    }
}

