/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;

public class ASN1Enumerated
extends ASN1Primitive {
    private final byte[] contents;
    private final int start;
    private static final ASN1Enumerated[] cache;

    private ASN1Enumerated(byte[] byArray, boolean bl) {
        if (ASN1Integer.isMalformed(byArray)) {
            throw new IllegalArgumentException("malformed enumerated");
        }
        if (0 != (byArray[0] & 0x80)) {
            throw new IllegalArgumentException("enumerated must be non-negative");
        }
        this.contents = bl ? Arrays.clone(byArray) : byArray;
        this.start = ASN1Integer.signBytesToSkip(byArray);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 10, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1Enumerated)) {
            return false;
        }
        object = (ASN1Enumerated)object;
        byte[] byArray = ((ASN1Enumerated)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static ASN1Enumerated createPrimitive(byte[] byArray, boolean bl) {
        if (byArray.length > 1) {
            return new ASN1Enumerated(byArray, bl);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("ENUMERATED has zero length");
        }
        int n = byArray[0] & 0xFF;
        if (n >= cache.length) {
            return new ASN1Enumerated(byArray, bl);
        }
        ASN1Enumerated aSN1Enumerated = cache[n];
        if (aSN1Enumerated == null) {
            aSN1Enumerated = ASN1Enumerated.cache[n] = new ASN1Enumerated(byArray, bl);
        }
        return aSN1Enumerated;
    }

    static {
        new ASN1UniversalType(ASN1Enumerated.class, 10){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1Enumerated.createPrimitive(dEROctetString.string, false);
            }
        };
        cache = new ASN1Enumerated[12];
    }
}

