/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1GeneralString
extends ASN1Primitive {
    private byte[] contents;

    ASN1GeneralString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public String toString() {
        ASN1GeneralString aSN1GeneralString = this;
        return Strings.fromByteArray(aSN1GeneralString.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 27, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1GeneralString)) {
            return false;
        }
        object = (ASN1GeneralString)object;
        byte[] byArray = ((ASN1GeneralString)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static DERGeneralString createPrimitive$5e572d3(byte[] byArray) {
        return new DERGeneralString(byArray, false);
    }

    static {
        new ASN1UniversalType(ASN1GeneralString.class, 27){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1GeneralString.createPrimitive$5e572d3(dEROctetString.string);
            }
        };
    }
}

