/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1NumericString
extends ASN1Primitive {
    private byte[] contents;

    ASN1NumericString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public String toString() {
        ASN1NumericString aSN1NumericString = this;
        return Strings.fromByteArray(aSN1NumericString.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 18, this.contents);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1NumericString)) {
            return false;
        }
        object = (ASN1NumericString)object;
        byte[] byArray = ((ASN1NumericString)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    static DERNumericString createPrimitive$ead9d0e(byte[] byArray) {
        return new DERNumericString(byArray, false);
    }

    static {
        new ASN1UniversalType(ASN1NumericString.class, 18){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1NumericString.createPrimitive$ead9d0e(dEROctetString.string);
            }
        };
    }
}

