/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.OIDTokenizer;
import org.bouncycastle.util.Arrays;

public class ASN1RelativeOID
extends ASN1Primitive {
    private final String identifier;
    private byte[] contents;

    private ASN1RelativeOID(byte[] byArray, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        BigInteger bigInteger = null;
        boolean bl2 = true;
        for (int i = 0; i != byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            if (l <= 0xFFFFFFFFFFFF80L) {
                l += (long)(n & 0x7F);
                if ((n & 0x80) == 0) {
                    if (bl2) {
                        bl2 = false;
                    } else {
                        stringBuffer.append('.');
                    }
                    stringBuffer.append(l);
                    l = 0L;
                    continue;
                }
                l <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n & 0x7F));
            if ((n & 0x80) == 0) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append('.');
                }
                stringBuffer.append(bigInteger);
                bigInteger = null;
                l = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.identifier = stringBuffer.toString();
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public int hashCode() {
        return this.identifier.hashCode();
    }

    public String toString() {
        ASN1RelativeOID aSN1RelativeOID = this;
        return aSN1RelativeOID.identifier;
    }

    final boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (this == aSN1Primitive) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1RelativeOID)) {
            return false;
        }
        aSN1Primitive = (ASN1RelativeOID)aSN1Primitive;
        return this.identifier.equals(((ASN1RelativeOID)aSN1Primitive).identifier);
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.getContents().length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 13, this.getContents());
    }

    final boolean encodeConstructed() {
        return false;
    }

    private synchronized byte[] getContents() {
        if (this.contents == null) {
            ByteArrayOutputStream byteArrayOutputStream;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream = new ByteArrayOutputStream();
            Object object = this;
            object = new OIDTokenizer(((ASN1RelativeOID)object).identifier);
            while (((OIDTokenizer)object).hasMoreTokens()) {
                String string = ((OIDTokenizer)object).nextToken();
                if (string.length() <= 18) {
                    ASN1RelativeOID.writeField(byteArrayOutputStream2, Long.parseLong(string));
                    continue;
                }
                ASN1RelativeOID.writeField(byteArrayOutputStream2, new BigInteger(string));
            }
            this.contents = byteArrayOutputStream.toByteArray();
        }
        return this.contents;
    }

    static ASN1RelativeOID createPrimitive(byte[] byArray, boolean bl) {
        return new ASN1RelativeOID(byArray, false);
    }

    static boolean isValidIdentifier(String string, int n) {
        int n2 = 0;
        int n3 = string.length();
        while (--n3 >= n) {
            char c = string.charAt(n3);
            if (c == '.') {
                if (n2 == 0 || n2 > 1 && string.charAt(n3 + 1) == '0') {
                    return false;
                }
                n2 = 0;
                continue;
            }
            if ('0' <= c && c <= '9') {
                ++n2;
                continue;
            }
            return false;
        }
        return n2 != 0 && (n2 <= true || string.charAt(n3 + 1) != '0');
    }

    static void writeField(ByteArrayOutputStream byteArrayOutputStream, long l) {
        byte[] byArray = new byte[9];
        int n = 8;
        byArray[8] = (byte)((int)l & 0x7F);
        while (l >= 128L) {
            byArray[--n] = (byte)((int)(l >>= 7) | 0x80);
        }
        byteArrayOutputStream.write(byArray, n, 9 - n);
    }

    static void writeField(ByteArrayOutputStream byteArrayOutputStream, BigInteger bigInteger) {
        int n = (bigInteger.bitLength() + 6) / 7;
        if (n == 0) {
            byteArrayOutputStream.write(0);
            return;
        }
        byte[] byArray = new byte[n];
        for (int i = n - 1; i >= 0; --i) {
            byArray[i] = (byte)(bigInteger.intValue() | 0x80);
            bigInteger = bigInteger.shiftRight(7);
        }
        int n2 = n - 1;
        byArray[n2] = (byte)(byArray[n2] & 0x7F);
        byteArrayOutputStream.write(byArray, 0, byArray.length);
    }

    static {
        new ASN1UniversalType(ASN1RelativeOID.class, 13){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1RelativeOID.createPrimitive(dEROctetString.string, false);
            }
        };
    }
}

