/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public abstract class ASN1T61String
extends ASN1Primitive {
    private byte[] contents;

    ASN1T61String(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public String toString() {
        ASN1T61String aSN1T61String = this;
        return Strings.fromByteArray(aSN1T61String.contents);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 20, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1T61String)) {
            return false;
        }
        object = (ASN1T61String)object;
        byte[] byArray = ((ASN1T61String)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static DERT61String createPrimitive$363cfbd4(byte[] byArray) {
        return new DERT61String(byArray, false);
    }

    static {
        new ASN1UniversalType(ASN1T61String.class, 20){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1T61String.createPrimitive$363cfbd4(dEROctetString.string);
            }
        };
    }
}

