/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.util.Arrays;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObjectParser;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.ASN1Util;
import org.bouncycastle.asn1.BERApplicationSpecific;
import org.bouncycastle.asn1.BERFactory;
import org.bouncycastle.asn1.BERTaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLApplicationSpecific;
import org.bouncycastle.asn1.DLFactory;
import org.bouncycastle.asn1.DLTaggedObject;

public abstract class ASN1TaggedObject
extends ASN1Primitive
implements ASN1TaggedObjectParser {
    private int explicitness;
    final int tagClass;
    final int tagNo;
    final ASN1Encodable obj;

    public static ASN1TaggedObject getInstance$74894196(ASN1Encodable aSN1Encodable) {
        ASN1Primitive aSN1Primitive;
        if (aSN1Encodable == null || aSN1Encodable instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)aSN1Encodable;
        }
        if (aSN1Encodable instanceof ASN1Encodable && (aSN1Primitive = aSN1Encodable.toASN1Primitive()) instanceof ASN1TaggedObject) {
            return (ASN1TaggedObject)aSN1Primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + aSN1Encodable.getClass().getName());
    }

    protected ASN1TaggedObject(boolean bl, int n, ASN1Encodable aSN1Encodable) {
        this(bl, 128, n, aSN1Encodable);
    }

    private ASN1TaggedObject(boolean bl, int n, int n2, ASN1Encodable aSN1Encodable) {
        this(bl ? 1 : 2, 128, n2, aSN1Encodable);
    }

    ASN1TaggedObject(int n, int n2, int n3, ASN1Encodable aSN1Encodable) {
        if (aSN1Encodable == null) {
            throw new NullPointerException("'obj' cannot be null");
        }
        if (n2 == 0 || (n2 & 0xC0) != n2) {
            throw new IllegalArgumentException("invalid tag class: " + n2);
        }
        this.explicitness = aSN1Encodable instanceof ASN1Choice ? 1 : n;
        this.tagClass = n2;
        this.tagNo = n3;
        this.obj = aSN1Encodable;
    }

    final boolean asn1Equals(ASN1Primitive object) {
        ASN1Primitive aSN1Primitive;
        if (object instanceof ASN1ApplicationSpecific) {
            return ((ASN1Primitive)object).equals(this);
        }
        if (!(object instanceof ASN1TaggedObject)) {
            return false;
        }
        object = (ASN1TaggedObject)object;
        if (this.tagNo != ((ASN1TaggedObject)object).tagNo || this.tagClass != ((ASN1TaggedObject)object).tagClass) {
            return false;
        }
        if (this.explicitness != ((ASN1TaggedObject)object).explicitness && this.isExplicit() != ((ASN1TaggedObject)object).isExplicit()) {
            return false;
        }
        Object object2 = this.obj.toASN1Primitive();
        if (object2 == (aSN1Primitive = ((ASN1TaggedObject)object).obj.toASN1Primitive())) {
            return true;
        }
        if (!this.isExplicit()) {
            try {
                object2 = this.getEncoded();
                object = ((ASN1Object)object).getEncoded();
                Object object3 = object2;
                object2 = object;
                object = object3;
                return Arrays.equals((byte[])object3, (byte[])object2);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return ((ASN1Primitive)object2).asn1Equals(aSN1Primitive);
    }

    public int hashCode() {
        return this.tagClass * 7919 ^ this.tagNo ^ (this.isExplicit() ? 15 : 240) ^ this.obj.toASN1Primitive().hashCode();
    }

    public final int getTagNo() {
        return this.tagNo;
    }

    public final boolean isExplicit() {
        switch (this.explicitness) {
            case 1: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    final ASN1Primitive getBaseUniversal(boolean bl, ASN1UniversalType aSN1UniversalType) {
        if (bl) {
            if (!this.isExplicit()) {
                throw new IllegalStateException("object explicit - implicit expected.");
            }
            return aSN1UniversalType.checkedCast(this.obj.toASN1Primitive());
        }
        if (1 == this.explicitness) {
            throw new IllegalStateException("object explicit - implicit expected.");
        }
        ASN1Primitive aSN1Primitive = this.obj.toASN1Primitive();
        switch (this.explicitness) {
            case 3: {
                return aSN1UniversalType.fromImplicitConstructed(this.rebuildConstructed(aSN1Primitive));
            }
            case 4: {
                if (aSN1Primitive instanceof ASN1Sequence) {
                    return aSN1UniversalType.fromImplicitConstructed((ASN1Sequence)aSN1Primitive);
                }
                return aSN1UniversalType.fromImplicitPrimitive((DEROctetString)aSN1Primitive);
            }
        }
        return aSN1UniversalType.checkedCast(aSN1Primitive);
    }

    public final ASN1Primitive getLoadedObject() {
        return this;
    }

    abstract ASN1Sequence rebuildConstructed(ASN1Primitive var1);

    ASN1Primitive toDERObject() {
        return new DERTaggedObject(this.explicitness, this.tagClass, this.tagNo, this.obj);
    }

    ASN1Primitive toDLObject() {
        return new DLTaggedObject(this.explicitness, this.tagClass, this.tagNo, this.obj);
    }

    public String toString() {
        return ASN1Util.getTagText(this.tagClass, this.tagNo) + this.obj;
    }

    static ASN1Primitive createConstructedDL(int n, int n2, ASN1EncodableVector aSN1EncodableVector) {
        boolean bl = aSN1EncodableVector.size() == 1;
        DLTaggedObject dLTaggedObject = bl ? new DLTaggedObject(3, n, n2, aSN1EncodableVector.get(0)) : new DLTaggedObject(4, n, n2, DLFactory.createSequence(aSN1EncodableVector));
        switch (n) {
            case 64: {
                return new DLApplicationSpecific(dLTaggedObject);
            }
        }
        return dLTaggedObject;
    }

    static ASN1Primitive createConstructedIL(int n, int n2, ASN1EncodableVector aSN1EncodableVector) {
        boolean bl = aSN1EncodableVector.size() == 1;
        BERTaggedObject bERTaggedObject = bl ? new BERTaggedObject(3, n, n2, aSN1EncodableVector.get(0)) : new BERTaggedObject(4, n, n2, BERFactory.createSequence(aSN1EncodableVector));
        switch (n) {
            case 64: {
                return new BERApplicationSpecific(bERTaggedObject);
            }
        }
        return bERTaggedObject;
    }

    static ASN1Primitive createPrimitive(int n, int n2, byte[] byArray) {
        DLTaggedObject dLTaggedObject = new DLTaggedObject(4, n, n2, new DEROctetString(byArray));
        switch (n) {
            case 64: {
                return new DLApplicationSpecific(dLTaggedObject);
            }
        }
        return dLTaggedObject;
    }
}

