/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.util.Arrays;

public abstract class ASN1UniversalString
extends ASN1Primitive {
    private static final char[] table;
    private byte[] contents;

    ASN1UniversalString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    public String toString() {
        ASN1UniversalString aSN1UniversalString = this;
        int n = aSN1UniversalString.contents.length;
        StringBuffer stringBuffer = new StringBuffer(3 + 2 * (ASN1OutputStream.getLengthOfDL(n) + n));
        stringBuffer.append("#1C");
        int n2 = n;
        StringBuffer stringBuffer2 = stringBuffer;
        if (n2 < 128) {
            ASN1UniversalString.encodeHexByte(stringBuffer2, n2);
        } else {
            byte[] byArray = new byte[5];
            int n3 = 5;
            do {
                byArray[--n3] = (byte)n2;
            } while ((n2 >>>= 8) != 0);
            n2 = byArray.length - n3;
            byArray[--n3] = (byte)(0x80 | n2);
            do {
                ASN1UniversalString.encodeHexByte(stringBuffer2, byArray[n3++]);
            } while (n3 < byArray.length);
        }
        for (int i = 0; i < n; ++i) {
            ASN1UniversalString.encodeHexByte(stringBuffer, aSN1UniversalString.contents[i]);
        }
        return stringBuffer.toString();
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 28, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1UniversalString)) {
            return false;
        }
        object = (ASN1UniversalString)object;
        byte[] byArray = ((ASN1UniversalString)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static DERUniversalString createPrimitive$3c9d2830(byte[] byArray) {
        return new DERUniversalString(byArray, false);
    }

    private static void encodeHexByte(StringBuffer stringBuffer, int n) {
        stringBuffer.append(table[n >>> 4 & 0xF]);
        stringBuffer.append(table[n & 0xF]);
    }

    static {
        new ASN1UniversalType(ASN1UniversalString.class, 28){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1UniversalString.createPrimitive$3c9d2830(dEROctetString.string);
            }
        };
        table = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

