/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1UniversalType;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERVideotexString;
import org.bouncycastle.util.Arrays;

public abstract class ASN1VideotexString
extends ASN1Primitive {
    private byte[] contents;

    ASN1VideotexString(byte[] byArray, boolean bl) {
        this.contents = bl ? Arrays.clone(byArray) : byArray;
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.writeEncodingDL(bl, 21, this.contents);
    }

    final boolean asn1Equals(ASN1Primitive object) {
        if (!(object instanceof ASN1VideotexString)) {
            return false;
        }
        object = (ASN1VideotexString)object;
        byte[] byArray = ((ASN1VideotexString)object).contents;
        object = this.contents;
        return java.util.Arrays.equals(this.contents, byArray);
    }

    public final int hashCode() {
        return Arrays.hashCode(this.contents);
    }

    static DERVideotexString createPrimitive$44587d93(byte[] byArray) {
        return new DERVideotexString(byArray, false);
    }

    static {
        new ASN1UniversalType(ASN1VideotexString.class, 21){

            final ASN1Primitive fromImplicitPrimitive(DEROctetString dEROctetString) {
                return ASN1VideotexString.createPrimitive$44587d93(dEROctetString.string);
            }
        };
    }
}

