/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.DLBitString;

public final class BERBitString
extends ASN1BitString {
    private final int segmentLimit;
    private final ASN1BitString[] elements;

    static byte[] flattenBitStrings(ASN1BitString[] aSN1BitStringArray) {
        int n = aSN1BitStringArray.length;
        switch (n) {
            case 0: {
                return new byte[]{0};
            }
            case 1: {
                return aSN1BitStringArray[0].contents;
            }
        }
        int n2 = n - 1;
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            byte[] byArray = aSN1BitStringArray[i].contents;
            if (aSN1BitStringArray[i].contents[0] != 0) {
                throw new IllegalArgumentException("only the last nested bitstring can have padding");
            }
            n3 += byArray.length - 1;
        }
        byte[] byArray = aSN1BitStringArray[n2].contents;
        byte by = aSN1BitStringArray[n2].contents[0];
        byte[] byArray2 = new byte[n3 += byArray.length];
        byte[] byArray3 = byArray2;
        byArray2[0] = by;
        n3 = 1;
        for (int i = 0; i < n; ++i) {
            byte[] byArray4 = aSN1BitStringArray[i].contents;
            int n4 = aSN1BitStringArray[i].contents.length - 1;
            System.arraycopy(byArray4, 1, byArray3, n3, n4);
            n3 += n4;
        }
        return byArray3;
    }

    public BERBitString(byte[] byArray, int n) {
        this(byArray, n, 1000);
    }

    private BERBitString(byte[] byArray, int n, int n2) {
        super(byArray, n);
        this.elements = null;
        this.segmentLimit = 1000;
    }

    public BERBitString(ASN1BitString[] aSN1BitStringArray) {
        this(aSN1BitStringArray, 1000);
    }

    private BERBitString(ASN1BitString[] aSN1BitStringArray, int n) {
        super(BERBitString.flattenBitStrings(aSN1BitStringArray), false);
        this.elements = aSN1BitStringArray;
        this.segmentLimit = 1000;
    }

    final boolean encodeConstructed() {
        return this.elements != null || this.contents.length > this.segmentLimit;
    }

    /*
     * WARNING - void declaration
     */
    final int encodedLength(boolean bl) throws IOException {
        void var1_9;
        int n;
        if (!this.encodeConstructed()) {
            int n2 = this.contents.length;
            boolean bl2 = bl;
            return ASN1OutputStream.getLengthOfEncodingDL(bl2, n2);
        }
        int n3 = n = bl ? 4 : 3;
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                var1_4 += this.elements[i].encodedLength(true);
            }
        } else if (this.contents.length >= 2) {
            int n4 = (this.contents.length - 2) / (this.segmentLimit - 1);
            int n5 = this.segmentLimit;
            boolean bl3 = true;
            int n6 = n + n4 * ASN1OutputStream.getLengthOfEncodingDL(true, n5);
            n5 = n4 = this.contents.length - n4 * (this.segmentLimit - 1);
            boolean bl4 = true;
            int n7 = n6 + ASN1OutputStream.getLengthOfEncodingDL(true, n5);
        }
        return (int)var1_9;
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        if (!this.encodeConstructed()) {
            int n = this.contents.length;
            boolean bl2 = false;
            byte[] byArray = this.contents;
            boolean bl3 = bl;
            ASN1OutputStream aSN1OutputStream2 = aSN1OutputStream;
            aSN1OutputStream2.writeEncodingDL(bl3, 3, byArray, 0, n);
            return;
        }
        aSN1OutputStream.writeIdentifier(bl, 35);
        aSN1OutputStream.write(128);
        if (this.elements != null) {
            aSN1OutputStream.writePrimitives(this.elements);
        } else if (this.contents.length >= 2) {
            int n;
            byte by = this.contents[0];
            int n2 = this.contents.length;
            int n3 = this.segmentLimit - 1;
            for (n = n2 - 1; n > n3; n -= n3) {
                DLBitString.encode(aSN1OutputStream, true, (byte)0, this.contents, n2 - n, n3);
            }
            DLBitString.encode(aSN1OutputStream, true, by, this.contents, n2 - n, n);
        }
        aSN1OutputStream.write(0);
        aSN1OutputStream.write(0);
    }
}

