/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1BitStringParser;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BERBitString;
import org.bouncycastle.asn1.ConstructedBitStream;
import org.bouncycastle.util.io.Streams;

public final class BERBitStringParser
implements ASN1BitStringParser {
    private ASN1StreamParser _parser;
    private ConstructedBitStream _bitStream;

    BERBitStringParser(ASN1StreamParser aSN1StreamParser) {
        this._parser = aSN1StreamParser;
    }

    public final InputStream getBitStream() throws IOException {
        this._bitStream = new ConstructedBitStream(this._parser, false);
        return this._bitStream;
    }

    public final int getPadBits() {
        return this._bitStream.getPadBits();
    }

    public final ASN1Primitive getLoadedObject() throws IOException {
        return BERBitStringParser.parse(this._parser);
    }

    public final ASN1Primitive toASN1Primitive() {
        try {
            BERBitStringParser bERBitStringParser = this;
            return BERBitStringParser.parse(bERBitStringParser._parser);
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("IOException converting stream to byte array: " + iOException.getMessage(), iOException);
        }
    }

    static BERBitString parse(ASN1StreamParser object) throws IOException {
        object = new ConstructedBitStream((ASN1StreamParser)object, false);
        byte[] byArray = Streams.readAll((InputStream)object);
        int n = ((ConstructedBitStream)object).getPadBits();
        return new BERBitString(byArray, n);
    }
}

