/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;

public final class DERBitString
extends ASN1BitString {
    public static DERBitString getInstance(Object object) {
        if (object == null || object instanceof DERBitString) {
            return (DERBitString)object;
        }
        if (object instanceof ASN1BitString) {
            object = (ASN1BitString)object;
            return (DERBitString)((ASN1BitString)object).toDERObject();
        }
        if (object instanceof byte[]) {
            try {
                object = (ASN1BitString)DERBitString.fromByteArray((byte[])object);
                return (DERBitString)((ASN1BitString)object).toDERObject();
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + object.getClass().getName());
    }

    public static DERBitString getInstance(ASN1TaggedObject aSN1Primitive, boolean bl) {
        ASN1TaggedObject aSN1TaggedObject = aSN1Primitive;
        if (128 != aSN1TaggedObject.tagClass) {
            throw new IllegalStateException("this method only valid for CONTEXT_SPECIFIC tags");
        }
        aSN1Primitive = aSN1Primitive.obj.toASN1Primitive();
        if (aSN1Primitive instanceof DERBitString) {
            return DERBitString.getInstance(aSN1Primitive);
        }
        aSN1TaggedObject = aSN1Primitive = ASN1OctetString.getInstance(aSN1Primitive);
        return new DERBitString(((ASN1OctetString)((Object)aSN1TaggedObject)).string, true);
    }

    public DERBitString(byte[] byArray) {
        this(byArray, 0);
    }

    private DERBitString(byte[] byArray, int n) {
        super(byArray, 0);
    }

    public DERBitString(ASN1Encodable aSN1Encodable) throws IOException {
        super(aSN1Encodable.toASN1Primitive().getEncoded("DER"), 0);
    }

    DERBitString(byte[] byArray, boolean bl) {
        super(byArray, bl);
    }

    final boolean encodeConstructed() {
        return false;
    }

    final int encodedLength(boolean bl) {
        return ASN1OutputStream.getLengthOfEncodingDL(bl, this.contents.length);
    }

    final void encode(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        byte by;
        byte by2;
        int by22 = this.contents[0] & 0xFF;
        int n = this.contents.length;
        if ((by2 = this.contents[--n]) == (by = (byte)(this.contents[n] & 255 << by22))) {
            aSN1OutputStream.writeEncodingDL(bl, 3, this.contents);
            return;
        }
        aSN1OutputStream.writeEncodingDL(bl, 3, this.contents, 0, n, by);
    }

    final ASN1Primitive toDERObject() {
        return this;
    }

    final ASN1Primitive toDLObject() {
        return this;
    }
}

