/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.LimitedInputStream;
import org.bouncycastle.util.io.Streams;

final class DefiniteLengthInputStream
extends LimitedInputStream {
    private static final byte[] EMPTY_BYTES = new byte[0];
    private final int _originalLength;
    private int _remaining;

    DefiniteLengthInputStream(InputStream inputStream, int n, int n2) {
        super(inputStream, n2);
        if (n <= 0) {
            if (n < 0) {
                throw new IllegalArgumentException("negative lengths not allowed");
            }
            this.setParentEofDetect(true);
        }
        this._originalLength = n;
        this._remaining = n;
    }

    final int getRemaining() {
        return this._remaining;
    }

    public final int read() throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n = this._in.read();
        if (n < 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        if (--this._remaining == 0) {
            this.setParentEofDetect(true);
        }
        return n;
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this._remaining == 0) {
            return -1;
        }
        int n3 = this._in.read(byArray, n, n2 = Math.min(n2, this._remaining));
        if (n3 < 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        if ((this._remaining -= n3) == 0) {
            this.setParentEofDetect(true);
        }
        return n3;
    }

    final void readAllIntoByteArray(byte[] byArray) throws IOException {
        if (this._remaining != byArray.length) {
            throw new IllegalArgumentException("buffer length not right for data");
        }
        if (this._remaining == 0) {
            return;
        }
        int n = this.getLimit();
        if (this._remaining >= n) {
            throw new IOException("corrupted stream - out of bounds length found: " + this._remaining + " >= " + n);
        }
        if ((this._remaining -= Streams.readFully(this._in, byArray, 0, byArray.length)) != 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        this.setParentEofDetect(true);
    }

    final byte[] toByteArray() throws IOException {
        if (this._remaining == 0) {
            return EMPTY_BYTES;
        }
        int n = this.getLimit();
        if (this._remaining >= n) {
            throw new IOException("corrupted stream - out of bounds length found: " + this._remaining + " >= " + n);
        }
        byte[] byArray = new byte[this._remaining];
        if ((this._remaining -= Streams.readFully(this._in, byArray, 0, byArray.length)) != 0) {
            throw new EOFException("DEF length " + this._originalLength + " object truncated by " + this._remaining);
        }
        this.setParentEofDetect(true);
        return byArray;
    }
}

